/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.generators;

import java.util.Collection;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataUpdater;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.workflow.SW360ConnectionConfigurationFactory;
import org.eclipse.sw360.antenna.sw360.workflow.generators.SW360UpdaterImpl;

public class SW360Updater
extends AbstractGenerator {
    private static final String UPDATE_RELEASES = "update_releases";
    private static final String UPLOAD_SOURCES = "upload_sources";
    private final SW360ConnectionConfigurationFactory connectionFactory;
    private String projectName;
    private String projectVersion;
    private SW360MetaDataUpdater sw360MetaDataUpdater;
    private SW360UpdaterImpl updaterImpl;

    public SW360Updater() {
        this(new SW360ConnectionConfigurationFactory());
    }

    SW360Updater(SW360ConnectionConfigurationFactory factory) {
        this.connectionFactory = factory;
        this.workflowStepOrder = (short)1100;
    }

    public void configure(Map<String, String> configMap) {
        this.projectName = this.getProjectName();
        this.projectVersion = this.getProjectVersion();
        SW360Connection sw360Connection = this.getConnectionFactory().createConnection(key -> this.getConfigValue(key, configMap), this.context.getHttpClient(), this.context.getObjectMapper());
        boolean updateReleases = this.getBooleanConfigValue(UPDATE_RELEASES, configMap);
        Boolean uploadSources = this.getBooleanConfigValue(UPLOAD_SOURCES, configMap);
        this.sw360MetaDataUpdater = new SW360MetaDataUpdater(sw360Connection, updateReleases, uploadSources);
    }

    private String getProjectVersion() {
        return this.context.getToolConfiguration().getVersion() != null ? this.context.getToolConfiguration().getVersion() : this.context.getProject().getVersion();
    }

    private String getProjectName() {
        return this.context.getToolConfiguration().getProductFullName() != null ? this.context.getToolConfiguration().getProductFullName() : this.context.getProject().getProjectId();
    }

    public Map<String, IAttachable> produce(Collection<Artifact> intermediates) {
        return this.updaterImpl == null ? new SW360UpdaterImpl(this.sw360MetaDataUpdater, this.projectName, this.projectVersion).produce(intermediates) : this.updaterImpl.produce(intermediates);
    }

    public void setUpdaterImpl(SW360UpdaterImpl updaterImpl) {
        this.updaterImpl = updaterImpl;
    }

    SW360ConnectionConfigurationFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

