/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.generators;

import java.util.Collection;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataUpdater;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.workflow.SW360ConnectionConfigurationFactory;
import org.eclipse.sw360.antenna.sw360.workflow.generators.SW360UpdaterImpl;

public class SW360Updater
extends AbstractGenerator {
    private static final String UPDATE_RELEASES = "update_releases";
    private static final String UPLOAD_SOURCES = "upload_sources";
    private static final String DELETE_OBSOLETE_SOURCES = "delete_obsolete_sources";
    private final SW360ConnectionConfigurationFactory connectionFactory;
    private SW360UpdaterImpl updaterImpl;

    public SW360Updater() {
        this(new SW360ConnectionConfigurationFactory());
    }

    SW360Updater(SW360ConnectionConfigurationFactory factory) {
        this.connectionFactory = factory;
        this.workflowStepOrder = (short)1100;
    }

    public void configure(Map<String, String> configMap) {
        this.updaterImpl = this.createUpdaterImpl(configMap);
    }

    private String getProjectVersion() {
        return this.context.getToolConfiguration().getVersion() != null ? this.context.getToolConfiguration().getVersion() : this.context.getProject().getVersion();
    }

    private String getProjectName() {
        return this.context.getToolConfiguration().getProductFullName() != null ? this.context.getToolConfiguration().getProductFullName() : this.context.getProject().getProjectId();
    }

    public Map<String, IAttachable> produce(Collection<Artifact> intermediates) {
        return this.updaterImpl.produce(intermediates);
    }

    SW360UpdaterImpl createUpdaterImpl(Map<String, String> configMap) {
        SW360Connection sw360Connection = this.getConnectionFactory().createConnection(key -> this.getConfigValue(key, configMap), this.context.getHttpClient(), this.context.getObjectMapper());
        SW360MetaDataUpdater sw360MetaDataUpdater = new SW360MetaDataUpdater(sw360Connection);
        return new SW360UpdaterImpl(sw360MetaDataUpdater, this.getProjectName(), this.getProjectVersion(), this.getBooleanConfigValue(UPDATE_RELEASES, configMap), this.getBooleanConfigValue(UPLOAD_SOURCES, configMap), this.getBooleanConfigValue(DELETE_OBSOLETE_SOURCES, configMap));
    }

    SW360ConnectionConfigurationFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

