/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.generators;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.util.ArtifactLicenseUtils;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataUpdater;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadResult;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseLinkObjects;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToAttachmentUtils;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToReleaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360UpdaterImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360UpdaterImpl.class);
    private final String projectName;
    private final String projectVersion;
    private final SW360MetaDataUpdater sw360MetaDataUpdater;
    private final boolean updateReleases;
    private final boolean uploadSources;
    private final boolean deleteObsoleteSourceAttachments;

    public SW360UpdaterImpl(SW360MetaDataUpdater sw360MetaDataUpdater, String projectName, String projectVersion, boolean updateReleases, boolean uploadSources, boolean deleteObsoleteSourceAttachments) {
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.sw360MetaDataUpdater = sw360MetaDataUpdater;
        this.updateReleases = updateReleases;
        this.uploadSources = uploadSources;
        this.deleteObsoleteSourceAttachments = deleteObsoleteSourceAttachments;
    }

    public boolean isUpdateReleases() {
        return this.updateReleases;
    }

    public boolean isUploadSources() {
        return this.uploadSources;
    }

    public boolean isDeleteObsoleteSourceAttachments() {
        return this.deleteObsoleteSourceAttachments;
    }

    public Map<String, IAttachable> produce(Collection<Artifact> intermediates) {
        ArrayList<SW360Release> releases = new ArrayList<SW360Release>();
        for (Artifact artifact : intermediates) {
            try {
                SW360Release sw360ReleaseFinal = this.artifactToReleaseInSW360(artifact);
                releases.add(sw360ReleaseFinal);
            }
            catch (ExecutionException e) {
                LOGGER.error("Release will not be created in SW360. Reason: {}", (Object)e.getMessage());
                LOGGER.debug("Error: ", (Throwable)e);
            }
        }
        this.sw360MetaDataUpdater.createProject(this.projectName, this.projectVersion, releases);
        return Collections.emptyMap();
    }

    public SW360Release artifactToReleaseInSW360(Artifact artifact) {
        SW360Release sw360ReleaseFromArtifact = ArtifactToReleaseUtils.convertToReleaseWithoutAttachments(artifact);
        return this.artifactToReleaseInSW360(artifact, sw360ReleaseFromArtifact);
    }

    public SW360Release artifactToReleaseInSW360(Artifact artifact, SW360Release release) {
        Set<String> licenseIds = this.getSetOfLicenseIds(artifact);
        release.setMainLicenseIds(licenseIds);
        SW360Release sw360ReleaseFinal = this.sw360MetaDataUpdater.getOrCreateRelease(release, this.isUpdateReleases());
        sw360ReleaseFinal = (SW360Release)this.uploadSourceAndAttachments(sw360ReleaseFinal, artifact, Collections.emptyMap()).getTarget();
        return sw360ReleaseFinal;
    }

    public AttachmentUploadResult<SW360Release> artifactToReleaseWithUploads(Artifact artifact, SW360Release release, Map<Path, SW360AttachmentType> uploads) {
        Set<String> licenseIds = this.getSetOfLicenseIds(artifact);
        release.setMainLicenseIds(licenseIds);
        SW360Release sw360ReleaseFinal = this.sw360MetaDataUpdater.getOrCreateRelease(release, this.isUpdateReleases());
        return this.uploadSourceAndAttachments(sw360ReleaseFinal, artifact, uploads);
    }

    private AttachmentUploadResult<SW360Release> uploadSourceAndAttachments(SW360Release release, Artifact artifact, Map<Path, SW360AttachmentType> uploads) {
        Optional<Path> optSrcPath = ArtifactToAttachmentUtils.getSourceAttachmentFromArtifact(artifact);
        String srcFileName = optSrcPath.map(path -> path.getFileName().toString()).orElse(null);
        SW360Release srcDeletedRelease = this.deleteSourceAttachments(release, srcFileName);
        HashMap<Path, SW360AttachmentType> allUploads = new HashMap<Path, SW360AttachmentType>(uploads);
        if (this.isUploadSources() && ((SW360ReleaseLinkObjects)release.getLinks()).getSelf() != null && !((SW360ReleaseLinkObjects)release.getLinks()).getSelf().getHref().isEmpty()) {
            optSrcPath.ifPresent(srcPath -> allUploads.put((Path)srcPath, SW360AttachmentType.SOURCE));
        }
        if (!allUploads.isEmpty()) {
            return this.sw360MetaDataUpdater.uploadAttachments(srcDeletedRelease, allUploads, this.isDeleteObsoleteSourceAttachments());
        }
        return new AttachmentUploadResult((SW360HalResource)srcDeletedRelease);
    }

    private SW360Release deleteSourceAttachments(SW360Release release, String srcFileName) {
        try {
            return this.isDeleteObsoleteSourceAttachments() ? this.sw360MetaDataUpdater.deleteAttachments(release, this.deleteAttachmentsPredicate(srcFileName)) : release;
        }
        catch (SW360ClientException e) {
            LOGGER.warn("Could not delete source attachments for release {}:{}", new Object[]{release.getName(), release.getVersion(), e});
            return release;
        }
    }

    private Predicate<SW360SparseAttachment> deleteAttachmentsPredicate(String srcFileName) {
        Predicate<SW360SparseAttachment> sourceTypePredicate = attachment -> attachment.getAttachmentType() == SW360AttachmentType.SOURCE;
        return srcFileName == null ? sourceTypePredicate : sourceTypePredicate.and(attachment -> !srcFileName.equals(attachment.getFilename()));
    }

    private Set<String> getSetOfLicenseIds(Artifact artifact) {
        Collection availableLicenses = ArtifactLicenseUtils.getFinalLicenses((Artifact)artifact).getLicenses();
        Set<SW360License> detectedLicenses = this.sw360MetaDataUpdater.getLicenses(availableLicenses);
        Set<String> licenseIds = Collections.emptySet();
        if (detectedLicenses.size() == availableLicenses.size()) {
            licenseIds = detectedLicenses.stream().map(SW360License::getShortName).collect(Collectors.toSet());
        }
        return licenseIds;
    }
}

