/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.processors;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataReceiver;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.workflow.SW360ConnectionConfigurationFactory;
import org.eclipse.sw360.antenna.sw360.workflow.processors.SW360EnricherImpl;

public class SW360Enricher
extends AbstractProcessor {
    private static final String DOWNLOAD_ATTACHMENTS = "download.attachments";
    private static final String DOWNLOAD_ATTACHMENTS_DIR = "download.directory";
    private final SW360ConnectionConfigurationFactory connectionFactory;
    private boolean downloadAttachments;
    private Path downloadPath;
    private SW360MetaDataReceiver connector;

    public SW360Enricher() {
        this(new SW360ConnectionConfigurationFactory());
    }

    SW360Enricher(SW360ConnectionConfigurationFactory factory) {
        this.connectionFactory = factory;
        this.workflowStepOrder = (short)1300;
    }

    public void configure(Map<String, String> configMap) {
        super.configure(configMap);
        this.reporter = this.context.getProcessingReporter();
        this.downloadAttachments = this.getBooleanConfigValue(DOWNLOAD_ATTACHMENTS, configMap);
        if (this.downloadAttachments) {
            this.downloadPath = Paths.get(this.getConfigValue(DOWNLOAD_ATTACHMENTS_DIR, configMap, this.context.getToolConfiguration().getAntennaTargetDirectory().toString()), new String[0]).normalize().toAbsolutePath();
        }
        this.connector = this.createMetaDataReceiver(configMap);
    }

    public Collection<Artifact> process(Collection<Artifact> intermediates) {
        return new SW360EnricherImpl(this.reporter, this.connector, this.downloadAttachments, this.downloadPath).process(intermediates);
    }

    SW360MetaDataReceiver createMetaDataReceiver(Map<String, String> configMap) {
        SW360Connection connection = this.getConnectionFactory().createConnection(key -> this.getConfigValue(key, configMap), this.context.getHttpClient(), this.context.getObjectMapper());
        return new SW360MetaDataReceiver(connection);
    }

    SW360ConnectionConfigurationFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

