/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadRequest;
import org.eclipse.sw360.antenna.sw360.client.adapter.AttachmentUploadResult;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360AttachmentUtils;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360Connection;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360LicenseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ProjectClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.adapter.SW360ReleaseClientAdapter;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360HalResource;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.SW360Visibility;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360Project;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.projects.SW360ProjectType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.antenna.sw360.client.utils.SW360ClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360MetaDataUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360MetaDataUpdater.class);
    private final SW360ProjectClientAdapter projectClientAdapter;
    private final SW360LicenseClientAdapter licenseClientAdapter;
    private final SW360ReleaseClientAdapter releaseClientAdapter;
    private final AtomicReference<Set<String>> knownSW360LicenseIds;

    public SW360MetaDataUpdater(SW360Connection connection) {
        this.projectClientAdapter = connection.getProjectAdapter();
        this.licenseClientAdapter = connection.getLicenseAdapter();
        this.releaseClientAdapter = connection.getReleaseAdapter();
        this.knownSW360LicenseIds = new AtomicReference();
    }

    public Set<SW360License> getLicenses(Collection<License> licenses) {
        return licenses.stream().filter(this::isLicenseInSW360).map(license -> this.licenseClientAdapter.getLicenseByName(license.getId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private boolean isLicenseInSW360(License license) {
        if (this.getSW360Licenses().contains(license.getId())) {
            LOGGER.debug("License [{}] found in SW360.", (Object)license.getId());
            return true;
        }
        LOGGER.debug("License [{}] unknown in SW360.", (Object)license.getId());
        return false;
    }

    private Set<String> getSW360Licenses() {
        Set<String> licenseIds = this.knownSW360LicenseIds.get();
        while (licenseIds == null) {
            licenseIds = this.loadLicensesFromSW360();
            if (this.knownSW360LicenseIds.compareAndSet(null, licenseIds)) continue;
            licenseIds = this.knownSW360LicenseIds.get();
        }
        return licenseIds;
    }

    private Set<String> loadLicensesFromSW360() {
        LOGGER.info("Querying existing licenses from SW360.");
        return this.licenseClientAdapter.getLicenses().stream().map(SW360SparseLicense::getShortName).collect(Collectors.toSet());
    }

    public SW360Release getOrCreateRelease(SW360Release sw360ReleaseFromArtifact, boolean updateExisting) {
        Optional optSparseReleaseByIds = this.releaseClientAdapter.getSparseReleaseByExternalIds(sw360ReleaseFromArtifact.getExternalIds());
        Optional optSparseRelease = optSparseReleaseByIds.isPresent() ? optSparseReleaseByIds : this.releaseClientAdapter.getSparseReleaseByNameAndVersion(sw360ReleaseFromArtifact.getName(), sw360ReleaseFromArtifact.getVersion());
        Optional<SW360Release> optRelease = optSparseRelease.flatMap(arg_0 -> ((SW360ReleaseClientAdapter)this.releaseClientAdapter).enrichSparseRelease(arg_0)).map(arg_0 -> ((SW360Release)sw360ReleaseFromArtifact).mergeWith(arg_0));
        if (optRelease.isPresent()) {
            SW360Release release = optRelease.get();
            return updateExisting ? this.releaseClientAdapter.updateRelease(release) : release;
        }
        return this.releaseClientAdapter.createRelease(sw360ReleaseFromArtifact);
    }

    public void createProject(String projectName, String projectVersion, Collection<SW360Release> releases) {
        Optional<String> projectId = this.projectClientAdapter.getProjectByNameAndVersion(projectName, projectVersion).map(SW360HalResource::getId);
        String id = projectId.orElseGet(() -> this.projectClientAdapter.createProject(SW360MetaDataUpdater.prepareNewProject(projectName, projectVersion)).getId());
        this.projectClientAdapter.addSW360ReleasesToSW360Project(id, releases);
    }

    public AttachmentUploadResult<SW360Release> uploadAttachments(SW360Release sw360Release, Map<Path, SW360AttachmentType> attachments, boolean force) {
        HashSet<String> attachmentsToDelete = new HashSet<String>();
        HashMap<AttachmentUploadRequest.Item, Throwable> conflictFailures = new HashMap<AttachmentUploadRequest.Item, Throwable>();
        AttachmentUploadRequest.Builder builder = AttachmentUploadRequest.builder((SW360HalResource)sw360Release);
        for (Map.Entry<Path, SW360AttachmentType> e : attachments.entrySet()) {
            String fileName = String.valueOf(e.getKey().getFileName());
            Optional<SW360SparseAttachment> optAttachment = SW360MetaDataUpdater.findAttachmentByFileName(sw360Release, fileName);
            boolean shouldUpload = optAttachment.map(attachment -> this.checkUploadCriteria((Path)e.getKey(), (SW360SparseAttachment)attachment, (Set<String>)attachmentsToDelete, (Map<AttachmentUploadRequest.Item, Throwable>)conflictFailures, force)).orElse(true);
            if (!shouldUpload) continue;
            builder = builder.addAttachment(e.getKey(), e.getValue());
        }
        this.deleteConflictingAttachments(sw360Release, attachmentsToDelete);
        AttachmentUploadRequest uploadRequest = builder.build();
        if (!uploadRequest.getItems().isEmpty()) {
            AttachmentUploadResult result = this.releaseClientAdapter.uploadAttachments(uploadRequest);
            LOGGER.debug("Result of attachment upload operation: {}", (Object)result);
            if (!result.isSuccess()) {
                LOGGER.error("Failed to upload attachments: {}", (Object)result.failedUploads());
            }
            return SW360MetaDataUpdater.appendFailures((AttachmentUploadResult<SW360Release>)result, conflictFailures);
        }
        return SW360MetaDataUpdater.appendFailures((AttachmentUploadResult<SW360Release>)new AttachmentUploadResult((SW360HalResource)sw360Release), conflictFailures);
    }

    public SW360Release deleteSourceAttachments(SW360Release release) {
        return this.deleteAttachments(release, attachment -> attachment.getAttachmentType() == SW360AttachmentType.SOURCE);
    }

    public SW360Release deleteAttachments(SW360Release release, Predicate<SW360SparseAttachment> filter) {
        Set deleteAttachmentIds = ((SW360ReleaseEmbedded)release.getEmbedded()).getAttachments().stream().filter(filter).map(SW360HalResource::getId).collect(Collectors.toSet());
        return deleteAttachmentIds.isEmpty() ? release : this.releaseClientAdapter.deleteAttachments(release, deleteAttachmentIds);
    }

    String calculateAttachmentHash(Path path) {
        return SW360AttachmentUtils.calculateSha1Hash((Path)path);
    }

    private boolean checkAttachmentContentUpToDate(Path path, SW360SparseAttachment attachment) {
        try {
            return this.calculateAttachmentHash(path).equals(attachment.getSha1());
        }
        catch (SW360ClientException e) {
            LOGGER.warn("Could not calculate has for attachment {}.", (Object)path, (Object)e);
            return false;
        }
    }

    private void deleteConflictingAttachments(SW360Release sw360Release, Set<String> attachmentsToDelete) {
        if (!attachmentsToDelete.isEmpty()) {
            LOGGER.debug("Deleting conflicting attachments: {}.", attachmentsToDelete);
            try {
                this.releaseClientAdapter.deleteAttachments(sw360Release, attachmentsToDelete);
            }
            catch (Exception e) {
                LOGGER.error("Failed to delete conflicting attachments.", (Throwable)e);
            }
        }
    }

    private static SW360Project prepareNewProject(String projectName, String projectVersion) {
        SW360Project sw360Project = new SW360Project();
        sw360Project.setName(projectName);
        sw360Project.setVersion(projectVersion);
        sw360Project.setDescription(projectName + " " + projectVersion);
        sw360Project.setProjectType(SW360ProjectType.PRODUCT);
        sw360Project.setVisibility(SW360Visibility.BUISNESSUNIT_AND_MODERATORS);
        return sw360Project;
    }

    private boolean checkUploadCriteria(Path path, SW360SparseAttachment attachment, Set<String> attachmentsToDelete, Map<AttachmentUploadRequest.Item, Throwable> conflictFailures, boolean force) {
        if (this.checkAttachmentContentUpToDate(path, attachment)) {
            LOGGER.debug("Skipping upload for {} as it already exists.", (Object)path);
            return false;
        }
        if (!force) {
            conflictFailures.put(new AttachmentUploadRequest.Item(path, attachment.getAttachmentType()), new IllegalStateException("Conflict detected for " + path + "! An attachment with this name, but different content exists."));
            return false;
        }
        attachmentsToDelete.add(attachment.getId());
        return true;
    }

    private static Optional<SW360SparseAttachment> findAttachmentByFileName(SW360Release sw360Release, String fileName) {
        return ((SW360ReleaseEmbedded)sw360Release.getEmbedded()).getAttachments().stream().filter(attachment -> fileName.equals(attachment.getFilename())).findFirst();
    }

    private static AttachmentUploadResult<SW360Release> appendFailures(AttachmentUploadResult<SW360Release> orgResult, Map<AttachmentUploadRequest.Item, Throwable> moreFailures) {
        if (moreFailures.isEmpty()) {
            return orgResult;
        }
        moreFailures.putAll(orgResult.failedUploads());
        return AttachmentUploadResult.newResult((SW360HalResource)orgResult.getTarget(), (Set)orgResult.successfulUploads(), moreFailures);
    }
}

