/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.sw360.workflow.processors;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFactWithPayload;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceFile;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.sw360.SW360MetaDataReceiver;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360License;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360Release;
import org.eclipse.sw360.antenna.sw360.client.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.antenna.sw360.utils.ArtifactToReleaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SW360EnricherImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360EnricherImpl.class);
    private final IProcessingReporter reporter;
    private final SW360MetaDataReceiver connector;
    private final boolean downloadAttachments;
    private final Path downloadPath;

    public SW360EnricherImpl(IProcessingReporter reporter, SW360MetaDataReceiver connector, boolean downloadAttachments, Path downloadPath) {
        this.reporter = reporter;
        this.connector = connector;
        this.downloadAttachments = downloadAttachments;
        this.downloadPath = downloadPath;
    }

    public Collection<Artifact> process(Collection<Artifact> intermediates) {
        for (Artifact artifact : intermediates) {
            Optional<SW360Release> release = this.connector.findReleaseForArtifact(artifact);
            if (release.isPresent()) {
                this.mapReleaseToArtifact(release.get(), artifact);
                continue;
            }
            this.warnAndReport(artifact, "No SW360 release found for artifact.", MessageType.PROCESSING_FAILURE);
        }
        return intermediates;
    }

    private void mapReleaseToArtifact(SW360Release sw360Release, Artifact artifact) {
        ArtifactToReleaseUtils.convertToArtifactWithoutSourceFile(sw360Release, artifact);
        this.updateLicenses(artifact, sw360Release);
        if (this.downloadAttachments) {
            this.downloadAttachments(sw360Release, artifact);
        }
    }

    private void downloadAttachments(SW360Release sw360Release, Artifact artifact) {
        Set attachments = ((SW360ReleaseEmbedded)sw360Release.getEmbedded()).getAttachments();
        attachments.stream().filter(attachment -> attachment.getAttachmentType() == SW360AttachmentType.SOURCE).forEach(attachment -> this.mapSourceAttachmentOnArtifact(sw360Release, (SW360SparseAttachment)attachment, artifact));
    }

    private void mapSourceAttachmentOnArtifact(SW360Release sw360Release, SW360SparseAttachment attachment, Artifact artifact) {
        Optional<Path> attachmentPath = this.connector.downloadAttachment(sw360Release, attachment, this.downloadPath);
        attachmentPath.ifPresent(path -> artifact.addFact((ArtifactFact)new ArtifactSourceFile(path)));
    }

    private void updateLicenses(Artifact artifact, SW360Release release) {
        List<License> artifactLicenses = artifact.askForAll(ArtifactLicenseInformation.class).stream().map(ArtifactFactWithPayload::get).map(LicenseInformation::getLicenses).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        SW360ReleaseEmbedded embedded = (SW360ReleaseEmbedded)release.getEmbedded();
        if (embedded == null) {
            LOGGER.debug("No license information available in SW360.");
            return;
        }
        ArrayList<SW360SparseLicense> releaseLicenses = new ArrayList<SW360SparseLicense>(embedded.getLicenses());
        if (!artifactLicenses.isEmpty()) {
            if (releaseLicenses.isEmpty()) {
                LOGGER.debug("License information available in antenna but not in SW360.");
            } else {
                this.updateLicenseInformation(artifactLicenses, releaseLicenses);
            }
        }
    }

    private void updateLicenseInformation(List<License> artifactLicenses, List<SW360SparseLicense> sw360licenses) {
        artifactLicenses.forEach(license -> this.updateLicense((License)license, sw360licenses));
    }

    private void updateLicense(License license, List<SW360SparseLicense> sw360licenses) {
        sw360licenses.stream().filter(l -> l.getShortName().equals(license.getId())).findFirst().ifPresent(l -> this.enrichLicenseWithSW360Data(license, (SW360SparseLicense)l));
    }

    private License enrichLicenseWithSW360Data(License license, SW360SparseLicense sparseLicense) {
        Optional<License> updatedLicense = this.connector.getLicenseDetails(sparseLicense).map(licenseDetails -> this.makeLicenseFromLicenseDetails(license, (SW360License)licenseDetails));
        if (updatedLicense.isPresent()) {
            return updatedLicense.get();
        }
        LOGGER.warn("Could not get details for license {}", (Object)sparseLicense.getFullName());
        return license;
    }

    private License makeLicenseFromLicenseDetails(License license, SW360License licenseDetails) {
        license.setCommonName(licenseDetails.getFullName());
        license.setText(licenseDetails.getText());
        return license;
    }

    private void warnAndReport(Artifact artifact, String message, MessageType messageType) {
        LOGGER.debug(message);
        this.reporter.add(artifact, messageType, message);
    }
}

