/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;

public class SimulatorConfig {
    private static final String SIMULATOR_CONFIG_FILENAME = "san_simulator_cimom.properties";
    public static final String SETUP_WIZARD_CONFIG_FILEPATH = "SETUP_WIZARD_CONFIG_FILEPATH";
    public static final String SUBSYSTEM = "SUBSYSTEM";
    public static final String STORAGE_POOLS = "STORAGE_POOLS";
    public static final String STORAGE_EXTENTS = "STORAGE_EXTENTS";
    public static final String STORAGE_VOLUMES = "STORAGE_VOLUMES";
    public static final String SUBSYSTEM_DS8K = "DS8K";
    public static String dbDriverName = "com.ibm.db2.jcc.DB2Driver";
    public static String dbUrl = "jdbc:db2:";
    public static String dbUsername;
    public static String dbPassword;
    private static String databaseName;

    static {
        databaseName = "SIMDB";
        Properties properties = new Properties();
        try {
            File simulatorFile = new File(SIMULATOR_CONFIG_FILENAME);
            String setupwizardFile = System.getProperty(SETUP_WIZARD_CONFIG_FILEPATH);
            if (null != setupwizardFile) {
                properties.load(new FileInputStream(System.getProperty(SETUP_WIZARD_CONFIG_FILEPATH)));
            } else if (simulatorFile.exists()) {
                properties.load(new FileInputStream(SIMULATOR_CONFIG_FILENAME));
            }
            String database = properties.getProperty("DATABASE");
            databaseName = properties.getProperty("DB_NAME");
            String dbLocation = properties.getProperty("DB_LOCATION");
            if (database.equalsIgnoreCase("Derby")) {
                dbDriverName = "org.apache.derby.jdbc.ClientDriver";
                dbPassword = properties.getProperty("DB_PASSWORD");
                String derby_port = properties.getProperty("DERBY_SERVER_PORT");
                dbUsername = properties.getProperty("DB_USERNAME");
                dbUrl = MessageFormat.format("jdbc:derby://{0}:{1}/{2};create=false;user={3};password={4}", dbLocation, derby_port, databaseName, dbUsername, dbPassword);
            } else if (database.equalsIgnoreCase("DB2")) {
                if (dbLocation.equalsIgnoreCase("localhost") || dbLocation.equals("127.0.0.1")) {
                    dbUrl = "jdbc:db2:" + databaseName;
                    dbDriverName = "com.ibm.db2.jcc.DB2Driver";
                } else {
                    dbUrl = "jdbc:db2://" + dbLocation + ":50000/" + databaseName;
                    dbUsername = properties.getProperty("DB_USERNAME");
                    dbPassword = properties.getProperty("DB_PASSWORD");
                    dbDriverName = "com.ibm.db2.jcc.DB2Driver";
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

