/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import org.eclipse.aperi.simulator.SimulatorConfig;
import org.eclipse.aperi.simulator.cimom.common.ConnectionPool;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;

public final class DatabaseManager {
    private static final String CIMOM_INFO_INSERT = "INSERT INTO SIM.CIMOM_INFO (CIMOM_TYPE, DETAILS, URL, INTOP_NS, USERID, PWDID) VALUES(?, ?, ?, ?, ?, ?)";
    private static final String NS_INFO_INSERT = "INSERT INTO SIM.NS_INFO(CIMOM_INFO_ID, NAMESPACE) VALUES (?, ?)";
    private static final String CIM_CLASS_INSERT = "INSERT INTO SIM.CIM_CLASS(NS_INFO_ID, CLASS_NAME) VALUES (?, ?)";
    private static final String CIM_DATA_INSERT = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
    private static final String CIM_DATA_UPDATE = "UPDATE SIM.CIM_DATA DATA SET CIM_OP = ? , CIM_INST = ? WHERE DATA.ID = ?";
    private static final String CIM_GET_CLASS_ID = "SELECT CIM_CLASS.ID FROM SIM.CIM_CLASS AS CIM_CLASS, SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = ? AND CIM_CLASS.CLASS_NAME = ? AND CIM_CLASS.NS_INFO_ID = NS_INFO.ID";
    private static final String IS_ASSOCIATION_INDEX_QUERY = "SELECT ID FROM SIM.CIM_ASC";
    private static boolean isAssociationTableExistsFlag;
    private PreparedStatement psEnumInstanceNamesWithString;
    private PreparedStatement psEnumInstanceNamesWithID;

    private DatabaseManager() {
        try {
            Class.forName(SimulatorConfig.dbDriverName);
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        this.psEnumInstanceNamesWithString = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        this.psEnumInstanceNamesWithID = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.CLASS_NAME=? AND CLS.NS_INFO_ID=?");
        isAssociationTableExistsFlag = true;
        ConnectionPool.closeConnection(connection);
    }

    public static DatabaseManager getDbManager() {
        return DatabaseManagerHandler.instance;
    }

    public synchronized void insert_CIMOM_INFO(int type, String details, String url, String namespace, String user, String password) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement ps_cimom_info_insert = connection.prepareStatement(CIMOM_INFO_INSERT);
        ps_cimom_info_insert.setInt(1, type);
        ps_cimom_info_insert.setString(2, details);
        ps_cimom_info_insert.setString(3, url);
        ps_cimom_info_insert.setString(4, namespace);
        if (user != null) {
            ps_cimom_info_insert.setString(5, user);
        } else {
            ps_cimom_info_insert.setNull(5, 12);
        }
        if (password != null) {
            ps_cimom_info_insert.setString(6, password);
        } else {
            ps_cimom_info_insert.setNull(6, 12);
        }
        ps_cimom_info_insert.executeUpdate();
        connection.commit();
        ps_cimom_info_insert.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_NS_INFO(int cimomInfoID, String namespace) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement ps_ns_info_insert = connection.prepareStatement(NS_INFO_INSERT);
        ps_ns_info_insert.setInt(1, cimomInfoID);
        ps_ns_info_insert.setString(2, namespace);
        ps_ns_info_insert.executeUpdate();
        connection.commit();
        ps_ns_info_insert.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_CIM_CLASS(int nsInfoCnt, String className) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement ps_cim_class_insert = connection.prepareStatement(CIM_CLASS_INSERT);
        ps_cim_class_insert.setInt(1, nsInfoCnt);
        ps_cim_class_insert.setString(2, className);
        ps_cim_class_insert.executeUpdate();
        connection.commit();
        ps_cim_class_insert.close();
        ConnectionPool.closeConnection(connection);
    }

    public synchronized void insert_CIM_DATA(int cimClassCnt, CIMInstance cimInstance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMDataBLOB instanceBlob = new CIMDataBLOB(cimInstance);
        int instanceBlobLength = (int)instanceBlob.length();
        CIMDataBLOB opBlob = new CIMDataBLOB(cimInstance.getObjectPath());
        int opBlobLength = (int)opBlob.length();
        PreparedStatement ps_cim_data_insert = connection.prepareStatement(CIM_DATA_INSERT);
        ps_cim_data_insert.setInt(1, cimClassCnt);
        ps_cim_data_insert.setBinaryStream(2, opBlob.getBinaryStream(), opBlobLength);
        ps_cim_data_insert.setBinaryStream(3, instanceBlob.getBinaryStream(), instanceBlobLength);
        ps_cim_data_insert.executeUpdate();
        connection.commit();
        ps_cim_data_insert.close();
        ConnectionPool.closeConnection(connection);
    }

    public int getMaxID(String tableName) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        int maxCnt = -1;
        String qry = "SELECT MAX(ID) FROM " + tableName;
        PreparedStatement ps = connection.prepareStatement(qry);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            maxCnt = rs.getInt(1);
        }
        rs.close();
        ps.close();
        ConnectionPool.closeConnection(connection);
        return maxCnt;
    }

    public void persistInstances(int nsID, Map instanceMap, Map classMap) throws Exception {
        Set keySet = instanceMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String simClass = (String)iter.next();
            String classname = simClass.substring(simClass.indexOf(58) + 1);
            this.insert_CIM_CLASS(nsID, classname);
            int cimClassMaxCnt = this.getMaxID("SIM.CIM_CLASS");
            Object instance = instanceMap.get(simClass);
            if (null == instance) continue;
            if (instance instanceof List) {
                Iterator tempIter = ((List)instance).iterator();
                while (tempIter.hasNext()) {
                    CIMInstance element = (CIMInstance)tempIter.next();
                    System.out.println(element);
                    this.insert_CIM_DATA(cimClassMaxCnt, element);
                }
                continue;
            }
            this.insert_CIM_DATA(cimClassMaxCnt, (CIMInstance)instance);
            System.out.println(instance.toString());
        }
        if (isAssociationTableExistsFlag) {
            this.buildAssociationIndexes(nsID, this.createAssociationClassList(classMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociationTableExists() {
        boolean associationIndexed = false;
        Connection connection = ConnectionPool.getConnection();
        try {
            PreparedStatement psCheck = connection.prepareStatement("SELECT TABLES.TABSCHEMA, TABLES.TABNAME FROM SYSCAT.TABLES AS TABLES  WHERE TABLES.TABNAME = 'CIM_ASC' AND TABLES.TABSCHEMA = 'SIM'");
            ResultSet rsCheck = psCheck.executeQuery();
            if (rsCheck.next()) {
                associationIndexed = true;
            }
            rsCheck.close();
            psCheck.close();
        }
        catch (Exception e) {
            System.out.println(" Exception description : " + e.toString());
        }
        finally {
            ConnectionPool.closeConnection(connection);
        }
        return associationIndexed;
    }

    private Set createAssociationClassList(Map classMap) {
        HashSet<String> associationClassSet = new HashSet<String>();
        Iterator iter = classMap.keySet().iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            SimClass simClass = (SimClass)classMap.get(className);
            if (!simClass.isAssociation()) continue;
            associationClassSet.add(simClass.getName());
        }
        return associationClassSet;
    }

    public int getNamespaceID(String namespace) throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT NS_INFO.ID FROM SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = ? ");
        preparedStatement.setString(1, namespace);
        ResultSet rs = preparedStatement.executeQuery();
        int nsId = -1;
        if (rs.next()) {
            nsId = rs.getInt(1);
        }
        preparedStatement.close();
        rs.close();
        ConnectionPool.closeConnection(connection);
        return nsId;
    }

    public List enumerateInstances(Connection connection, String namespace, String className) throws Exception {
        ArrayList<CIMInstance> resultList = new ArrayList<CIMInstance>();
        PreparedStatement ps = connection.prepareStatement("SELECT DATA.ID, DATA.CIM_OP, DATA.CIM_INST  FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        ps.setString(1, className);
        ps.setString(2, namespace);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            InputStream is2 = rs.getBinaryStream(3);
            ObjectInputStream ois2 = new ObjectInputStream(is2);
            Object rawObj2 = ois2.readObject();
            CIMInstance instance = (CIMInstance)rawObj2;
            resultList.add(instance);
        }
        rs.close();
        ps.close();
        return resultList;
    }

    public List associators(String namespace, String assocClassName, CIMObjectPath srcOP) {
        ArrayList resultSet = new ArrayList();
        try {
            namespace = SimulatorUtility.fixNamespaceSlashIssue(namespace);
            List associationClassIds = this.getMultipleClassID(namespace, assocClassName);
            List srcInstances = this.getMultipleInstanceID(srcOP);
            Iterator iter = srcInstances.iterator();
            while (iter.hasNext()) {
                int srcOpId = (Integer)iter.next();
                Iterator classIter = associationClassIds.iterator();
                while (classIter.hasNext()) {
                    int assClsId = (Integer)classIter.next();
                    List tempList = DatabaseManager.getDbManager().getTargetInstances(srcOpId, assClsId);
                    resultSet.addAll(tempList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAssociationIndex() {
        boolean associationIndexed = false;
        if (isAssociationTableExistsFlag) {
            Connection connection = ConnectionPool.getConnection();
            try {
                PreparedStatement psCheck = connection.prepareStatement(IS_ASSOCIATION_INDEX_QUERY);
                ResultSet rsCheck = psCheck.executeQuery();
                if (rsCheck.next()) {
                    associationIndexed = true;
                }
                rsCheck.close();
                psCheck.close();
            }
            catch (Exception e) {
                System.out.println(" Exception description : " + e.toString());
            }
            finally {
                ConnectionPool.closeConnection(connection);
            }
        }
        return associationIndexed;
    }

    private void buildAssociationIndexes(int nsInfoCnt, Set classListAssoc) {
        Iterator iter = classListAssoc.iterator();
        while (iter.hasNext()) {
            String classNameToGetData = (String)iter.next();
            try {
                this.psEnumInstanceNamesWithID.setString(1, classNameToGetData);
                this.psEnumInstanceNamesWithID.setInt(2, nsInfoCnt);
                ResultSet rs = this.psEnumInstanceNamesWithID.executeQuery();
                while (rs.next()) {
                    int associationID = rs.getInt(2);
                    InputStream is = rs.getBinaryStream(1);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    Object rawObj = ois.readObject();
                    CIMObjectPath assocOPFromDB = (CIMObjectPath)rawObj;
                    this.insertAssociationIndexData(associationID, assocOPFromDB);
                }
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertAssociationIndexData(int associationID, CIMObjectPath associationDataOP) throws Exception {
        Vector assocOPKeys = associationDataOP.getKeys();
        CIMObjectPath assocFromOP = null;
        CIMObjectPath assocToOP = null;
        int keySize = assocOPKeys.size();
        for (int count = 0; count < keySize; ++count) {
            CIMProperty assocOPProp = (CIMProperty)assocOPKeys.elementAt(count);
            if (assocOPProp.getType().getType() != 28) continue;
            if (assocFromOP == null) {
                assocFromOP = (CIMObjectPath)assocOPProp.getValue().getValue();
                continue;
            }
            if (assocToOP != null) continue;
            assocToOP = (CIMObjectPath)assocOPProp.getValue().getValue();
            break;
        }
        if (null != assocFromOP && null != assocToOP) {
            int fromID = this.getInstanceID(assocFromOP);
            int toID = this.getInstanceID(assocToOP);
            if (fromID != -1 && toID != -1) {
                this.insert_CIM_ASSOC(associationID, fromID, toID);
            }
        }
    }

    protected synchronized void insert_CIM_ASSOC(int assocID, int fromID, int toID) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        String CIM_ASSOC_INSERT = "INSERT INTO SIM.CIM_ASC(CIM_DATA_ASC_ID, CIM_DATA_FRM_ID, CIM_DATA_TO_ID) VALUES (?, ?, ?)";
        PreparedStatement ps_cim_assoc_insert = connection.prepareStatement(CIM_ASSOC_INSERT);
        ps_cim_assoc_insert.setInt(1, assocID);
        ps_cim_assoc_insert.setInt(2, fromID);
        ps_cim_assoc_insert.setInt(3, toID);
        ps_cim_assoc_insert.executeUpdate();
        connection.commit();
        ps_cim_assoc_insert.close();
        ConnectionPool.closeConnection(connection);
    }

    public int getInstanceID(CIMObjectPath objectPath) {
        int instanceID = -1;
        try {
            String instanceClassName = objectPath.getObjectName();
            String namespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath.getNameSpace());
            Connection connection = ConnectionPool.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            preparedStatement.setString(1, instanceClassName);
            preparedStatement.setString(2, namespace);
            ResultSet rsTo = preparedStatement.executeQuery();
            while (rsTo.next()) {
                ObjectInputStream ois1;
                Object rawObj1;
                CIMObjectPath cimOP1;
                InputStream is1 = rsTo.getBinaryStream(1);
                if (is1 == null || !SimulatorUtility.equalsCIMObjectPath(cimOP1 = (CIMObjectPath)(rawObj1 = (ois1 = new ObjectInputStream(is1)).readObject()), objectPath)) continue;
                instanceID = rsTo.getInt(2);
                break;
            }
            rsTo.close();
            preparedStatement.close();
            ConnectionPool.closeConnection(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceID;
    }

    public List getMultipleInstanceID(CIMObjectPath objectPath) {
        ArrayList<Integer> instancesID = new ArrayList<Integer>();
        try {
            String instanceClassName = objectPath.getObjectName();
            String namespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath.getNameSpace());
            Connection connection = ConnectionPool.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            preparedStatement.setString(1, instanceClassName);
            preparedStatement.setString(2, namespace);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ObjectInputStream ois1;
                Object rawObj1;
                CIMObjectPath cimOP1;
                InputStream is1 = resultSet.getBinaryStream(1);
                if (is1 == null || !SimulatorUtility.equalsCIMObjectPath(cimOP1 = (CIMObjectPath)(rawObj1 = (ois1 = new ObjectInputStream(is1)).readObject()), objectPath)) continue;
                instancesID.add(new Integer(resultSet.getInt(2)));
            }
            resultSet.close();
            preparedStatement.close();
            ConnectionPool.closeConnection(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instancesID;
    }

    public CIMInstance getInstance(CIMObjectPath objectPath) throws Exception {
        String className = objectPath.getObjectName();
        String namespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath.getNameSpace());
        CIMInstance instance = null;
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement psGetInstanceQuery = connection.prepareStatement("SELECT DATA.ID, DATA.CIM_OP, DATA.CIM_INST  FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        psGetInstanceQuery.setString(1, className);
        psGetInstanceQuery.setString(2, namespace);
        ResultSet resultSet = psGetInstanceQuery.executeQuery();
        while (resultSet.next()) {
            ObjectInputStream ois1 = new ObjectInputStream(resultSet.getBinaryStream(2));
            CIMObjectPath cimOP1 = (CIMObjectPath)ois1.readObject();
            if (!SimulatorUtility.equalsCIMObjectPath(cimOP1, objectPath)) continue;
            InputStream is2 = resultSet.getBinaryStream(3);
            ObjectInputStream ois2 = new ObjectInputStream(is2);
            instance = (CIMInstance)ois2.readObject();
            break;
        }
        resultSet.close();
        psGetInstanceQuery.close();
        ConnectionPool.closeConnection(connection);
        return instance;
    }

    public boolean createInstance(CIMInstance instance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMObjectPath objectPath = instance.getObjectPath();
        String className = objectPath.getObjectName();
        String nameSpace = SimulatorUtility.fixNamespaceSlashIssue(objectPath.getNameSpace());
        int cimClassCnt = -1;
        PreparedStatement ps = connection.prepareStatement(CIM_GET_CLASS_ID);
        ps.setString(1, nameSpace);
        ps.setString(2, className);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            cimClassCnt = rs.getInt(1);
        }
        if (cimClassCnt == -1) {
            cimClassCnt = this.createClassEntry(nameSpace, className);
        }
        rs.close();
        ps.close();
        this.insert_CIM_DATA(cimClassCnt, instance);
        if (isAssociationTableExistsFlag) {
            this.insertAssociationIndexData(this.getMaxID("SIM.CIM_DATA"), instance.getObjectPath());
        }
        ConnectionPool.closeConnection(connection);
        return false;
    }

    private int createClassEntry(String nameSpace, String className) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery("SELECT NS_INFO.ID FROM SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = '" + nameSpace + "'");
        int nsID = -1;
        if (rs.next()) {
            nsID = rs.getInt(1);
        }
        statement.close();
        rs.close();
        if (-1 == nsID) {
            this.insert_NS_INFO(this.getMaxID("SIM.CIMOM_INFO"), nameSpace);
            rs = statement.executeQuery("SELECT NS_INFO.ID FROM SIM.NS_INFO AS NS_INFO WHERE NS_INFO.NAMESPACE = '" + nameSpace + "'");
            if (rs.next()) {
                nsID = rs.getInt(1);
            }
        }
        this.insert_CIM_CLASS(nsID, className);
        ConnectionPool.closeConnection(connection);
        return this.getMaxID("SIM.CIM_CLASS");
    }

    public boolean updateInstance(CIMObjectPath oldInstanceOP, CIMInstance cimInstance) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        boolean retVal = false;
        int instanceId = this.getInstanceID(oldInstanceOP);
        CIMDataBLOB instanceBlob = new CIMDataBLOB(cimInstance);
        int instanceBlobLength = (int)instanceBlob.length();
        CIMDataBLOB opBlob = new CIMDataBLOB(cimInstance.getObjectPath());
        int opBlobLength = (int)opBlob.length();
        PreparedStatement ps_cim_data_update = connection.prepareStatement(CIM_DATA_UPDATE);
        ps_cim_data_update.setBinaryStream(1, opBlob.getBinaryStream(), opBlobLength);
        ps_cim_data_update.setBinaryStream(2, instanceBlob.getBinaryStream(), instanceBlobLength);
        ps_cim_data_update.setInt(3, instanceId);
        ps_cim_data_update.executeUpdate();
        ps_cim_data_update.close();
        retVal = true;
        ConnectionPool.closeConnection(connection);
        return retVal;
    }

    public boolean deleteInstance(CIMObjectPath objectPath) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        boolean retVal = false;
        int instanceID = this.getInstanceID(objectPath);
        Statement stat1 = connection.createStatement();
        ResultSet rs = stat1.executeQuery("SELECT ASC.CIM_DATA_ASC_ID FROM SIM.CIM_ASC AS ASC WHERE ASC.CIM_DATA_FRM_ID = " + instanceID + " OR ASC.CIM_DATA_TO_ID = " + instanceID);
        Statement statement = connection.createStatement();
        statement.execute("DELETE FROM SIM.CIM_DATA DATA WHERE DATA.ID = " + instanceID);
        statement.close();
        while (rs.next()) {
            int id = rs.getInt("CIM_DATA_ASC_ID");
            Statement stat2 = connection.createStatement();
            stat2.execute("DELETE FROM SIM.CIM_DATA DATA WHERE DATA.ID = " + id);
            stat2.close();
        }
        rs.close();
        stat1.close();
        retVal = true;
        ConnectionPool.closeConnection(connection);
        return retVal;
    }

    public List enumerateInstances(String namespace, String className) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        HashSet<CIMInstance> resultList = new HashSet<CIMInstance>();
        PreparedStatement ps = connection.prepareStatement("SELECT DATA.ID, DATA.CIM_OP, DATA.CIM_INST  FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
        ps.setString(1, className);
        ps.setString(2, namespace);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            InputStream is2 = rs.getBinaryStream(3);
            ObjectInputStream ois2 = new ObjectInputStream(is2);
            Object rawObj2 = ois2.readObject();
            CIMInstance instance = (CIMInstance)rawObj2;
            resultList.add(instance);
        }
        rs.close();
        ps.close();
        ConnectionPool.closeConnection(connection);
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        list.addAll(resultList);
        return list;
    }

    public List enumerateInstanceNames(CIMObjectPath objectPath) {
        String className = objectPath.getObjectName();
        String nameSpace = objectPath.getNameSpace();
        return this.enumerateInstanceNames(nameSpace, className);
    }

    public List enumerateInstanceNames(String namespace, String className) {
        HashSet<CIMObjectPath> resultList = new HashSet<CIMObjectPath>();
        Connection connection = ConnectionPool.getConnection();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            ps.setString(1, className);
            ps.setString(2, namespace);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                ObjectInputStream ois = new ObjectInputStream(is);
                Object rawObj = ois.readObject();
                CIMObjectPath op = (CIMObjectPath)rawObj;
                resultList.add(op);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConnectionPool.closeConnection(connection);
        ArrayList<CIMObjectPath> list = new ArrayList<CIMObjectPath>();
        list.addAll(resultList);
        return list;
    }

    public int getClassID(String nameSpace, String className) throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_CLASS.ID, CIM_CLASS.CLASS_NAME FROM SIM.CIM_CLASS AS CIM_CLASS, SIM.NS_INFO AS NS_INFO WHERE CIM_CLASS.NS_INFO_ID = NS_INFO.ID AND NS_INFO.NAMESPACE = ? AND CIM_CLASS.CLASS_NAME = ?");
        preparedStatement.setString(1, nameSpace);
        preparedStatement.setString(2, className);
        ResultSet rs = preparedStatement.executeQuery();
        int classID = -1;
        if (rs.next()) {
            classID = rs.getInt(1);
        }
        preparedStatement.close();
        rs.close();
        ConnectionPool.closeConnection(connection);
        return classID;
    }

    public List getMultipleClassID(String nameSpace, String className) throws SQLException {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_CLASS.ID, CIM_CLASS.CLASS_NAME FROM SIM.CIM_CLASS AS CIM_CLASS, SIM.NS_INFO AS NS_INFO WHERE CIM_CLASS.NS_INFO_ID = NS_INFO.ID AND NS_INFO.NAMESPACE = ? AND CIM_CLASS.CLASS_NAME = ?");
        preparedStatement.setString(1, nameSpace);
        preparedStatement.setString(2, className);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Integer> classIDList = new ArrayList<Integer>();
        while (resultSet.next()) {
            classIDList.add(new Integer(resultSet.getInt(1)));
        }
        resultSet.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return classIDList;
    }

    public List getReferencedInstances(int objectID, int classID) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_DATA.ID, CIM_DATA.CIM_OP, CIM_DATA.CIM_INST FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID AND (CIM_ASC.CIM_DATA_FRM_ID = ? OR CIM_ASC.CIM_DATA_TO_ID = ?)");
        preparedStatement.setInt(1, classID);
        preparedStatement.setInt(2, objectID);
        preparedStatement.setInt(3, objectID);
        ResultSet rs = preparedStatement.executeQuery();
        ArrayList<CIMInstance> resultList = new ArrayList<CIMInstance>();
        while (rs.next()) {
            InputStream is2 = rs.getBinaryStream(3);
            ObjectInputStream ois2 = new ObjectInputStream(is2);
            Object rawObj2 = ois2.readObject();
            CIMInstance instance = (CIMInstance)rawObj2;
            resultList.add(instance);
        }
        rs.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return resultList;
    }

    public List getTargetInstances(int objectID, int classID) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        Vector<Integer> resultIdx = new Vector<Integer>();
        ArrayList<CIMInstance> resultList = new ArrayList<CIMInstance>();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_ASC.CIM_DATA_FRM_ID FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_TO_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID");
        preparedStatement.setInt(1, classID);
        preparedStatement.setInt(2, objectID);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            Integer fromId = new Integer(rs.getInt(1));
            if (resultIdx.contains(fromId)) continue;
            resultIdx.add(fromId);
        }
        rs.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT CIM_ASC.CIM_DATA_TO_ID FROM SIM.CIM_DATA AS CIM_DATA, SIM.CIM_ASC AS CIM_ASC WHERE CIM_DATA.CIM_CLASS_ID = ? AND CIM_ASC.CIM_DATA_FRM_ID = ? AND CIM_ASC.CIM_DATA_ASC_ID = CIM_DATA.ID");
        preparedStatement.setInt(1, classID);
        preparedStatement.setInt(2, objectID);
        rs = preparedStatement.executeQuery();
        while (rs.next()) {
            Integer toId = new Integer(rs.getInt(1));
            if (resultIdx.contains(toId)) continue;
            resultIdx.add(toId);
        }
        rs.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        int length = resultIdx.size();
        for (int idx = 0; idx < length; ++idx) {
            resultList.add(this.getInstanceFromId((Integer)resultIdx.elementAt(idx)));
        }
        return resultList;
    }

    public CIMInstance getInstanceFromId(int objectID) throws Exception {
        Connection connection = ConnectionPool.getConnection();
        CIMInstance instance = null;
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CIM_DATA.CIM_INST FROM SIM.CIM_DATA AS CIM_DATA WHERE CIM_DATA.ID = ?");
        preparedStatement.setInt(1, objectID);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            InputStream is2 = rs.getBinaryStream(1);
            ObjectInputStream ois2 = new ObjectInputStream(is2);
            Object rawObj2 = ois2.readObject();
            instance = (CIMInstance)rawObj2;
        }
        rs.close();
        preparedStatement.close();
        ConnectionPool.closeConnection(connection);
        return instance;
    }

    public List references(CIMObjectPath assocOP, CIMObjectPath objectName) throws CIMException {
        ArrayList<CIMInstance> resultList = new ArrayList<CIMInstance>();
        try {
            boolean isAssociationIndexed = DatabaseManager.getDbManager().isAssociationIndex();
            String nameSpace = assocOP.getNameSpace();
            if (isAssociationIndexed) {
                int objectID = DatabaseManager.getDbManager().getInstanceID(objectName);
                if (-1 != objectID) {
                    String className = assocOP.getObjectName();
                    int classID = DatabaseManager.getDbManager().getClassID(nameSpace, className);
                    if (-1 != classID) {
                        resultList.addAll(DatabaseManager.getDbManager().getReferencedInstances(objectID, classID));
                    }
                }
            } else {
                List instancesList = DatabaseManager.getDbManager().enumerateInstances(nameSpace, assocOP.getObjectName());
                Iterator instanceIter = instancesList.iterator();
                block2: while (instanceIter.hasNext()) {
                    CIMInstance instance = (CIMInstance)instanceIter.next();
                    Vector keys = instance.getKeys();
                    Iterator iter = keys.iterator();
                    boolean isReferred = false;
                    while (iter.hasNext()) {
                        CIMProperty property = (CIMProperty)iter.next();
                        if (property.isReference()) {
                            CIMObjectPath path = (CIMObjectPath)property.getValue().getValue();
                            isReferred = SimulatorUtility.equalsCIMObjectPath(path, objectName);
                        }
                        if (!isReferred) continue;
                        resultList.add(instance);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private static class DatabaseManagerHandler {
        private static DatabaseManager instance = new DatabaseManager();

        private DatabaseManagerHandler() {
        }
    }
}

