/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.util.List;
import java.util.Random;
import org.eclipse.aperi.simulator.cimom.common.generator.SimIncrementalProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimPropertyPreSuf;
import org.eclipse.aperi.simulator.cimom.common.generator.SimRandomProperty;

public class IDGenerator {
    public static final int DS8000 = 1;
    public static int INCREMENTAL_START = 1;
    public static final int IPV4 = 20;
    private static final int THREE_DIGIT_SEED = 1000;
    private static final int FOUR_DIGIT_SEED = 10000;
    private static final int SEVEN_DIGIT_SEED = 10000000;
    private static final int EIGHT_DIGIT_SEED = 100000000;

    public static String generateStorageSystemName(int subsystemType) throws Exception {
        String subsystemName = null;
        switch (subsystemType) {
            case 1: {
                subsystemName = "2107.";
                Random generator = new Random();
                subsystemName = subsystemName + generator.nextInt(10000000);
            }
        }
        return subsystemName;
    }

    public static String generateMachineSignature(int subsystemType) throws Exception {
        String machineSignature = null;
        switch (subsystemType) {
            case 1: {
                Random generator = new Random();
                machineSignature = generator.nextInt(10000) + "-" + generator.nextInt(10000) + "-" + generator.nextInt(10000) + "-" + generator.nextInt(10000);
            }
        }
        return machineSignature;
    }

    public static String generateStorageSystemNameWithModel(String subsystemName) throws Exception {
        String[] nameParts;
        String subsystemNameWithModel = null;
        if (subsystemName != null && (nameParts = subsystemName.split("\\.")).length == 2) {
            subsystemNameWithModel = "IBM." + nameParts[0] + "." + "921" + "." + nameParts[1];
        }
        return subsystemNameWithModel;
    }

    public static String generateIPAddress(int type) throws Exception {
        String ipAddress = null;
        switch (type) {
            case 20: {
                Random generator = new Random();
                ipAddress = generator.nextInt(1000) + "." + generator.nextInt(1000) + "." + generator.nextInt(1000) + "." + generator.nextInt(1000);
            }
        }
        return ipAddress;
    }

    public static String[] generateHostAdapters(int count) throws Exception {
        String[] hostAdapters = new String[count];
        Random generator = new Random();
        for (int idx = 0; idx < hostAdapters.length; ++idx) {
            hostAdapters[idx] = idx <= 1 ? "U1300.001." + generator.nextInt(10000000) + "-P1-C1" : "U1300.001." + generator.nextInt(10000000) + "-P1-C4";
        }
        return hostAdapters;
    }

    public static String generateWWN() throws Exception {
        Random generator = new Random();
        String wwn = "" + generator.nextInt(100000000) + "" + generator.nextInt(100000000);
        return wwn;
    }

    public static String getRandomKey(SimProperty property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((SimPropertyPreSuf)property).getPrefix());
        if (property.isMultiple()) {
            List values = property.getValues();
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    buffer.append(((SimRandomProperty)property).getSeperator());
                }
                String digits = (String)values.get(i);
                buffer.append(IDGenerator.getRandomKey(digits));
            }
        } else {
            buffer.append(IDGenerator.getRandomKey(property.getValue().toString()));
        }
        buffer.append(((SimPropertyPreSuf)property).getSuffix());
        return buffer.toString();
    }

    public static String getIncrementKey(SimProperty property) {
        StringBuffer buffer = new StringBuffer();
        SimIncrementalProperty incrementProperty = (SimIncrementalProperty)property;
        buffer.append(incrementProperty.getPrefix());
        incrementProperty.setIncrementCount(incrementProperty.getIncrementCount() + 1);
        buffer.append(incrementProperty.getIncrementCount());
        buffer.append(incrementProperty.getSuffix());
        return buffer.toString();
    }

    public static int getRandomKey(String digits) {
        Random generator = new Random();
        if (!digits.equalsIgnoreCase("3")) {
            int randomValue;
            int length;
            int minimumDigits = Integer.parseInt(digits);
            if (minimumDigits - (length = new Integer(randomValue = generator.nextInt((int)Math.pow(10.0, minimumDigits))).toString().length()) != 0) {
                randomValue = (int)((double)randomValue * Math.pow(10.0, minimumDigits - length));
            }
            return randomValue;
        }
        return generator.nextInt(256);
    }
}

