/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.util.Properties;

public final class ExpressionParser {
    public static int parseConfExp(Properties confProperties, String confExp) {
        int length = confExp.length();
        int retVal = 0;
        StringBuffer buffer = new StringBuffer();
        int operator = 0;
        for (int i = 0; i < length; ++i) {
            char c = confExp.charAt(i);
            if (c == ' ') {
                if (buffer.length() == 0) continue;
                if (retVal == 0) {
                    retVal = Integer.parseInt(buffer.toString());
                } else {
                    retVal = ExpressionParser.computeValue(retVal, Integer.parseInt(buffer.toString()), (char)operator);
                    operator = 32;
                }
                buffer.setLength(0);
                continue;
            }
            if (Character.isDigit(c)) {
                buffer.append(c);
                continue;
            }
            if (c == '[') {
                String propertyName = confExp.substring(i + 1, confExp.indexOf(93, i));
                if (retVal == 0) {
                    retVal = Integer.parseInt(confProperties.getProperty(propertyName));
                } else {
                    retVal = ExpressionParser.computeValue(retVal, Integer.parseInt(confProperties.getProperty(propertyName)), (char)operator);
                    operator = 32;
                }
                i = confExp.indexOf(93, i);
                continue;
            }
            switch (c) {
                case '+': {
                    operator = 43;
                    break;
                }
                case '-': {
                    operator = 45;
                    break;
                }
                case '/': {
                    operator = 47;
                    break;
                }
                case '*': {
                    operator = 42;
                    break;
                }
            }
            if (buffer.length() == 0) continue;
            retVal = Integer.parseInt(buffer.toString());
            buffer.setLength(0);
        }
        if (buffer.length() != 0 && operator != 32) {
            retVal = ExpressionParser.computeValue(retVal, Integer.parseInt(buffer.toString()), (char)operator);
        }
        return retVal;
    }

    private static int computeValue(int num1, int num2, char operator) {
        switch (operator) {
            case '+': {
                return num1 + num2;
            }
            case '-': {
                return num1 - num2;
            }
            case '/': {
                return num1 / num2;
            }
            case '*': {
                return num1 * num2;
            }
        }
        return num1;
    }
}

