/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.TargetConnection;

public class TargetDBConnection
implements TargetConnection {
    private Connection connection;
    private static String storageDevicecategory;

    public void configTargetDevcieDB() {
        String url = ConnectionConfig.getProperty("TARGET_DEVICE_DB_URL");
        String name = ConnectionConfig.getProperty("TARGET_DEVICE_DB_NAME");
        String uid = ConnectionConfig.getProperty("TARGET_DEVICE_DB_USERNAME");
        String pwd = ConnectionConfig.getProperty("TARGET_DEVICE_DB_PASSWORD");
        String dbType = ConnectionConfig.getProperty("TARGET_DEVICE_DB_TYPE");
        String dbPort = ConnectionConfig.getProperty("TARGET_DEVICE_DB_PORT");
        if (dbType.equals("Derby")) {
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                String dbUrl = MessageFormat.format("jdbc:derby://{0}:{1}/{2};create=false;user={3};password={4}", url, dbPort, name, uid, pwd);
                this.connection = DriverManager.getConnection(dbUrl);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (uid.equalsIgnoreCase("Default") || pwd.equalsIgnoreCase("Default")) {
            String DB_URL = "jdbc:db2:" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                this.connection = DriverManager.getConnection(DB_URL);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            String DB_URL = "jdbc:db2://" + url + ":50000/" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                this.connection = DriverManager.getConnection(DB_URL, uid, pwd);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void init() {
        this.configTargetDevcieDB();
        storageDevicecategory = ConnectionConfig.getProperty("STORAGE_DEVICE_CATEGORY");
    }

    public CIMValue getDeviceID(CIMValue destPort, String storageArrayName) throws CIMException {
        CIMInstance instance = null;
        boolean flag = false;
        List fcPortClassList = new ArrayList();
        try {
            if (storageDevicecategory.equals("DS4K")) {
                fcPortClassList = DatabaseManager.getDbManager().enumerateInstances(this.connection, "/root/lsissi11", "LSISSI_FCPort");
            } else if (storageDevicecategory.equals("DS6K_5.1")) {
                fcPortClassList = DatabaseManager.getDbManager().enumerateInstances(this.connection, "/root/ibm", "IBMTSESS_FCPort");
            } else if (storageDevicecategory.equals("DS6K_5.2")) {
                fcPortClassList = DatabaseManager.getDbManager().enumerateInstances(this.connection, "/root/ibm", "IBMTSDS_FCPort");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator portIterator = fcPortClassList.iterator();
        while (portIterator.hasNext()) {
            CIMValue portNo;
            instance = (CIMInstance)portIterator.next();
            CIMValue systemname = instance.getProperty("SystemName").getValue();
            if (!systemname.getValue().equals(storageArrayName) || !(portNo = instance.getProperty("PermanentAddress").getValue()).equals((Object)destPort)) continue;
            flag = true;
            break;
        }
        if (flag) {
            CIMValue deviceId = instance.getProperty("DeviceID").getValue();
            return deviceId;
        }
        return null;
    }
}

