/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.provider;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods.DS6K5_2ExtrinsicMethods;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods.DS6kExtrinsicMethods;

public class Provider
implements CIMInstanceProvider,
CIMAssociatorProvider,
CIMMethodProvider {
    private ProviderCIMOMHandle cimom;

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        System.out.println("SIMULATOR : [getInstance] OP=" + op);
        try {
            return DatabaseManager.getDbManager().getInstance(op);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CIMException(ex.getMessage(), (Object)ex);
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propList) throws CIMException {
        System.out.println("SIMULATOR : [setInstance] OP=" + op);
        CIMInstance cimInstanceNew = ci;
        CIMInstance cimInstanceOld = null;
        try {
            cimInstanceOld = DatabaseManager.getDbManager().getInstance(op);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (propList == null) {
            try {
                DatabaseManager.getDbManager().updateInstance(cimInstanceOld.getObjectPath(), cimInstanceNew);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (propList.length != 0) {
            for (int cnt = 0; cnt < propList.length; ++cnt) {
                CIMProperty propOld = cimInstanceOld.getProperty(propList[cnt]);
                if (propOld == null) continue;
                CIMProperty propNew = cimInstanceNew.getProperty(propList[cnt]);
                propOld.setValue(propNew.getValue());
                try {
                    DatabaseManager.getDbManager().updateInstance(cimInstanceOld.getObjectPath(), cimInstanceNew);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (propList.length == 0) {
            // empty if block
        }
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        System.out.println("SIMULATOR : [deleteInstance] OP=" + op);
        try {
            DatabaseManager.getDbManager().deleteInstance(op);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException(e.getMessage());
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        System.out.println("SIMULATOR : [createInstance] OP=" + op);
        try {
            DatabaseManager.getDbManager().createInstance(ci);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CIMException(e.getMessage());
        }
        return null;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        System.out.println("SIMULATOR : [execQuery] OP=" + op);
        throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)op);
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        this.cimom = (ProviderCIMOMHandle)cimom;
        System.out.println("SIMULATOR : [initialize]");
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath opi, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        System.out.println("SIMULATOR : [enumerateInstances] OP=" + opi);
        List resultList = null;
        try {
            resultList = DatabaseManager.getDbManager().enumerateInstances(opi.getNameSpace(), opi.getObjectName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CIMException(ex.getMessage());
        }
        CIMInstance[] ciArray = new CIMInstance[resultList.size()];
        resultList.toArray(ciArray);
        Iterator iter = resultList.iterator();
        while (iter.hasNext()) {
            System.out.println("SIMULATOR : [enumerateInstances] DATA: " + ((CIMInstance)iter.next()).getObjectPath());
        }
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath opi, CIMClass cc) throws CIMException {
        System.out.println("SIMULATOR : [ enumerateInstanceNames ] OP = " + opi);
        List resultList = DatabaseManager.getDbManager().enumerateInstanceNames(opi);
        CIMObjectPath[] opArray = new CIMObjectPath[resultList.size()];
        resultList.toArray(opArray);
        Iterator iter = resultList.iterator();
        while (iter.hasNext()) {
            System.out.println("SIMULATOR : [enumerateInstanceNames] DATA: " + iter.next());
        }
        return opArray;
    }

    public CIMInstance[] associators(CIMObjectPath assocOP, CIMObjectPath srcOP, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        System.out.println("SIMULATOR : [ associators ] ASSOC OP = " + assocOP);
        System.out.println("SIMULATOR : [ associators ] SRC OP = " + srcOP);
        System.out.println("SIMULATOR : [ associators ] DST OP = " + resultClass);
        CIMInstance[] instArray = null;
        HashSet resultSet = new HashSet();
        boolean associationIndexed = DatabaseManager.getDbManager().isAssociationIndex();
        try {
            if (associationIndexed) {
                List associationClassIds = DatabaseManager.getDbManager().getMultipleClassID(assocOP.getNameSpace(), assocOP.getObjectName());
                List srcInstances = DatabaseManager.getDbManager().getMultipleInstanceID(srcOP);
                Iterator iter = srcInstances.iterator();
                while (iter.hasNext()) {
                    int srcOpId = (Integer)iter.next();
                    System.out.println("SIMULATOR : [ associators ] SRC ID = " + srcOpId);
                    Iterator classIter = associationClassIds.iterator();
                    while (classIter.hasNext()) {
                        int assClsId = (Integer)classIter.next();
                        List tempList = DatabaseManager.getDbManager().getTargetInstances(srcOpId, assClsId);
                        resultSet.addAll(tempList);
                    }
                }
            } else {
                List instancesList = DatabaseManager.getDbManager().enumerateInstances(assocOP.getNameSpace(), assocOP.getObjectName());
                Iterator instanceIter = instancesList.iterator();
                while (instanceIter.hasNext()) {
                    CIMInstance instance = (CIMInstance)instanceIter.next();
                    Vector keys = instance.getKeys();
                    CIMProperty property1 = (CIMProperty)keys.get(0);
                    CIMProperty property2 = (CIMProperty)keys.get(1);
                    this.checkReferenceProperty(srcOP, resultSet, property1, property2);
                    this.checkReferenceProperty(srcOP, resultSet, property2, property1);
                }
            }
            if (resultClass != null) {
                String resultNameSpace = SimulatorUtility.fixNamespaceSlashIssue(srcOP.getNameSpace());
                ArrayList<CIMInstance> finalResultList = new ArrayList<CIMInstance>();
                ArrayList classNames = this.createClassList(resultNameSpace, resultClass);
                Iterator resultIter = resultSet.iterator();
                while (resultIter.hasNext()) {
                    CIMInstance instance = (CIMInstance)resultIter.next();
                    String currentNamespace = SimulatorUtility.fixNamespaceSlashIssue(instance.getObjectPath().getNameSpace());
                    if (classNames.contains(instance.getClassName())) {
                        finalResultList.add(instance);
                        continue;
                    }
                    if (currentNamespace.equalsIgnoreCase(resultNameSpace)) continue;
                    classNames.addAll(this.createClassList(currentNamespace, resultClass));
                    if (!classNames.contains(instance.getClassName())) continue;
                    finalResultList.add(instance);
                }
                instArray = new CIMInstance[finalResultList.size()];
                finalResultList.toArray(instArray);
            } else {
                instArray = new CIMInstance[resultSet.size()];
                resultSet.toArray(instArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < instArray.length; ++i) {
            System.out.println("SIMULATOR : [associators] DATA: " + instArray[i].getObjectPath());
        }
        return instArray;
    }

    private void checkReferenceProperty(CIMObjectPath srcOP, Set resultList, CIMProperty property1, CIMProperty property2) throws CIMException, Exception {
        CIMObjectPath path;
        boolean isAssociated;
        if (property1.isReference() && (isAssociated = SimulatorUtility.equalsCIMObjectPath(path = (CIMObjectPath)property1.getValue().getValue(), srcOP))) {
            CIMInstance target = DatabaseManager.getDbManager().getInstance((CIMObjectPath)property2.getValue().getValue());
            resultList.add(target);
        }
    }

    private ArrayList createClassList(String namespace, String className) throws CIMException {
        ArrayList<String> classNames = new ArrayList<String>();
        CIMObjectPath resultOP = new CIMObjectPath(className);
        resultOP.setNameSpace(namespace);
        Enumeration enumCls = this.cimom.enumerateClasses(resultOP, true, false, false, true);
        while (enumCls.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)enumCls.nextElement();
            classNames.add(cimCls.getName());
        }
        if (!classNames.contains(className)) {
            classNames.add(className);
        }
        return classNames;
    }

    public CIMObjectPath[] associatorNames(CIMObjectPath assocOP, CIMObjectPath objectName, String resultClass, String role, String resultRole) throws CIMException {
        System.out.println("SIMULATOR : [ associatorNames ] ASSOC OP = " + assocOP);
        CIMInstance[] associations = this.associators(assocOP, objectName, resultClass, role, resultRole, false, false, null);
        CIMObjectPath[] objectPaths = new CIMObjectPath[associations.length];
        for (int i = 0; i < associations.length; ++i) {
            objectPaths[i] = associations[i].getObjectPath();
        }
        return objectPaths;
    }

    public CIMInstance[] references(CIMObjectPath assocOP, CIMObjectPath objectName, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        System.out.println("SIMULATOR : [ references ] ASSOC OP = " + assocOP);
        System.out.println("SIMULATOR : [ references ] OBJECT OP = " + objectName);
        ArrayList<CIMInstance> resultList = new ArrayList<CIMInstance>();
        try {
            boolean isAssociationIndexed = DatabaseManager.getDbManager().isAssociationIndex();
            String nameSpace = assocOP.getNameSpace();
            ArrayList classNames = this.createClassList(nameSpace, assocOP.getObjectName());
            System.out.println("Simulator: References: Value of is association index: " + isAssociationIndexed);
            if (isAssociationIndexed) {
                int objectID = DatabaseManager.getDbManager().getInstanceID(objectName);
                System.out.println("Simulator: References: Object id of source object is : " + objectID);
                if (-1 != objectID) {
                    Iterator iter = classNames.iterator();
                    while (iter.hasNext()) {
                        String className = (String)iter.next();
                        int classID = DatabaseManager.getDbManager().getClassID(nameSpace, className);
                        if (-1 == classID) continue;
                        resultList.addAll(DatabaseManager.getDbManager().getReferencedInstances(objectID, classID));
                    }
                }
            } else {
                List instancesList = DatabaseManager.getDbManager().enumerateInstances(nameSpace, assocOP.getObjectName());
                Iterator instanceIter = instancesList.iterator();
                block3: while (instanceIter.hasNext()) {
                    CIMInstance instance = (CIMInstance)instanceIter.next();
                    Vector keys = instance.getKeys();
                    Iterator iter = keys.iterator();
                    boolean isReferred = false;
                    while (iter.hasNext()) {
                        CIMProperty property = (CIMProperty)iter.next();
                        if (property.isReference()) {
                            CIMObjectPath path = (CIMObjectPath)property.getValue().getValue();
                            isReferred = SimulatorUtility.equalsCIMObjectPath(path, objectName);
                        }
                        if (!isReferred) continue;
                        System.out.println("Simulator: References: Instance found : " + instance.getObjectPath());
                        resultList.add(instance);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CIMInstance[] instArray = new CIMInstance[resultList.size()];
        resultList.toArray(instArray);
        Iterator iter = resultList.iterator();
        while (iter.hasNext()) {
            System.out.println("SIMULATOR : [references] DATA: " + ((CIMInstance)iter.next()).getObjectPath());
        }
        return instArray;
    }

    public CIMObjectPath[] referenceNames(CIMObjectPath assocOP, CIMObjectPath objectName, String role) throws CIMException {
        System.out.println("SIMULATOR : [ referenceNames ] ASSOC OP = " + assocOP);
        CIMInstance[] references = this.references(assocOP, objectName, role, false, false, null);
        CIMObjectPath[] objectPaths = new CIMObjectPath[references.length];
        for (int i = 0; i < references.length; ++i) {
            objectPaths[i] = references[i].getObjectPath();
        }
        return objectPaths;
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        CIMValue retValue = null;
        String className = op.getObjectName();
        boolean isDS6K_5_2 = className.startsWith("IBMTSDS");
        System.out.println("[SIMULATOR]: new invokeMethod Called for: " + methodName);
        String namespace = SimulatorUtility.fixNamespaceSlashIssue(op.getNameSpace());
        if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("CreateSetting")) {
            retValue = DS6kExtrinsicMethods.createSetting(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("CreateOrModifyElementFromStoragePool")) {
            retValue = isDS6K_5_2 ? DS6K5_2ExtrinsicMethods.createOrModifyElementFromStoragePool(op, inArgs, outArgs) : DS6kExtrinsicMethods.createOrModifyElementFromStoragePool(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("CreateOrModifyStoragePool")) {
            retValue = isDS6K_5_2 ? DS6K5_2ExtrinsicMethods.createOrModifyStoragePool(op, inArgs, outArgs) : DS6kExtrinsicMethods.createOrModifyStoragePool(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("DeleteStoragePool")) {
            retValue = DS6kExtrinsicMethods.deleteStoragePool(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("ReturnToStoragePool")) {
            retValue = isDS6K_5_2 ? DS6K5_2ExtrinsicMethods.returnToStoragePool(op, inArgs, outArgs) : DS6kExtrinsicMethods.returnToStoragePool(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("GetSupportedSizeRange")) {
            retValue = DS6kExtrinsicMethods.getSupportedSizeRange(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("GetSupportedSizes")) {
            retValue = DS6kExtrinsicMethods.getSupportedSizes(op, inArgs, outArgs);
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("HidePaths")) {
            if (isDS6K_5_2) {
                retValue = DS6K5_2ExtrinsicMethods.HidePaths(op, inArgs, outArgs);
            }
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("ExposePaths")) {
            if (isDS6K_5_2) {
                retValue = DS6K5_2ExtrinsicMethods.ExposePaths(op, inArgs, outArgs);
            }
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("CreateStorageHardwareID")) {
            if (isDS6K_5_2) {
                retValue = DS6K5_2ExtrinsicMethods.createStorageHardwareID(op, inArgs, outArgs);
            }
        } else if (namespace.equalsIgnoreCase("/root/ibm") && methodName.equalsIgnoreCase("DeleteStorageHardwareID") && isDS6K_5_2) {
            retValue = DS6K5_2ExtrinsicMethods.deleteStorageHardwareID(op, inArgs, outArgs);
        }
        return retValue;
    }
}

