/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.ClassNameConstants;
import org.xml.sax.SAXException;

public class DS6K5_2ExtrinsicMethods {
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    public static final String DS6K_XML_FILE_PATH = "XML\\Storage\\IBM\\DS6K\\DS6K5_2_Root_IBM.xml";
    private static final String CLIENT_SETTING_DATA_ELEMENT_NAME = "IBMTSDS:AIX";

    public static CIMValue createOrModifyStoragePool(CIMObjectPath storageConfigServiceOp, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        UnsignedInt64 remainingSpace = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (createOrModifyStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            CIMObjectPath[] poolOps = null;
            UnsignedInt64 requestedSize = null;
            CIMValue elementName = null;
            CIMArgument sizeArg = null;
            CIMObjectPath raidSettingOP = null;
            String raidSettingInstanceID = null;
            for (int i = 0; i < inArgs.length; ++i) {
                if (inArgs[i].getName().equalsIgnoreCase("InPools")) {
                    Vector pools = new Vector();
                    pools = (Vector)inArgs[i].getValue().getValue();
                    poolOps = new CIMObjectPath[pools.size()];
                    for (int j = 0; j < pools.size(); ++j) {
                        poolOps[j] = new CIMObjectPath((String)pools.get(j));
                    }
                    continue;
                }
                if (inArgs[i].getName().equalsIgnoreCase("Size")) {
                    requestedSize = (UnsignedInt64)inArgs[i].getValue().getValue();
                    sizeArg = inArgs[i];
                    continue;
                }
                if (inArgs[i].getName().equalsIgnoreCase("ElementName")) {
                    elementName = inArgs[i].getValue();
                    continue;
                }
                if (!inArgs[i].getName().equalsIgnoreCase("Goal") || inArgs[i].getValue() == null) continue;
                raidSettingOP = (CIMObjectPath)inArgs[i].getValue().getValue();
                raidSettingInstanceID = raidSettingOP.getKey("InstanceID").getValue().getValue().toString();
            }
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
            Iterator iter = storageSystemsOPs.iterator();
            CIMObjectPath storageSystemOp = null;
            String requiredSystemID = (String)storageConfigServiceOp.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            if (storageSystemOp != null) {
                String poolType;
                String poolInstanceID = poolOps[0].getKey("InstanceID").getValue().getValue().toString();
                List extentList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToArraySiteExtent", storageSystemOp);
                extentList.addAll(dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToArrayExtent", storageSystemOp));
                extentList.addAll(dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToRankExtent", storageSystemOp));
                CIMObjectPath extentOP = null;
                CIMInstance extentInst = null;
                iter = extentList.iterator();
                while (iter.hasNext()) {
                    extentInst = (CIMInstance)iter.next();
                    String arraySiteExtentDeviceID = (String)extentInst.getObjectPath().getKey("DeviceID").getValue().getValue();
                    if (!poolInstanceID.contains(arraySiteExtentDeviceID)) continue;
                    extentOP = extentInst.getObjectPath();
                    break;
                }
                if ((poolType = extentOP.getKey("CreationClassName").getValue().getValue().toString()).equals("IBMTSDS_ArraySiteExtent")) {
                    CIMObjectPath arraySitePoolOP = poolOps[0];
                    CIMInstance arraySitePoolInst = dbManager.getInstance(arraySitePoolOP);
                    CIMObjectPath arraySiteExtentOP = extentOP;
                    remainingSpace = (UnsignedInt64)arraySitePoolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                    UnsignedInt64 totalSpace = (UnsignedInt64)arraySitePoolInst.getProperty("TotalManagedSpace").getValue().getValue();
                    if (remainingSpace.compareTo((Object)requestedSize) >= 0) {
                        CIMArgument job;
                        Vector<UnsignedInt16> raidLevelArr;
                        ClassXMLParser parser = new ClassXMLParser();
                        ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                        InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                        SimClass simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayExtent");
                        CIMInstance arrayExtentInst = instanceCreator.createDefaultInstance(simClass);
                        arrayExtentInst.setProperty("DeviceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-A" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        arrayExtentInst.getObjectPath().getKey("DeviceID").setValue(arrayExtentInst.getProperty("DeviceID").getValue());
                        arrayExtentInst.setProperty("NumberOfBlocks", new CIMValue((Object)remainingSpace));
                        arrayExtentInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID, CIMDataType.getPredefinedType((int)8)));
                        arrayExtentInst.getObjectPath().getKey("SystemName").setValue(arrayExtentInst.getProperty("SystemName").getValue());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayPool");
                        CIMInstance arrayPoolInst = instanceCreator.createDefaultInstance(simClass);
                        arrayPoolInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-A" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        arrayPoolInst.getObjectPath().getKey("InstanceID").setValue(arrayPoolInst.getProperty("InstanceID").getValue());
                        arrayPoolInst.setProperty("TotalManagedSpace", new CIMValue((Object)remainingSpace));
                        arrayPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                        arrayPoolInst.setProperty("ElementName", new CIMValue((Object)("Array " + elementName.getValue() + " on " + requiredSystemID), CIMDataType.getPredefinedType((int)8)));
                        if (raidSettingInstanceID.contains("5")) {
                            raidLevelArr = new Vector<UnsignedInt16>();
                            raidLevelArr.add(new UnsignedInt16("4"));
                            arrayPoolInst.setProperty("RAIDLevel", new CIMValue(raidLevelArr, CIMDataType.getPredefinedType((int)16)));
                        } else if (raidSettingInstanceID.contains("10")) {
                            raidLevelArr = new Vector();
                            raidLevelArr.add(new UnsignedInt16("5"));
                            arrayPoolInst.setProperty("RAIDLevel", new CIMValue(raidLevelArr, CIMDataType.getPredefinedType((int)16)));
                        }
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayPoolCapabilities");
                        CIMInstance arrayPoolCapabilitiesInst = instanceCreator.createDefaultInstance(simClass);
                        arrayPoolCapabilitiesInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-A" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        arrayPoolCapabilitiesInst.setProperty("ElementName", new CIMValue((Object)("Capabilities for Array " + requiredSystemID + " -A" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        arrayPoolCapabilitiesInst.getObjectPath().getKey("InstanceID").setValue(arrayPoolCapabilitiesInst.getProperty("InstanceID").getValue());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayBasedOnArraySiteExtent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArraySiteExtent");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayExtent");
                        CIMInstance arrayBasedOnArraySiteExtentInst = instanceCreator.createAssociationInstance(simClass, arraySiteExtentOP, arrayExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_AllocatedFromArraySitePool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArraySitePool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayPool");
                        CIMInstance allocatedFromArraySitePoolInst = instanceCreator.createAssociationInstance(simClass, arraySitePoolOP, arrayPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayComponent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArrayPool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayExtent");
                        CIMInstance arrayComponentInst = instanceCreator.createAssociationInstance(simClass, arrayPoolInst.getObjectPath(), arrayExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_StorageSystemToArrayExtent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayExtent");
                        CIMInstance storageSystemToArrayExtentInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, arrayExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_HostedArrayPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayPool");
                        CIMInstance hostedArrayPoolInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, arrayPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ArrayPoolToCapabilities");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArrayPoolCapabilities");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ArrayPool");
                        CIMInstance arrayPoolToCapabilitiesInst = instanceCreator.createAssociationInstance(simClass, arrayPoolCapabilitiesInst.getObjectPath(), arrayPoolInst.getObjectPath());
                        remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(remainingSpace.bigIntValue()));
                        arraySitePoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                        dbManager.createInstance(arrayExtentInst);
                        dbManager.createInstance(arrayPoolInst);
                        dbManager.createInstance(arrayPoolCapabilitiesInst);
                        dbManager.createInstance(arrayBasedOnArraySiteExtentInst);
                        dbManager.createInstance(allocatedFromArraySitePoolInst);
                        dbManager.createInstance(arrayComponentInst);
                        dbManager.createInstance(storageSystemToArrayExtentInst);
                        dbManager.createInstance(hostedArrayPoolInst);
                        dbManager.createInstance(arrayPoolToCapabilitiesInst);
                        dbManager.updateInstance(arraySitePoolInst.getObjectPath(), arraySitePoolInst);
                        outArgs[0] = job = new CIMArgument("Job");
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)requestedSize));
                        outArgs[1] = sizeArgument;
                        CIMArgument pool = new CIMArgument("Pool");
                        pool.setValue(new CIMValue((Object)arrayPoolInst.getObjectPath()));
                        outArgs[2] = pool;
                        retValue = new CIMValue((Object)new UnsignedInt16(0));
                    } else {
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)remainingSpace));
                        outArgs[1] = sizeArgument;
                        retValue = new CIMValue((Object)new UnsignedInt16(4097));
                    }
                } else if (poolType.equals("IBMTSDS_ArrayExtent")) {
                    CIMObjectPath arrayPoolOP = poolOps[0];
                    CIMInstance arrayPoolInst = dbManager.getInstance(arrayPoolOP);
                    CIMObjectPath arrayExtentOP = extentOP;
                    remainingSpace = (UnsignedInt64)arrayPoolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                    UnsignedInt64 totalSpace = (UnsignedInt64)arrayPoolInst.getProperty("TotalManagedSpace").getValue().getValue();
                    if (remainingSpace.compareTo((Object)requestedSize) >= 0) {
                        CIMArgument job;
                        Vector<UnsignedInt16> raidLevelArr;
                        ClassXMLParser parser = new ClassXMLParser();
                        ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                        InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                        SimClass simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankPool");
                        CIMInstance rankPoolInst = instanceCreator.createDefaultInstance(simClass);
                        rankPoolInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-R" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        rankPoolInst.getObjectPath().getKey("InstanceID").setValue(rankPoolInst.getProperty("InstanceID").getValue());
                        rankPoolInst.setProperty("ElementName", new CIMValue((Object)("Rank " + elementName.getValue() + " on " + requiredSystemID), CIMDataType.getPredefinedType((int)8)));
                        rankPoolInst.setProperty("TotalManagedSpace", new CIMValue((Object)remainingSpace));
                        rankPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                        if (raidSettingInstanceID.contains("5")) {
                            raidLevelArr = new Vector<UnsignedInt16>();
                            raidLevelArr.add(new UnsignedInt16("4"));
                            rankPoolInst.setProperty("RAIDLevel", new CIMValue(raidLevelArr, CIMDataType.getPredefinedType((int)16)));
                        } else if (raidSettingInstanceID.contains("10")) {
                            raidLevelArr = new Vector();
                            raidLevelArr.add(new UnsignedInt16("5"));
                            rankPoolInst.setProperty("RAIDLevel", new CIMValue(raidLevelArr, CIMDataType.getPredefinedType((int)16)));
                        }
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankExtent");
                        CIMInstance rankExtentInst = instanceCreator.createDefaultInstance(simClass);
                        rankExtentInst.setProperty("DeviceID", new CIMValue((Object)(requiredSystemID + "-R" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        rankExtentInst.getObjectPath().getKey("DeviceID").setValue(rankExtentInst.getProperty("DeviceID").getValue());
                        rankExtentInst.setProperty("ElementName", new CIMValue((Object)("Rank " + elementName.getValue() + " on " + requiredSystemID), CIMDataType.getPredefinedType((int)8)));
                        rankExtentInst.setProperty("NumberOfBlocks", new CIMValue((Object)remainingSpace));
                        if (raidSettingInstanceID.contains("5")) {
                            rankExtentInst.setProperty("NumOfDataDisks", new CIMValue((Object)new UnsignedInt16("2")));
                        } else if (raidSettingInstanceID.contains("10")) {
                            rankExtentInst.setProperty("NumOfDataDisks", new CIMValue((Object)new UnsignedInt16("1")));
                        }
                        rankExtentInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID, CIMDataType.getPredefinedType((int)8)));
                        rankExtentInst.getObjectPath().getKey("SystemName").setValue(rankExtentInst.getProperty("SystemName").getValue());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankPoolCapabilities");
                        CIMInstance rankPoolCapabilitiesInst = instanceCreator.createDefaultInstance(simClass);
                        rankPoolCapabilitiesInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-R" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        rankPoolCapabilitiesInst.setProperty("ElementName", new CIMValue((Object)("Capabilities for Rank " + requiredSystemID + " -R" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        rankPoolCapabilitiesInst.getObjectPath().getKey("InstanceID").setValue(rankPoolCapabilitiesInst.getProperty("InstanceID").getValue());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankBasedOnArrayExtent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArrayExtent");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankExtent");
                        CIMInstance rankBasedOnArrayExtentInst = instanceCreator.createAssociationInstance(simClass, arrayExtentOP, rankExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankComponent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_RankPool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankExtent");
                        CIMInstance rankComponentInst = instanceCreator.createAssociationInstance(simClass, rankPoolInst.getObjectPath(), rankExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_StorageSystemToRankExtent");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankExtent");
                        CIMInstance storageSystemToRankExtentInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, rankExtentInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_AllocatedFromArrayPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ArrayPool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankPool");
                        CIMInstance allocatedFromArrayPoolInst = instanceCreator.createAssociationInstance(simClass, arrayPoolInst.getObjectPath(), rankPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_HostedRankPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankPool");
                        CIMInstance hostedRankPoolInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, rankPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_RankPoolToCapabilities");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_RankPoolCapabilities");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_RankPool");
                        CIMInstance rankPoolToCapabilitiesInst = instanceCreator.createAssociationInstance(simClass, rankPoolCapabilitiesInst.getObjectPath(), rankPoolInst.getObjectPath());
                        remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(remainingSpace.bigIntValue()));
                        arrayPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                        dbManager.createInstance(rankPoolInst);
                        dbManager.createInstance(rankExtentInst);
                        dbManager.createInstance(rankPoolCapabilitiesInst);
                        dbManager.createInstance(rankBasedOnArrayExtentInst);
                        dbManager.createInstance(rankComponentInst);
                        dbManager.createInstance(storageSystemToRankExtentInst);
                        dbManager.createInstance(allocatedFromArrayPoolInst);
                        dbManager.createInstance(hostedRankPoolInst);
                        dbManager.createInstance(rankPoolToCapabilitiesInst);
                        dbManager.updateInstance(arrayPoolInst.getObjectPath(), arrayPoolInst);
                        outArgs[0] = job = new CIMArgument("Job");
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)requestedSize));
                        outArgs[1] = sizeArgument;
                        CIMArgument pool = new CIMArgument("Pool");
                        pool.setValue(new CIMValue((Object)rankPoolInst.getObjectPath()));
                        outArgs[2] = pool;
                        retValue = new CIMValue((Object)new UnsignedInt16(0));
                    } else {
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)remainingSpace));
                        outArgs[1] = sizeArgument;
                        retValue = new CIMValue((Object)new UnsignedInt16(4097));
                    }
                } else if (poolType.equals("IBMTSDS_RankExtent")) {
                    remainingSpace = new UnsignedInt64("0");
                    CIMInstance rankPoolInst = null;
                    for (int cnt = 0; cnt < poolOps.length; ++cnt) {
                        CIMObjectPath rankPoolOP = poolOps[cnt];
                        rankPoolInst = dbManager.getInstance(rankPoolOP);
                        UnsignedInt64 tmpRemainingManagedSpace = (UnsignedInt64)rankPoolInst.getProperty("RemainingManagedSpace").getValue().getValue();
                        remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().add(tmpRemainingManagedSpace.bigIntValue()));
                    }
                    if (remainingSpace.compareTo((Object)requestedSize) >= 0) {
                        CIMArgument job;
                        ClassXMLParser parser = new ClassXMLParser();
                        ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                        InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                        SimClass simClass = (SimClass)response.getClassMap().get("IBMTSDS_ExtentPool");
                        CIMInstance extentPoolInst = instanceCreator.createDefaultInstance(simClass);
                        extentPoolInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-P" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        extentPoolInst.getObjectPath().getKey("InstanceID").setValue(extentPoolInst.getProperty("InstanceID").getValue());
                        extentPoolInst.setProperty("TotalManagedSpace", new CIMValue((Object)requestedSize));
                        extentPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)requestedSize));
                        extentPoolInst.setProperty("PoolID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-P" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        extentPoolInst.setProperty("ElementName", new CIMValue((Object)("Extent Pool " + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ExtentPoolCapabilities");
                        CIMInstance extentPoolCapabilitiesInst = instanceCreator.createDefaultInstance(simClass);
                        extentPoolCapabilitiesInst.setProperty("InstanceID", new CIMValue((Object)("IBMTSDS:" + requiredSystemID + "-P" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        extentPoolCapabilitiesInst.getObjectPath().getKey("InstanceID").setValue(extentPoolCapabilitiesInst.getProperty("InstanceID").getValue());
                        extentPoolCapabilitiesInst.setProperty("ElementName", new CIMValue((Object)("Capabilities for ExtentPool " + requiredSystemID + " -P" + elementName.getValue()), CIMDataType.getPredefinedType((int)8)));
                        CIMInstance[] allocatedFromRankPoolInst = new CIMInstance[poolOps.length];
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_AllocatedFromRankPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_RankPool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ExtentPool");
                        for (int cnt = 0; cnt < poolOps.length; ++cnt) {
                            allocatedFromRankPoolInst[cnt] = instanceCreator.createAssociationInstance(simClass, poolOps[cnt], extentPoolInst.getObjectPath());
                        }
                        List primordialStoragePool = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_PrimordialStoragePool");
                        iter = primordialStoragePool.iterator();
                        CIMInstance primordialStoragePoolInst = null;
                        while (iter.hasNext() && !(primordialStoragePoolInst = (CIMInstance)iter.next()).getProperty("InstanceID").toString().equalsIgnoreCase(requiredSystemID)) {
                        }
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_PrimordialToExtentPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_PrimordialStoragePool");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ExtentPool");
                        CIMInstance primordialToExtentPoolInst = instanceCreator.createAssociationInstance(simClass, primordialStoragePoolInst.getObjectPath(), extentPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_ExtentPoolToCapabilities");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ExtentPoolCapabilities");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ExtentPool");
                        CIMInstance extentPoolToCapabilitiesInst = instanceCreator.createAssociationInstance(simClass, extentPoolCapabilitiesInst.getObjectPath(), extentPoolInst.getObjectPath());
                        simClass = (SimClass)response.getClassMap().get("IBMTSDS_HostedExtentPool");
                        ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                        ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_ExtentPool");
                        CIMInstance hostedRankPoolInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, extentPoolInst.getObjectPath());
                        remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(remainingSpace.bigIntValue()));
                        rankPoolInst.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                        dbManager.createInstance(extentPoolInst);
                        dbManager.createInstance(extentPoolCapabilitiesInst);
                        dbManager.createInstance(primordialToExtentPoolInst);
                        dbManager.createInstance(extentPoolToCapabilitiesInst);
                        dbManager.createInstance(hostedRankPoolInst);
                        for (int idx = 0; idx < allocatedFromRankPoolInst.length; ++idx) {
                            dbManager.createInstance(allocatedFromRankPoolInst[idx]);
                        }
                        dbManager.updateInstance(rankPoolInst.getObjectPath(), rankPoolInst);
                        outArgs[0] = job = new CIMArgument("Job");
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)requestedSize));
                        outArgs[1] = sizeArgument;
                        CIMArgument pool = new CIMArgument("Pool");
                        pool.setValue(new CIMValue((Object)extentPoolInst.getObjectPath()));
                        outArgs[2] = pool;
                        retValue = new CIMValue((Object)new UnsignedInt16(0));
                    } else {
                        CIMArgument sizeArgument = new CIMArgument("Size");
                        sizeArgument.setValue(new CIMValue((Object)remainingSpace));
                        outArgs[1] = sizeArgument;
                        retValue = new CIMValue((Object)new UnsignedInt16(4097));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue createOrModifyElementFromStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (createOrModifyElementFromStoragePool) Called");
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            List storageSystemsOPs = dbManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
            Iterator iter = storageSystemsOPs.iterator();
            CIMObjectPath storageSystemOp = null;
            String requiredSystemID = (String)op.getKey("SystemName").getValue().getValue();
            while (iter.hasNext()) {
                CIMObjectPath objectPath = (CIMObjectPath)iter.next();
                String systemName = (String)objectPath.getKey("Name").getValue().getValue();
                if (!systemName.equalsIgnoreCase(requiredSystemID)) continue;
                storageSystemOp = objectPath;
                break;
            }
            UnsignedInt64 requestedSize = null;
            String elementName = null;
            CIMObjectPath extentPoolOp = null;
            for (int i = 0; i < inArgs.length; ++i) {
                if (inArgs[i].getName().equalsIgnoreCase("InPool")) {
                    extentPoolOp = (CIMObjectPath)inArgs[i].getValue().getValue();
                    continue;
                }
                if (inArgs[i].getName().equalsIgnoreCase("Size")) {
                    requestedSize = (UnsignedInt64)inArgs[i].getValue().getValue();
                    continue;
                }
                if (!inArgs[i].getName().equalsIgnoreCase("ElementName")) continue;
                elementName = inArgs[i].getValue().getValue().toString();
            }
            CIMInstance extentPoolInst = dbManager.getInstance(extentPoolOp);
            UnsignedInt64 remainingSpace = (UnsignedInt64)extentPoolInst.getProperty("RemainingManagedSpace").getValue().getValue();
            UnsignedInt64 blockSize = new UnsignedInt64("512");
            UnsignedInt64 numOfBlocks = new UnsignedInt64(requestedSize.bigIntValue().divide(blockSize.bigIntValue()));
            CIMObjectPath rankExtentOP = null;
            List allocatedFromRankPoolOPs = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_AllocatedFromRankPool");
            iter = allocatedFromRankPoolOPs.iterator();
            while (iter.hasNext()) {
                CIMInstance tmpInst = (CIMInstance)iter.next();
                CIMObjectPath dependentOP = (CIMObjectPath)tmpInst.getObjectPath().getKey("Dependent").getValue().getValue();
                if (!dependentOP.getKey("InstanceID").getValue().getValue().toString().equalsIgnoreCase(extentPoolOp.getKey("InstanceID").getValue().getValue().toString())) continue;
                CIMObjectPath antecedentOP = (CIMObjectPath)tmpInst.getObjectPath().getKey("Antecedent").getValue().getValue();
                List rankComponentOPs = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_RankComponent");
                Iterator iterTmp = rankComponentOPs.iterator();
                while (iterTmp.hasNext()) {
                    CIMInstance tempInst = (CIMInstance)iterTmp.next();
                    CIMObjectPath groupComponentOP = (CIMObjectPath)tempInst.getObjectPath().getKey("GroupComponent").getValue().getValue();
                    if (!groupComponentOP.getKey("InstanceID").getValue().getValue().toString().equalsIgnoreCase(antecedentOP.getKey("InstanceID").getValue().getValue().toString())) continue;
                    rankExtentOP = (CIMObjectPath)tempInst.getObjectPath().getKey("PartComponent").getValue().getValue();
                }
            }
            if (remainingSpace.compareTo((Object)requestedSize) >= 0) {
                ClassXMLParser parser = new ClassXMLParser();
                ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
                InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                SimClass simClass = (SimClass)response.getClassMap().get("IBMTSDS_Volume");
                CIMInstance volumeInst = instanceCreator.createDefaultInstance(simClass);
                volumeInst.setProperty("DeviceID", new CIMValue((Object)(requiredSystemID + DS6K5_2ExtrinsicMethods.appendSuffix(storageSystemOp)), CIMDataType.getPredefinedType((int)8)));
                volumeInst.getObjectPath().getKey("DeviceID").setValue(volumeInst.getProperty("DeviceID").getValue());
                volumeInst.setProperty("ElementName", new CIMValue((Object)elementName, CIMDataType.getPredefinedType((int)8)));
                volumeInst.setProperty("Name", volumeInst.getProperty("DeviceID").getValue());
                volumeInst.setProperty("NumberOfBlocks", new CIMValue((Object)numOfBlocks));
                volumeInst.setProperty("SystemName", new CIMValue((Object)requiredSystemID, CIMDataType.getPredefinedType((int)8)));
                volumeInst.getObjectPath().getKey("SystemName").setValue(volumeInst.getProperty("SystemName").getValue());
                simClass = (SimClass)response.getClassMap().get("IBMTSDS_AllocatedFromExtentPool");
                ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_ExtentPool");
                ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_Volume");
                CIMInstance allocatedFromExtentPoolInst = instanceCreator.createAssociationInstance(simClass, extentPoolOp, volumeInst.getObjectPath());
                simClass = (SimClass)response.getClassMap().get("IBMTSDS_StorageSystemToVolume");
                ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_StorageSystem");
                ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_Volume");
                CIMInstance storageSystemToVolumeInst = instanceCreator.createAssociationInstance(simClass, storageSystemOp, volumeInst.getObjectPath());
                simClass = (SimClass)response.getClassMap().get("IBMTSDS_VolumeBasedOnRankExtent");
                ((SimAssociationClass)simClass).setAntecedentClassName("IBMTSDS_RankExtent");
                ((SimAssociationClass)simClass).setDependentClassName("IBMTSDS_Volume");
                CIMInstance volumeBasedOnRankExtentInst = instanceCreator.createAssociationInstance(simClass, rankExtentOP, volumeInst.getObjectPath());
                remainingSpace = new UnsignedInt64(remainingSpace.bigIntValue().subtract(requestedSize.bigIntValue()));
                CIMInstance extentPoolInstance = dbManager.getInstance(extentPoolOp);
                extentPoolInstance.setProperty("RemainingManagedSpace", new CIMValue((Object)remainingSpace));
                dbManager.createInstance(volumeInst);
                dbManager.createInstance(allocatedFromExtentPoolInst);
                dbManager.createInstance(storageSystemToVolumeInst);
                dbManager.createInstance(volumeBasedOnRankExtentInst);
                dbManager.updateInstance(extentPoolInst.getObjectPath(), extentPoolInstance);
                CIMArgument argumentJob = new CIMArgument("Job");
                argumentJob.setValue(new CIMValue((Object)extentPoolInst));
                outArgs[0] = argumentJob;
                CIMArgument sizeArgument = new CIMArgument("Size");
                sizeArgument.setValue(new CIMValue((Object)requestedSize));
                outArgs[1] = sizeArgument;
                CIMArgument argument = new CIMArgument("TheElement");
                argument.setValue(new CIMValue((Object)volumeInst.getObjectPath()));
                outArgs[2] = argument;
                retValue = new CIMValue((Object)new UnsignedInt16(0));
            } else {
                CIMArgument sizeArgument = new CIMArgument("Size");
                sizeArgument.setValue(new CIMValue((Object)remainingSpace));
                outArgs[1] = sizeArgument;
                retValue = new CIMValue((Object)new UnsignedInt16(4097));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    private static String appendSuffix(CIMObjectPath storageSystemOp) {
        String deviceIDSuffix;
        block4: {
            deviceIDSuffix = "1000";
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            try {
                List volumeList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToVolume", storageSystemOp);
                Iterator volumeIter = volumeList.iterator();
                ArrayList<String> occupiedDeviceIDSuffix = new ArrayList<String>();
                while (volumeIter.hasNext()) {
                    CIMInstance volumeInst = (CIMInstance)volumeIter.next();
                    String deviceID = volumeInst.getProperty("DeviceID").getValue().getValue().toString();
                    String suffix = deviceID.substring(deviceID.lastIndexOf("-") + 1, deviceID.length());
                    occupiedDeviceIDSuffix.add(suffix);
                }
                if (occupiedDeviceIDSuffix == null) break block4;
                for (int availableSuffix = 1000; availableSuffix < 9999; ++availableSuffix) {
                    if (occupiedDeviceIDSuffix.contains(Integer.toString(availableSuffix))) continue;
                    deviceIDSuffix = Integer.toString(availableSuffix);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "-" + deviceIDSuffix;
    }

    public static CIMValue createStorageHardwareID(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retVal = null;
        CIMValue storageID = null;
        CIMValue elementName = null;
        CIMValue IDtype = null;
        CIMValue otherIDType = null;
        CIMValue instanceID = null;
        CIMInstance storageHardwareIDMgmServiceInst = null;
        CIMObjectPath storageHrdwareIDtoCreateOP = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (createStorageHardwareID) Called");
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            storageHardwareIDMgmServiceInst = dbManager.getInstance(op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int propIdx = 0; propIdx < inArgs.length; ++propIdx) {
            CIMArgument argument = inArgs[propIdx];
            String propertyName = argument.getName();
            CIMValue propertyValue = argument.getValue();
            if (propertyName.equalsIgnoreCase("ElementName")) {
                elementName = propertyValue;
                continue;
            }
            if (propertyName.equalsIgnoreCase("IDType")) {
                IDtype = propertyValue;
                continue;
            }
            if (propertyName.equalsIgnoreCase("OtherIDType")) {
                otherIDType = propertyValue;
                continue;
            }
            if (propertyName.equalsIgnoreCase("StorageID")) {
                storageID = propertyValue;
                continue;
            }
            if (!propertyName.equalsIgnoreCase("HardwareID")) continue;
            storageHrdwareIDtoCreateOP = (CIMObjectPath)propertyValue.getValue();
        }
        instanceID = storageHrdwareIDtoCreateOP.getKey("InstanceID").getValue();
        DS6K5_2ExtrinsicMethods.createStorageHardwareIDInstance(storageHardwareIDMgmServiceInst, elementName, storageID, IDtype, otherIDType, instanceID);
        retVal = new CIMValue((Object)new UnsignedInt16(0));
        System.out.println("Storage Hardware ID Created Successfully");
        return retVal;
    }

    private static CIMInstance createStorageHardwareIDInstance(CIMInstance storageHardwareIDMgmServiceInst, CIMValue elementName, CIMValue storageID, CIMValue IDtype, CIMValue otherIDType, CIMValue instanceID) {
        CIMInstance storagehardwareIDInst = null;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        CIMObjectPath storageSystemOp = null;
        String systemName = storageHardwareIDMgmServiceInst.getProperty("SystemName").getValue().getValue().toString();
        try {
            List storageSysList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
            Iterator sysIter = storageSysList.iterator();
            while (sysIter.hasNext()) {
                CIMInstance sysInst = (CIMInstance)sysIter.next();
                String sysName = sysInst.getProperty("Name").getValue().getValue().toString();
                if (!sysName.equalsIgnoreCase(systemName)) continue;
                storageSystemOp = sysInst.getObjectPath();
                break;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            String settingDataInstanceId;
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass simClass = (SimClass)response.getClassMap().get("IBMTSDS_StorageHardwareID");
            storagehardwareIDInst = instanceCreator.createDefaultInstance(simClass);
            if (elementName != null) {
                storagehardwareIDInst.setProperty("ElementName", elementName);
            }
            storagehardwareIDInst.setProperty("StorageID", storageID);
            if (IDtype != null) {
                storagehardwareIDInst.setProperty("IDType", IDtype);
            }
            if (otherIDType != null) {
                storagehardwareIDInst.setProperty("OtherIDType", otherIDType);
            }
            storagehardwareIDInst.setProperty("InstanceID", instanceID);
            storagehardwareIDInst.getObjectPath().getKey("InstanceID").setValue(instanceID);
            dbManager.createInstance(storagehardwareIDInst);
            SimClass simClassAuthorisedPrivilege = (SimClass)response.getClassMap().get("IBMTSDS_Privilege");
            CIMInstance authorisedPrivilegeInst = instanceCreator.createDefaultInstance(simClassAuthorisedPrivilege);
            authorisedPrivilegeInst.getProperty("InstanceID").setValue(instanceID);
            authorisedPrivilegeInst.getObjectPath().getKey("InstanceID").setValue(instanceID);
            dbManager.createInstance(authorisedPrivilegeInst);
            SimClass simClassAuthorisedSubject = (SimClass)response.getClassMap().get("IBMTSDS_AuthorizedSubject");
            CIMInstance authorisedSubjectInst = instanceCreator.createAssociationInstance(simClassAuthorisedSubject, authorisedPrivilegeInst, storagehardwareIDInst);
            dbManager.createInstance(authorisedSubjectInst);
            SimClass associationClass = (SimClass)response.getClassMap().get("IBMTSDS_ConcreteDependencyStorageHardwareID");
            CIMInstance concreteDependencyInst = instanceCreator.createAssociationInstance(associationClass, storageHardwareIDMgmServiceInst, storagehardwareIDInst);
            dbManager.createInstance(concreteDependencyInst);
            List privilegeMgmtServiceList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_HostedPrivilegeManagementService", storageSystemOp);
            Iterator privilegeMgmtIter = privilegeMgmtServiceList.iterator();
            CIMInstance privilegeMgmtServiceInst = null;
            if (privilegeMgmtIter.hasNext()) {
                privilegeMgmtServiceInst = (CIMInstance)privilegeMgmtIter.next();
            }
            SimClass simClassPrivilegeMgmtService = (SimClass)response.getClassMap().get("IBMTSDS_ConcreteDependencyPrivilege");
            CIMInstance dependencyPrivilegeInst = instanceCreator.createAssociationInstance(simClassPrivilegeMgmtService, privilegeMgmtServiceInst, authorisedPrivilegeInst);
            dbManager.createInstance(dependencyPrivilegeInst);
            List clientSettingDataList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_SystemElementSettingData", storageSystemOp);
            Iterator clientSettingdataIter = clientSettingDataList.iterator();
            CIMInstance settingDataInst = null;
            while (clientSettingdataIter.hasNext() && !(settingDataInstanceId = (settingDataInst = (CIMInstance)clientSettingdataIter.next()).getProperty("InstanceID").getValue().getValue().toString()).equalsIgnoreCase(CLIENT_SETTING_DATA_ELEMENT_NAME)) {
            }
            SimClass simClassInitiatorSettingData = (SimClass)response.getClassMap().get("IBMTSDS_InitiatorElementSettingData");
            CIMInstance initiatorClientSettingInst = instanceCreator.createAssociationInstance(simClassInitiatorSettingData, storagehardwareIDInst, settingDataInst);
            dbManager.createInstance(initiatorClientSettingInst);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return storagehardwareIDInst;
    }

    public static CIMValue deleteStorageHardwareID(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        CIMObjectPath concreteDependencyOP = null;
        try {
            DatabaseManager dbManager = DatabaseManager.getDbManager();
            CIMObjectPath storagehardwareIDop = (CIMObjectPath)inArgs[0].getValue().getValue();
            CIMValue instanceIDofHardwareIDtoDelete = storagehardwareIDop.getKey("InstanceID").getValue();
            List associationList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_ConcreteDependencyStorageHardwareID");
            Iterator iter = associationList.iterator();
            while (iter.hasNext()) {
                CIMInstance associationInst = (CIMInstance)iter.next();
                CIMObjectPath stHwIdOP = (CIMObjectPath)associationInst.getObjectPath().getKey("Dependent").getValue().getValue();
                CIMValue instacneID = stHwIdOP.getKey("InstanceID").getValue();
                if (!instanceIDofHardwareIDtoDelete.equals((Object)instacneID)) continue;
                concreteDependencyOP = associationInst.getObjectPath();
                break;
            }
            dbManager.deleteInstance(storagehardwareIDop);
            dbManager.deleteInstance(concreteDependencyOP);
            retValue = new CIMValue((Object)new UnsignedInt16(0));
            System.out.println("Storage Hardware ID Created Successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static CIMValue ExposePaths(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMArgument argumentJob;
        CIMInstance controllerConfigServiceInst = null;
        Vector lunNames = null;
        Vector initiatorPortID = null;
        Vector targetPortIDs = null;
        Vector deviceNumbers = null;
        Vector deviceAccess = null;
        CIMObjectPath[] scsiProtocolControllerRef = null;
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (exposePath) Called");
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            controllerConfigServiceInst = dbManager.getInstance(op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int propIdx = 0; propIdx < inArgs.length; ++propIdx) {
            CIMArgument argument = inArgs[propIdx];
            String propertyName = argument.getName();
            CIMValue propertyValue = argument.getValue();
            if (propertyName.equalsIgnoreCase("LUNames")) {
                lunNames = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("InitiatorPortIDs")) {
                if (propertyValue == null) continue;
                initiatorPortID = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("TargetPortIDs")) {
                if (propertyValue == null) continue;
                targetPortIDs = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("DeviceNumber")) {
                if (propertyValue == null) continue;
                deviceNumbers = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("DeviceAccess")) {
                deviceAccess = (Vector)propertyValue.getValue();
                continue;
            }
            if (!propertyName.equalsIgnoreCase("ProtocolControllers") || propertyValue.getValue() == null) continue;
            scsiProtocolControllerRef = new CIMObjectPath[]{new CIMObjectPath(propertyValue.getValue().toString())};
        }
        CIMObjectPath spcOp = null;
        if (scsiProtocolControllerRef == null) {
            String deviceID = (String)initiatorPortID.get(0);
            System.out.println("[Debug] Going to create SCSIProtocol Controller Instance!");
            spcOp = DS6K5_2ExtrinsicMethods.createProtocolController(controllerConfigServiceInst, deviceID);
        } else {
            spcOp = scsiProtocolControllerRef[0];
        }
        if (lunNames != null && initiatorPortID == null && targetPortIDs == null) {
            DS6K5_2ExtrinsicMethods.addLUNtoView(lunNames, spcOp);
        }
        if (lunNames == null && initiatorPortID != null && targetPortIDs == null) {
            DS6K5_2ExtrinsicMethods.addInitiatorIDtoView(initiatorPortID, spcOp);
        }
        if (lunNames == null && initiatorPortID == null && targetPortIDs != null) {
            DS6K5_2ExtrinsicMethods.addTargetportIDtoView(targetPortIDs, spcOp);
        }
        if (lunNames != null && initiatorPortID != null && targetPortIDs != null && DS6K5_2ExtrinsicMethods.addLUNtoView(lunNames, spcOp) == 0 && DS6K5_2ExtrinsicMethods.addInitiatorIDtoView(initiatorPortID, spcOp) == 0 && DS6K5_2ExtrinsicMethods.addTargetportIDtoView(targetPortIDs, spcOp) == 0) {
            retValue = new CIMValue((Object)new UnsignedInt16(0));
        }
        if (lunNames != null && initiatorPortID != null && targetPortIDs == null) {
            DS6K5_2ExtrinsicMethods.addLUNtoView(lunNames, spcOp);
        }
        outArgs[0] = argumentJob = new CIMArgument("Job");
        CIMArgument argumentSPCref = new CIMArgument("ProtocolControllers");
        argumentSPCref.setValue(new CIMValue(null));
        outArgs[1] = argumentSPCref;
        retValue = new CIMValue((Object)new UnsignedInt16(0));
        return retValue;
    }

    private static CIMObjectPath createProtocolController(CIMInstance controllerConfigServiceInst, String storageID) {
        CIMObjectPath spcOp = null;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        CIMObjectPath storageSystemOp = null;
        try {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass simClassProtocolController = (SimClass)response.getClassMap().get("IBMTSDS_SCSIProtocolController");
            CIMInstance storageHardwareIDInst = null;
            List storageHardwareIDList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageHardwareID");
            Iterator hardwareIDIter = storageHardwareIDList.iterator();
            while (hardwareIDIter.hasNext()) {
                CIMInstance hardwareIDInst = (CIMInstance)hardwareIDIter.next();
                String tempStorageID = hardwareIDInst.getProperty("StorageID").getValue().getValue().toString();
                if (!tempStorageID.equals(storageID)) continue;
                storageHardwareIDInst = hardwareIDInst;
                break;
            }
            String systemName = controllerConfigServiceInst.getProperty("SystemName").getValue().getValue().toString();
            try {
                List storageSysList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
                Iterator sysIter = storageSysList.iterator();
                while (sysIter.hasNext()) {
                    CIMInstance sysInst = (CIMInstance)sysIter.next();
                    String sysName = sysInst.getProperty("Name").getValue().getValue().toString();
                    if (!sysName.equalsIgnoreCase(systemName)) continue;
                    storageSystemOp = sysInst.getObjectPath();
                    break;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (storageHardwareIDInst == null) {
                List storageHwMgmtServiceList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_HostedStorageHardwareIDManagementService", storageSystemOp);
                CIMInstance storageHwMgmtServiceInst = null;
                Iterator storageHwMgmtIter = storageHwMgmtServiceList.iterator();
                if (storageHwMgmtIter.hasNext()) {
                    storageHwMgmtServiceInst = (CIMInstance)storageHwMgmtIter.next();
                }
                systemName = "IBMTSDS:" + storageHwMgmtServiceInst.getProperty("SystemName").getValue().getValue().toString() + "-";
                String strInstanceID = systemName + storageID + "-1";
                CIMValue instanceID = new CIMValue((Object)strInstanceID);
                CIMValue StorageID = new CIMValue((Object)storageID, CIMDataType.getPredefinedType((int)8));
                CIMValue idType = new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2));
                storageHardwareIDInst = DS6K5_2ExtrinsicMethods.createStorageHardwareIDInstance(storageHwMgmtServiceInst, null, StorageID, idType, null, instanceID);
            }
            String deviceID = storageHardwareIDInst.getProperty("InstanceID").getValue().getValue().toString();
            deviceID = deviceID.split("IBMTSDS:")[1];
            systemName = controllerConfigServiceInst.getObjectPath().getKey("SystemName").getValue().getValue().toString();
            CIMInstance protocolControllerInst = instanceCreator.createDefaultInstance(simClassProtocolController);
            protocolControllerInst.getProperty("DeviceID").setValue(new CIMValue((Object)deviceID));
            protocolControllerInst.getProperty("SystemName").setValue(new CIMValue((Object)systemName));
            protocolControllerInst.getObjectPath().getKey("DeviceID").setValue(new CIMValue((Object)deviceID));
            protocolControllerInst.getObjectPath().getKey("SystemName").setValue(new CIMValue((Object)systemName));
            dbManager.createInstance(protocolControllerInst);
            spcOp = protocolControllerInst.getObjectPath();
            System.out.println("[Debug] ProtocolController Instance Created !");
            SimClass simClassConcreteDependency = (SimClass)response.getClassMap().get("IBMTSDS_ConcreteDependencyController");
            CIMInstance concreteDependencyInst = instanceCreator.createAssociationInstance(simClassConcreteDependency, controllerConfigServiceInst, protocolControllerInst);
            dbManager.createInstance(concreteDependencyInst);
            SimClass sapAvailableForElementClass = (SimClass)response.getClassMap().get("IBMTSDS_SAPAvailableForElement");
            List scsiProtocolEndPoint = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_SCSIProtocolEndpoint");
            Iterator protcolEndPointIter = scsiProtocolEndPoint.iterator();
            while (protcolEndPointIter.hasNext()) {
                CIMInstance protocolEndPointInst = (CIMInstance)protcolEndPointIter.next();
                CIMInstance sapAvailableForElementInst = instanceCreator.createAssociationInstance(sapAvailableForElementClass, protocolEndPointInst, protocolControllerInst);
                dbManager.createInstance(sapAvailableForElementInst);
            }
            List privilegeList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_Privilege");
            Iterator privilegeIter = privilegeList.iterator();
            CIMInstance authorisedPrivilegeInst = null;
            while (privilegeIter.hasNext()) {
                CIMValue storageHwInstanceID;
                CIMInstance privilegeInst = (CIMInstance)privilegeIter.next();
                CIMValue privilegeInstanceID = privilegeInst.getProperty("InstanceID").getValue();
                if (!privilegeInstanceID.equals((Object)(storageHwInstanceID = storageHardwareIDInst.getProperty("InstanceID").getValue()))) continue;
                authorisedPrivilegeInst = privilegeInst;
                break;
            }
            SimClass simClassAuthorisedTarget = (SimClass)response.getClassMap().get("IBMTSDS_AuthorizedTarget");
            CIMInstance authorisedTargetInst = instanceCreator.createAssociationInstance(simClassAuthorisedTarget, authorisedPrivilegeInst, protocolControllerInst);
            dbManager.createInstance(authorisedTargetInst);
            SimClass simClassShwidToSPC = (SimClass)response.getClassMap().get("IBMTSDS_SHWIDToSPC");
            CIMInstance shwIdToSpcInst = instanceCreator.createAssociationInstance(simClassShwidToSPC, storageHardwareIDInst, protocolControllerInst);
            dbManager.createInstance(shwIdToSpcInst);
            List storageSystemList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
            Iterator storageSysIter = storageSystemList.iterator();
            CIMInstance storageSystemInst = null;
            while (storageSysIter.hasNext()) {
                CIMInstance sysInst = (CIMInstance)storageSysIter.next();
                String sysName = sysInst.getProperty("Name").getValue().getValue().toString();
                if (!systemName.equalsIgnoreCase(sysName)) continue;
                storageSystemInst = sysInst;
                break;
            }
            SimClass simClassStorageToSpc = (SimClass)response.getClassMap().get(ClassNameConstants.CLASS_IBMTSDS_STORAGE_TO_SPC);
            CIMInstance storageToSpcInst = instanceCreator.createAssociationInstance(simClassStorageToSpc, storageSystemInst, protocolControllerInst);
            dbManager.createInstance(storageToSpcInst);
            SimClass simClassStgSysToFcPort = (SimClass)response.getClassMap().get(ClassNameConstants.CLASS_IBMTSDS_PROTOCOL_CONTROLLER_FOR_PORT);
            List fcPortList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToFCPort", storageSystemOp);
            Iterator portIter = fcPortList.iterator();
            while (portIter.hasNext()) {
                CIMInstance fcPortInst = (CIMInstance)portIter.next();
                CIMInstance stgSysToFcPortInst = instanceCreator.createAssociationInstance(simClassStgSysToFcPort, protocolControllerInst, fcPortInst);
                dbManager.createInstance(stgSysToFcPortInst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return spcOp;
    }

    private static int addTargetportIDtoView(Vector targetPortIDs, CIMObjectPath spcOp) {
        int retVal = 0;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass sapAvailableForElementRefClass = (SimClass)response.getClassMap().get("IBMTSDS_SAPAvailableForElement");
            CIMObjectPath targetPortOp = null;
            Iterator targetPortIdIterator = targetPortIDs.iterator();
            while (targetPortIdIterator.hasNext()) {
                String targetPortID = (String)targetPortIdIterator.next();
                List targetPortInstList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_SCSIProtocolEndpoint");
                Iterator targetPortListIter = targetPortInstList.iterator();
                while (targetPortListIter.hasNext()) {
                    CIMInstance targetPortInst = (CIMInstance)targetPortListIter.next();
                    String tempName = targetPortInst.getProperty("Name").getValue().getValue().toString();
                    if (!tempName.equalsIgnoreCase(targetPortID)) continue;
                    targetPortOp = targetPortInst.getObjectPath();
                    break;
                }
                CIMInstance spcControllerForUnitInst = instanceCreator.createAssociationInstance(sapAvailableForElementRefClass, spcOp, targetPortOp);
                dbManager.createInstance(spcControllerForUnitInst);
                retVal = 0;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private static int addInitiatorIDtoView(Vector initiatorPortID, CIMObjectPath spcOp) {
        int retVal = 0;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass authorisedTargetClass = (SimClass)response.getClassMap().get("IBMTSDS_AuthorizedTarget");
            CIMObjectPath initiatorPortOp = null;
            CIMObjectPath privildgeOp = null;
            Iterator initiatorPortIDIter = initiatorPortID.iterator();
            while (initiatorPortIDIter.hasNext()) {
                String initiatorPort = (String)initiatorPortIDIter.next();
                List storageHardwareIDInstList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageHardwareID");
                Iterator storageHWIdIter = storageHardwareIDInstList.iterator();
                while (storageHWIdIter.hasNext()) {
                    CIMInstance storageHwIdInst = (CIMInstance)storageHWIdIter.next();
                    String tempHardwareID = storageHwIdInst.getProperty("StorageID").getValue().getValue().toString();
                    if (!initiatorPort.equalsIgnoreCase(tempHardwareID)) continue;
                    initiatorPortOp = storageHwIdInst.getObjectPath();
                    List assocPriviledge = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_AuthorizedSubject", initiatorPortOp);
                    Iterator privilegeIter = assocPriviledge.iterator();
                    if (!privilegeIter.hasNext()) break;
                    privildgeOp = ((CIMInstance)privilegeIter.next()).getObjectPath();
                    break;
                }
                CIMInstance authorizedTarget = instanceCreator.createAssociationInstance(authorisedTargetClass, privildgeOp, spcOp);
                dbManager.createInstance(authorizedTarget);
                retVal = 0;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private static int addLUNtoView(Vector lunNames, CIMObjectPath spcOp) {
        int retVal = 1;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            ClassXMLParser parser = new ClassXMLParser();
            ParserRespose response = parser.parse(DS6K_XML_FILE_PATH);
            InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
            SimClass spcForUnitRefClass = (SimClass)response.getClassMap().get("IBMTSDS_ProtocolControllerForUnit");
            CIMObjectPath lunInstOp = null;
            Iterator lunIterator = lunNames.iterator();
            while (lunIterator.hasNext()) {
                String lunName = (String)lunIterator.next();
                List lunInstList = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_Volume");
                Iterator lunListIter = lunInstList.iterator();
                while (lunListIter.hasNext()) {
                    CIMInstance lunInst = (CIMInstance)lunListIter.next();
                    String tempLunName = lunInst.getProperty("Name").getValue().getValue().toString();
                    if (!tempLunName.equalsIgnoreCase(lunName)) continue;
                    lunInstOp = lunInst.getObjectPath();
                    break;
                }
                CIMInstance spcControllerForUnitInst = instanceCreator.createAssociationInstance(spcForUnitRefClass, spcOp, lunInstOp);
                dbManager.createInstance(spcControllerForUnitInst);
                retVal = 0;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static CIMValue HidePaths(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMInstance controllerConfigServiceInst = null;
        Vector lunNames = null;
        Vector initiatorPortID = null;
        Vector targetPortIDs = null;
        CIMObjectPath[] scsiProtocolControllerRef = null;
        CIMValue retValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (HidePaths) Called");
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            controllerConfigServiceInst = dbManager.getInstance(op);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (int propIdx = 0; propIdx < inArgs.length; ++propIdx) {
            CIMArgument argument = inArgs[propIdx];
            String propertyName = argument.getName();
            CIMValue propertyValue = argument.getValue();
            if (propertyName.equalsIgnoreCase("LUNames")) {
                lunNames = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("InitiatorPortIDs")) {
                if (propertyValue == null) continue;
                initiatorPortID = (Vector)propertyValue.getValue();
                continue;
            }
            if (propertyName.equalsIgnoreCase("TargetPortIDs")) {
                if (propertyValue == null) continue;
                targetPortIDs = (Vector)propertyValue.getValue();
                continue;
            }
            if (!propertyName.equalsIgnoreCase("ProtocolControllers") || propertyValue == null) continue;
            scsiProtocolControllerRef = new CIMObjectPath[]{new CIMObjectPath(propertyValue.getValue().toString())};
        }
        CIMObjectPath spcOp = null;
        spcOp = scsiProtocolControllerRef[0];
        if (lunNames != null && initiatorPortID == null && targetPortIDs == null) {
            retValue = DS6K5_2ExtrinsicMethods.removeLUFromView(lunNames, spcOp) == 0 ? new CIMValue((Object)new UnsignedInt16(0)) : new CIMValue((Object)new UnsignedInt16(30000));
        } else if (lunNames == null && initiatorPortID != null && targetPortIDs == null) {
            retValue = DS6K5_2ExtrinsicMethods.removeInitiatorIDFromView(initiatorPortID, spcOp) == 0 ? new CIMValue((Object)new UnsignedInt16(0)) : new CIMValue((Object)new UnsignedInt16(30000));
        } else if (lunNames == null && initiatorPortID == null && targetPortIDs != null) {
            retValue = DS6K5_2ExtrinsicMethods.removeTargetIDFromView(targetPortIDs, spcOp) == 0 ? new CIMValue((Object)new UnsignedInt16(0)) : new CIMValue((Object)new UnsignedInt16(30000));
        } else if (lunNames != null && initiatorPortID != null && targetPortIDs != null) {
            if (DS6K5_2ExtrinsicMethods.removeLUFromView(lunNames, spcOp) == 0 && DS6K5_2ExtrinsicMethods.removeTargetIDFromView(targetPortIDs, spcOp) == 0 && DS6K5_2ExtrinsicMethods.removeInitiatorIDFromView(initiatorPortID, spcOp) == 0) {
                CIMObjectPath concreteRefOp = new CIMObjectPath("IBMTSDS_ConcreteDependencyController", NAMESPACE_ROOT_IBM);
                try {
                    List concreteDepencyRef = dbManager.references(concreteRefOp, spcOp);
                    Iterator concreteDepndencyIter = concreteDepencyRef.iterator();
                    CIMObjectPath spcConcreteDependecyRefToDelete = null;
                    if (concreteDepndencyIter.hasNext()) {
                        CIMInstance assocRef = (CIMInstance)concreteDepndencyIter.next();
                        spcConcreteDependecyRefToDelete = assocRef.getObjectPath();
                    }
                    dbManager.deleteInstance(spcConcreteDependecyRefToDelete);
                    retValue = new CIMValue((Object)new UnsignedInt16(0));
                }
                catch (CIMException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                retValue = new CIMValue((Object)new UnsignedInt16(30000));
            }
        }
        retValue = new CIMValue((Object)new UnsignedInt16(0));
        return retValue;
    }

    private static int removeLUFromView(Vector lunNames, CIMObjectPath spcOp) {
        int retVal = 1;
        CIMObjectPath SPCForUnitRefToDelete = null;
        Iterator lunIterator = lunNames.iterator();
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        CIMObjectPath assocOp = new CIMObjectPath("IBMTSDS_ProtocolControllerForUnit", NAMESPACE_ROOT_IBM);
        while (lunIterator.hasNext()) {
            String requiredLUName = (String)lunIterator.next();
            try {
                List refNames = dbManager.references(assocOp, spcOp);
                Iterator refIter = refNames.iterator();
                while (refIter.hasNext()) {
                    CIMInstance refInst = (CIMInstance)refIter.next();
                    CIMObjectPath dependentOp = (CIMObjectPath)refInst.getProperty("Dependent").getValue().getValue();
                    String lunName = dependentOp.getKey("DeviceID").getValue().getValue().toString();
                    if (!lunName.equals(requiredLUName)) continue;
                    SPCForUnitRefToDelete = refInst.getObjectPath();
                    break;
                }
                dbManager.deleteInstance(SPCForUnitRefToDelete);
                retVal = 0;
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    private static int removeInitiatorIDFromView(Vector initiatorPortID, CIMObjectPath spcOp) {
        int retVal = 0;
        CIMObjectPath authorisedPrivilegeToDelete = null;
        CIMObjectPath authorisedTargetRefToDelete = null;
        CIMObjectPath authorisedsubjectRefToDelete = null;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        Iterator initiatorPortIter = initiatorPortID.iterator();
        CIMObjectPath authorisedTargetAssocOp = new CIMObjectPath("IBMTSDS_AuthorizedTarget", NAMESPACE_ROOT_IBM);
        CIMObjectPath authorisedSubjectAssocOp = new CIMObjectPath("IBMTSDS_AuthorizedSubject", NAMESPACE_ROOT_IBM);
        while (initiatorPortIter.hasNext()) {
            initiatorPortIter.next();
            try {
                List subjectRefInstances;
                Iterator subjectRefIter;
                List privilegeInstList;
                Iterator privilegeInstIter;
                List targetRefInstances = dbManager.references(authorisedTargetAssocOp, spcOp);
                Iterator refIter = targetRefInstances.iterator();
                if (refIter.hasNext()) {
                    CIMInstance authTargetRefInst = (CIMInstance)refIter.next();
                    authorisedTargetRefToDelete = authTargetRefInst.getObjectPath();
                }
                if ((privilegeInstIter = (privilegeInstList = dbManager.associators(NAMESPACE_ROOT_IBM, "IBMTSDS_AuthorizedTarget", spcOp)).iterator()).hasNext()) {
                    CIMInstance privilegeInst = (CIMInstance)privilegeInstIter.next();
                    authorisedPrivilegeToDelete = privilegeInst.getObjectPath();
                }
                if ((subjectRefIter = (subjectRefInstances = dbManager.references(authorisedSubjectAssocOp, authorisedPrivilegeToDelete)).iterator()).hasNext()) {
                    CIMInstance subjectRefInst = (CIMInstance)subjectRefIter.next();
                    authorisedsubjectRefToDelete = subjectRefInst.getObjectPath();
                }
                dbManager.deleteInstance(authorisedTargetRefToDelete);
                dbManager.deleteInstance(authorisedPrivilegeToDelete);
                dbManager.deleteInstance(authorisedsubjectRefToDelete);
                retVal = 0;
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    private static int removeTargetIDFromView(Vector targetPortIDs, CIMObjectPath spcOp) {
        int retVal = 0;
        CIMObjectPath sapAvailableRefToDelete = null;
        Iterator targetPortIter = targetPortIDs.iterator();
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        CIMObjectPath assocOp = new CIMObjectPath("IBMTSDS_SAPAvailableForElement", NAMESPACE_ROOT_IBM);
        while (targetPortIter.hasNext()) {
            String requiredTargePortID = (String)targetPortIter.next();
            try {
                List refInstances = dbManager.references(assocOp, spcOp);
                Iterator refIter = refInstances.iterator();
                while (refIter.hasNext()) {
                    CIMInstance refInst = (CIMInstance)refIter.next();
                    CIMObjectPath availableSAPop = (CIMObjectPath)refInst.getObjectPath().getKey("AvailableSAP").getValue().getValue();
                    String targetPortId = availableSAPop.getKey("Name").getValue().getValue().toString();
                    if (!targetPortId.equals(requiredTargePortID)) continue;
                    sapAvailableRefToDelete = refInst.getObjectPath();
                    break;
                }
                dbManager.deleteInstance(sapAvailableRefToDelete);
                retVal = 0;
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static CIMValue returnToStoragePool(CIMObjectPath op, CIMArgument[] inArgs, CIMArgument[] outArgs) {
        CIMValue retValue = null;
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (returnToStoragePool) Called");
        try {
            CIMObjectPath volToDeleteOp = (CIMObjectPath)inArgs[0].getValue().getValue();
            CIMInstance volToDeleteInst = dbManager.getInstance(volToDeleteOp);
            UnsignedInt64 numOfBlocks = (UnsignedInt64)volToDeleteInst.getProperty("NumberOfBlocks").getValue().getValue();
            UnsignedInt64 size = new UnsignedInt64(numOfBlocks.bigIntValue().multiply(new UnsignedInt64("512").bigIntValue()));
            CIMObjectPath extentPoolOp = null;
            List allocatedFromExtentPoolInstances = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_AllocatedFromExtentPool");
            Iterator iter = allocatedFromExtentPoolInstances.iterator();
            CIMInstance assocInstToDelete = null;
            while (iter.hasNext()) {
                assocInstToDelete = (CIMInstance)iter.next();
                CIMObjectPath dependent = (CIMObjectPath)assocInstToDelete.getProperty("Dependent").getValue().getValue();
                if (!SimulatorUtility.equalsCIMObjectPath(dependent, volToDeleteOp)) continue;
                extentPoolOp = (CIMObjectPath)assocInstToDelete.getProperty("Antecedent").getValue().getValue();
                break;
            }
            if (extentPoolOp != null) {
                CIMInstance extentPoolInstance = dbManager.getInstance(extentPoolOp);
                UnsignedInt64 extentPoolSize = (UnsignedInt64)extentPoolInstance.getProperty("RemainingManagedSpace").getValue().getValue();
                extentPoolSize = new UnsignedInt64(extentPoolSize.bigIntValue().add(size.bigIntValue()));
                extentPoolInstance.setProperty("RemainingManagedSpace", new CIMValue((Object)extentPoolSize));
                dbManager.updateInstance(extentPoolInstance.getObjectPath(), extentPoolInstance);
            }
            if (assocInstToDelete != null) {
                dbManager.deleteInstance(assocInstToDelete.getObjectPath());
            }
            List storageSystemToVolumeInstances = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystemToVolume");
            iter = storageSystemToVolumeInstances.iterator();
            assocInstToDelete = null;
            while (iter.hasNext()) {
                assocInstToDelete = (CIMInstance)iter.next();
                CIMObjectPath dependent = (CIMObjectPath)assocInstToDelete.getProperty("PartComponent").getValue().getValue();
                if (!SimulatorUtility.equalsCIMObjectPath(dependent, volToDeleteOp)) continue;
                extentPoolOp = (CIMObjectPath)assocInstToDelete.getProperty("GroupComponent").getValue().getValue();
                break;
            }
            if (assocInstToDelete != null) {
                dbManager.deleteInstance(assocInstToDelete.getObjectPath());
            }
            List volumeBasedOnRankExtentInstances = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_VolumeBasedOnRankExtent");
            iter = volumeBasedOnRankExtentInstances.iterator();
            assocInstToDelete = null;
            while (iter.hasNext()) {
                assocInstToDelete = (CIMInstance)iter.next();
                CIMObjectPath dependent = (CIMObjectPath)assocInstToDelete.getProperty("Dependent").getValue().getValue();
                if (!SimulatorUtility.equalsCIMObjectPath(dependent, volToDeleteOp)) continue;
                extentPoolOp = (CIMObjectPath)assocInstToDelete.getProperty("Antecedent").getValue().getValue();
                break;
            }
            if (assocInstToDelete != null) {
                dbManager.deleteInstance(assocInstToDelete.getObjectPath());
            }
            List protocolControllerForUnitInstances = dbManager.enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_ProtocolControllerForUnit");
            iter = protocolControllerForUnitInstances.iterator();
            assocInstToDelete = null;
            while (iter.hasNext()) {
                assocInstToDelete = (CIMInstance)iter.next();
                CIMObjectPath dependent = (CIMObjectPath)assocInstToDelete.getProperty("Dependent").getValue().getValue();
                if (!SimulatorUtility.equalsCIMObjectPath(dependent, volToDeleteOp)) continue;
                extentPoolOp = (CIMObjectPath)assocInstToDelete.getProperty("Antecedent").getValue().getValue();
                break;
            }
            if (assocInstToDelete != null) {
                dbManager.deleteInstance(assocInstToDelete.getObjectPath());
            }
            dbManager.deleteInstance(volToDeleteOp);
            retValue = new CIMValue((Object)new UnsignedInt16(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }
}

