/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class RestoreDB {
    public static final String DB2_RESTORE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 restore DB {0} from \"{1}\" without prompting";
    private Logger logger = Logger.getLogger(RestoreDB.class.getName());

    public boolean restore(String dbName, String dbSource) {
        boolean retVal = true;
        if (!this.restoreDatabase(dbName, dbSource)) {
            retVal = false;
        }
        return retVal;
    }

    private boolean restoreDatabase(String dbName, String dbSource) {
        String command = MessageFormat.format(DB2_RESTORE_DB_COMMAND, dbName, dbSource);
        this.logger.info("Restore database command ->" + command);
        int execCommand = this.executeCommand(command);
        return execCommand == 0 || execCommand == 2;
    }

    private int executeCommand(String command) {
        int retVal = -1;
        try {
            String data;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (data = reader.readLine())) {
                this.logger.info("Restore DB Output: " + data);
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (null != (data = reader.readLine())) {
                this.logger.warning("Restore DB Error: " + data);
            }
            reader.close();
            retVal = process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

