/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionDataGenerator;
import org.eclipse.aperi.simulator.ui.CompileMOF;
import org.eclipse.aperi.simulator.ui.ConfigDataGenerator;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.CopyDirectory;
import org.eclipse.aperi.simulator.ui.CreateSetupScreen;
import org.eclipse.aperi.simulator.ui.GenerateMof;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;
import org.eclipse.aperi.simulator.ui.TakeSnapshot;
import org.eclipse.aperi.simulator.ui.dbFactory.DB2Utility;
import org.eclipse.aperi.simulator.ui.dbFactory.DatabaseUtilityFactory;
import org.eclipse.aperi.simulator.ui.dbFactory.DerbyUtility;

public class SetupProcess
extends Thread {
    private CreateSetupScreen setupScreen;
    private static final String START_CIMOM = "simulator_start_cimom.bat";
    private static final String CIMOM_PROPERTIES = "san_simulator_cimom.properties";
    private Logger logger = Logger.getLogger(SetupProcess.class.getName());

    public void run() {
        this.setupScreen = new CreateSetupScreen();
        try {
            if (ConnectionUtility.isSimConnection) {
                this.SetupConnection();
            } else {
                this.SetupSANSimulator();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void SetupConnection() {
        this.setupScreen.jProgressBar.setValue(2);
        this.logger.info("Connection DataGeneration to proceed..");
        ConnectionDataGenerator connectionDataGenerator = new ConnectionDataGenerator();
        try {
            connectionDataGenerator.generateData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setupScreen.jbFinish.setVisible(true);
        this.setupScreen.jbCancel.setVisible(false);
        this.setupScreen.jProgressBar.setValue(10);
        this.logger.info("Connection Data Generation completed Successfully ");
        this.setupScreen.jlInfo.setText("<html><br><b>Setup Completed successfully!Click Finish to exit</b><br><br><html>");
    }

    public void SetupSANSimulator() throws Exception {
        String simulationMode = SetupWizardUtility.getProperty("SIMULATION_MODE");
        ArrayList namespacesToSnapshot = null;
        this.setupScreen.jProgressBar.setValue(0);
        if (SetupWizardUtility.isInstallCIMOM) {
            String fileName = null;
            fileName = SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM");
            SimulatorPropUtility.getInstance().saveProperties(new File(CIMOM_PROPERTIES));
            this.logger.info("WBEM install path ->" + fileName);
            this.logger.info("Setup for SAN Simulator to Proceed");
            File file = new File(fileName);
            if (!file.exists()) {
                new File(fileName).mkdirs();
            }
            try {
                File source = new File(".", "wbemservices");
                File destination = new File(fileName, "wbemservices");
                CopyDirectory.copyDirectory(source, destination);
                source = new File(".", "lib");
                destination = new File(fileName, "lib");
                CopyDirectory.copyDirectory(source, destination);
                source = new File(".", "XML");
                destination = new File(fileName, "XML");
                CopyDirectory.copyDirectory(source, destination);
                this.setupScreen.jProgressBar.setValue(1);
                File destinationDir = new File(fileName, START_CIMOM);
                File startCIMOMFile = new File(".", START_CIMOM);
                CopyDirectory.copyFile(startCIMOMFile, destinationDir);
                destinationDir = new File(fileName, CIMOM_PROPERTIES);
                startCIMOMFile = new File(".", CIMOM_PROPERTIES);
                CopyDirectory.copyFile(startCIMOMFile, destinationDir);
                this.setupScreen.jchbWbemInstall.setEnabled(true);
                this.setupScreen.jchbWbemInstall.doClick();
                this.setupScreen.jchbWbemInstall.setEnabled(false);
            }
            catch (Exception e) {
                this.logger.severe("Error occured in copying WBEM directory " + e);
                e.printStackTrace();
            }
            this.logger.info("CIMOM installation successful");
        }
        this.setupScreen.jProgressBar.setValue(2);
        if (simulationMode.equals("SNAPSHOT_MODE")) {
            String strNamespace = SetupWizardUtility.getProperty("NAMESPACES_TO_SNAPSHOT");
            this.logger.info("Namespaces to snapshot and mof generation = " + strNamespace);
            if (strNamespace != null) {
                namespacesToSnapshot = SetupWizardUtility.pareseNamespace(strNamespace);
            }
            if (SetupWizardUtility.isCreateMof) {
                GenerateMof mofGenerator = new GenerateMof();
                mofGenerator.generate(namespacesToSnapshot);
                this.setupScreen.jchbCreateMof.setEnabled(true);
                this.setupScreen.jchbCreateMof.doClick();
                this.setupScreen.jchbCreateMof.setEnabled(false);
            }
            this.logger.info("MOF generation operation over");
        }
        this.setupScreen.jProgressBar.setValue(4);
        if (SetupWizardUtility.isCompileMof) {
            int compilationDone = new CompileMOF().compile();
            this.logger.info("MOF Compilation is successful!");
            if (compilationDone == 1) {
                this.setupScreen.jProgressBar.setValue(4);
                this.setupScreen.jchbMofCompile.setEnabled(true);
                this.setupScreen.jchbMofCompile.doClick();
                this.setupScreen.jchbMofCompile.setEnabled(false);
                JOptionPane.showMessageDialog(null, "Please close start_cimom.bat command window to resume installation", "Information", 1);
            } else {
                this.logger.severe("Error encountered in MOF Compilation!");
                JOptionPane.showMessageDialog(null, "Error occurred while compiling MOFs !", "Error", 0);
            }
        }
        this.setupScreen.jProgressBar.setValue(6);
        if (SetupWizardUtility.isSimulateDevice) {
            DatabaseUtilityFactory dbUtility = SimulatorPropUtility.getInstance().getDbType().equalsIgnoreCase("DB2") ? new DB2Utility() : new DerbyUtility();
            int result = dbUtility.testConnection() == 0 ? dbUtility.createDB() : 1;
            if (result == 1) {
                this.setupScreen.jProgressBar.setValue(7);
                this.logger.info("Database creation and configuration went successful!");
                if (simulationMode.equals("SNAPSHOT_MODE")) {
                    this.logger.info("Snapshot-Based Simulation to Proceed");
                    TakeSnapshot snapshotter = new TakeSnapshot(namespacesToSnapshot);
                    snapshotter.ConfigureDBForSnapshot();
                    snapshotter.startSnapshot();
                } else if (simulationMode.equals("CONFIGURATION_MODE")) {
                    String configFilePath = SetupWizardUtility.getProperty("CONFIG_FILE_PATH");
                    this.logger.info("Configuration-Based Simulation to proceed");
                    ConfigDataGenerator config = new ConfigDataGenerator();
                    String deviceType = SetupWizardUtility.getProperty("DEVICE_TYPE");
                    config.ConfigureDBForConfiguration();
                    config.generator(configFilePath, deviceType);
                }
            } else if (result == 0) {
                this.logger.severe("Error occur in database configuration !");
                JOptionPane.showMessageDialog(null, "Error occured during setup !", "Error", 0);
                System.exit(0);
            }
            this.setupScreen.jchbDBCreated.setEnabled(true);
            this.setupScreen.jchbDBCreated.doClick();
            this.setupScreen.jchbDBCreated.setEnabled(false);
        }
        this.logger.info("Data generation operation is over");
        this.setupScreen.jbFinish.setVisible(true);
        this.setupScreen.jbCancel.setVisible(false);
        this.setupScreen.jProgressBar.setValue(10);
        this.setupScreen.jlInfo.setText("<html><br><b>Setup Completed successfully!  Click Finish to exit</b><br><br><html>");
    }
}

