/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SimulatorPropUtility {
    private String dbName;
    private String derbyServerPort = "1527";
    private String cimomPort = "5988";
    private String dbUsername;
    private String dbPassword;
    private String dbType;
    private String dbLocation;
    private static SimulatorPropUtility instance;

    private SimulatorPropUtility() {
    }

    public static SimulatorPropUtility getInstance() {
        if (instance == null) {
            instance = new SimulatorPropUtility();
        }
        return instance;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getCimomPort() {
        return this.cimomPort;
    }

    public void setCimomPort(String cimomPort) {
        this.cimomPort = cimomPort;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbLocation() {
        return this.dbLocation;
    }

    public void setDbLocation(String dbLocation) {
        this.dbLocation = dbLocation;
    }

    public void saveProperties(File propFile) {
        Properties properties = new Properties();
        properties.setProperty("HTTP_PORT", this.getCimomPort());
        properties.setProperty("DATABASE", this.getDbType());
        properties.setProperty("DB_LOCATION", this.getDbLocation());
        properties.setProperty("DB_NAME", this.getDbName());
        properties.setProperty("DB_USERNAME", this.getDbUsername());
        properties.setProperty("DB_PASSWORD", this.getDbPassword());
        properties.setProperty("DERBY_SERVER_PORT", this.getDerbyServerPort());
        try {
            FileOutputStream fileOut = new FileOutputStream(propFile);
            properties.store(fileOut, "Simulator Properties file");
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDerbyServerPort() {
        return this.derbyServerPort;
    }

    public void setDerbyServerPort(String derbyServerPort) {
        this.derbyServerPort = derbyServerPort;
    }
}

