/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class TestWbemCimomConnection {
    private static Logger logger = Logger.getLogger(TestWbemCimomConnection.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int testConnection(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) throws CIMException {
        int tag = 0;
        logger.info("WBEM CIMOM to Test ->URL " + HostUrl + "port " + Port + "userid " + UserName + "password " + PassWord + "Namespace " + NameSpace + "Protocol " + Protocol);
        CIMClient cimClient = null;
        try {
            cimClient = TestWbemCimomConnection.getConnection(HostUrl, Port, UserName, PassWord, NameSpace, Protocol);
            CIMObjectPath path = new CIMObjectPath();
            cimClient.enumerateClasses(path, true, false, false, true);
            tag = 1;
        }
        finally {
            if (cimClient != null) {
                cimClient.close();
            }
            cimClient = null;
        }
        return tag;
    }

    protected static CIMClient getConnection(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) {
        CIMClient cimClient = null;
        UserPrincipal principal = null;
        PasswordCredential credential = null;
        try {
            if (HostUrl != null && NameSpace != null) {
                try {
                    CIMNameSpace cimNamespace = new CIMNameSpace(Protocol + "://" + HostUrl + ":" + Port, NameSpace);
                    if (UserName != null) {
                        principal = new UserPrincipal(UserName);
                    }
                    if (PassWord != null) {
                        credential = new PasswordCredential(PassWord);
                    }
                    cimClient = new CIMClient(cimNamespace, (Principal)principal, (Object)credential);
                }
                catch (Exception e) {
                    logger.severe("Unable To Connect to CIMOM [" + HostUrl + "]" + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Given CIMOM URL AND/OR Namespace is NULL", "TestCIMOM COnnection", 2);
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
        return cimClient;
    }

    protected static List getNamespaces(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) {
        ArrayList<String> namesapces = new ArrayList<String>();
        CIMClient cimClient = TestWbemCimomConnection.getConnection(HostUrl, Port, UserName, PassWord, NameSpace, Protocol);
        CIMObjectPath cimOP = new CIMObjectPath("CIM_Namespace");
        try {
            Enumeration enumNamespace = cimClient.enumerateInstances(cimOP, true, false, true);
            while (enumNamespace.hasMoreElements()) {
                CIMInstance instNamespace = (CIMInstance)enumNamespace.nextElement();
                String strNamespace = instNamespace.getProperty("Name").getValue().getValue().toString();
                if (namesapces.contains(strNamespace)) continue;
                namesapces.add(strNamespace);
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        return namesapces;
    }
}

