/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui.dbFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;
import org.eclipse.aperi.simulator.ui.dbFactory.DatabaseUtilityFactory;

public class DB2Utility
implements DatabaseUtilityFactory {
    private static final String DB_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public static final String DB2_DROP_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 drop database ";
    private static final String CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create DB {0}";
    private static final String RUN_DDL_COMMAND_WITH_CREDENTIAL = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2batch.exe -d {0} -a {1}/{2} -f {3}";
    private static Logger logger = Logger.getLogger(DB2Utility.class.getName());
    private String hostUrl;
    private String dbName;
    private String dbPort;
    private String username;
    private String password;

    public Connection createConnection() {
        return null;
    }

    public int createDB() {
        int retVal = 0;
        if (this.username.equals("Default") || this.password.equals("Default")) {
            this.username = JOptionPane.showInputDialog("Enter DB Username: ", (Object)"db2admin");
            this.password = JOptionPane.showInputDialog("Enter DB Password: ", (Object)"db2admin");
            if (this.username == null || this.password == null) {
                JOptionPane.showMessageDialog(null, "Database could not be created! So SetupWizard will abort", "DB Error", 0);
                System.exit(0);
            }
        }
        String command = MessageFormat.format(RUN_DDL_COMMAND_WITH_CREDENTIAL, this.dbName, this.username, this.password, DDL_FILE_PATH);
        try {
            if (this.runDBCreate(this.dbName) != 0) {
                logger.severe("Database Creation Falied! ");
                JOptionPane.showMessageDialog(null, "Database creation failed! Please check the log file!", "Failed", 0);
                System.exit(0);
            }
            if (this.ConfigDB(command) != 0) {
                logger.severe("Error occured during Configuring database!");
                this.dropDatabase(this.dbName);
                JOptionPane.showMessageDialog(null, "Database creation failed! Please check the log file!", "Failed", 0);
                System.exit(0);
            } else {
                retVal = 1;
                logger.info("Database created successfully: " + retVal);
            }
        }
        catch (Exception e) {
            retVal = 0;
            e.printStackTrace();
            logger.severe(e.getMessage() + e);
            logger.info("Database creation Failed: " + retVal);
        }
        return retVal;
    }

    private int ConfigDB(String command) {
        logger.info("DB Config Command: " + command);
        return this.executeCommand(command);
    }

    private int runDBCreate(String dbName) throws Exception {
        String createCommand = MessageFormat.format(CREATE_DB_COMMAND, dbName);
        logger.info("Create database command to execute: " + createCommand);
        return this.executeCommand(createCommand);
    }

    public int dropDB() {
        return 0;
    }

    public void init() {
        this.username = SimulatorPropUtility.getInstance().getDbUsername();
        this.password = SimulatorPropUtility.getInstance().getDbPassword();
        this.dbName = SimulatorPropUtility.getInstance().getDbName();
        this.hostUrl = SimulatorPropUtility.getInstance().getDbLocation();
    }

    public int restoreDB() {
        return 0;
    }

    public int testConnection() {
        this.init();
        boolean flag = this.testConnection(this.hostUrl, this.dbName, this.username, this.password, null);
        if (flag) {
            return 1;
        }
        return 0;
    }

    public void closeConnection() {
    }

    public int executeCommand(String command) {
        int retVal = -1;
        try {
            Process process = Runtime.getRuntime().exec(command);
            new NullReader(process.getInputStream(), "Output").start();
            new NullReader(process.getErrorStream(), "Error").start();
            retVal = process.waitFor();
            logger.info("The return value is : " + retVal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public int dropDatabase(String dbName) {
        return this.executeCommand(DB2_DROP_DB_COMMAND + dbName);
    }

    public boolean testConnection(String dbHostIp, String dbName, String dbUsername, String dbPassword, String dbPort) {
        boolean flag = false;
        try {
            Connection con;
            Class.forName(DB_DRIVER);
            if (dbUsername.equals("Deafult") || dbPassword.equals("Default")) {
                String dbUrl = "jdbc:db2:" + dbName;
                con = DriverManager.getConnection(dbUrl);
            } else {
                String dbUrl = "jdbc:db2://" + dbHostIp + ":50000/" + dbName;
                con = DriverManager.getConnection(dbUrl, dbUsername, dbPassword);
            }
            con.close();
            logger.info("Database connection Successfull");
            flag = true;
        }
        catch (Exception e) {
            logger.info(e.getMessage() + e);
        }
        if (!flag) {
            logger.severe("Database Connection fails");
        }
        return flag;
    }

    private class NullReader
    extends Thread {
        private InputStream stream;
        private String name;

        public NullReader(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = null;
            try {
                String data;
                reader = new BufferedReader(new InputStreamReader(this.stream));
                while (null != (data = reader.readLine())) {
                    logger.info(this.name + " " + data);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

