/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui.dbFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;
import org.eclipse.aperi.simulator.ui.dbFactory.DatabaseUtilityFactory;

public class DerbyUtility
implements DatabaseUtilityFactory {
    private static Logger logger = Logger.getLogger(DerbyUtility.class.getName());
    private static final String DDL_COMMAND = "java -Dij.database={0}; -Djava.ext.dirs={1}/lib -jar {2}\\lib\\derbyrun.jar ij " + DDL_FILE_PATH;
    private static final String CREATE_DB_COMMAND = "jdbc:derby://{0}:{1}/{2};create=true;user={3};password={4}";
    private String hostUrl;
    private String dbName;
    private String dbPort;
    private String username;
    private String password;

    public Connection createConnection() {
        return null;
    }

    public int createDB() {
        int retVal = 1;
        String connectionUrl = MessageFormat.format(CREATE_DB_COMMAND, this.hostUrl, this.dbPort, this.dbName, this.username, this.password);
        String derbyHome = System.getenv("DERBY_HOME");
        String command = MessageFormat.format(DDL_COMMAND, connectionUrl, derbyHome, derbyHome);
        logger.info("Derby Create Command: " + command);
        this.executeCommand(command);
        return retVal;
    }

    public int dropDB() {
        return 0;
    }

    public void init() {
        this.hostUrl = SimulatorPropUtility.getInstance().getDbLocation();
        this.dbName = SimulatorPropUtility.getInstance().getDbName();
        this.dbPort = SimulatorPropUtility.getInstance().getDerbyServerPort();
        this.username = SimulatorPropUtility.getInstance().getDbUsername();
        this.password = SimulatorPropUtility.getInstance().getDbPassword();
    }

    public int restoreDB() {
        return 0;
    }

    public int testConnection() {
        this.init();
        boolean flag = this.testConnection(this.hostUrl, this.dbName, this.username, this.password, this.dbPort);
        if (flag) {
            return 1;
        }
        return 0;
    }

    public void closeConnection() {
    }

    public int executeCommand(String command) {
        int retVal = -1;
        try {
            Process process = Runtime.getRuntime().exec(command);
            new NullReader(process.getInputStream(), "Output").start();
            new NullReader(process.getErrorStream(), "Error").start();
            retVal = process.waitFor();
            logger.info("The return value is : " + retVal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public int dropDatabase(String dbName) {
        return 0;
    }

    public boolean testConnection(String dbHostIp, String dbName, String dbUsername, String dbPassword, String dbPort) {
        String connectUrl = MessageFormat.format("jdbc:derby://{0}:{1}/{2};create=false;user={3};password={4}", dbHostIp, dbPort, dbName, dbUsername, dbPassword);
        logger.info("Derby Connection URL: " + connectUrl);
        logger.info("Testing the connection to Database");
        boolean retVal = true;
        try {
            Connection conn = null;
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            logger.info("Loaded the appropriate driver.");
            conn = DriverManager.getConnection(connectUrl);
            logger.info("Connected to and created database SIMDB");
            conn.setAutoCommit(true);
            conn.close();
        }
        catch (Throwable e) {
            logger.severe("exception thrown:" + e);
            retVal = false;
        }
        return retVal;
    }

    private class NullReader
    extends Thread {
        private InputStream stream;
        private String name;

        public NullReader(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = null;
            try {
                String data;
                reader = new BufferedReader(new InputStreamReader(this.stream));
                while (null != (data = reader.readLine())) {
                    logger.info(this.name + " " + data);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

