/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim;

import java.security.Principal;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMObjectPath;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMConverter;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseSnapshotMaker;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class SnapshotMaker
extends BaseSnapshotMaker {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;

    public SnapshotMaker(CIMOM cimomDetails) throws SimulatorException {
        super(cimomDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Start Snapshot");
        try {
            String url = this.cimom.getServiceURL();
            String user = this.cimom.getUserID();
            String password = this.cimom.getPassword();
            String namespace = this.cimom.getNamespace();
            if (url != null && namespace != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(url, namespace);
                    if (user != null) {
                        this.principal = new UserPrincipal(user);
                    }
                    if (password != null) {
                        this.credential = new PasswordCredential(password.toCharArray());
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                }
                catch (Exception e) {
                    System.out.println("Unable To Connect to CIMOM [" + url + "]" + e.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            namespace = SimulatorUtility.fixNamespaceSlashIssue(namespace);
            this.insert_CIMOM_INFO(this.cimom.getCimomVendorType(), this.cimom.getCimomVendor(), url, namespace, user, password);
            int cimomInfoMaxCnt = this.getMaxID("SIM.CIMOM_INFO");
            ArrayList namespaces = new ArrayList();
            namespaces.add(namespace);
            namespaces = DiscoveryUtil.getNamespaces(this.cimClient, namespaces, this.cimom.getCimomType());
            for (int idx = 0; idx < namespaces.size(); ++idx) {
                String aNamespace = (String)namespaces.get(idx);
                aNamespace = SimulatorUtility.fixNamespaceSlashIssue(aNamespace);
                this.insert_NS_INFO(cimomInfoMaxCnt, aNamespace);
                int nsInfoMaxCnt = this.getMaxID("SIM.NS_INFO");
                this.snapshotClasses(aNamespace, nsInfoMaxCnt);
            }
            if (this.cimClient != null) {
                this.cimClient.close();
            }
            this.cimClient = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cimClient = null;
            this.con = null;
        }
    }

    private synchronized void insert_CIM_DATA(int cimClassCnt, CIMInstance instance) throws Exception {
        javax.wbem.cim.CIMInstance sunWBEMCIMInstance = CIMConverter.convertInstanceWBEMStyle(instance);
        org.sblim.wbem.cim.CIMObjectPath ibmCIMOP = instance.getObjectPath();
        CIMObjectPath sunWBEMCIMOP = CIMConverter.convertCIMOPWBEMStyle(ibmCIMOP);
        sunWBEMCIMOP.setHost(ibmCIMOP.getHost());
        sunWBEMCIMOP.setNameSpace(ibmCIMOP.getNameSpace());
        CIMDataBLOB instanceBlob = new CIMDataBLOB(sunWBEMCIMInstance);
        int instanceBlobLength = (int)instanceBlob.length();
        CIMDataBLOB opBlob = new CIMDataBLOB(sunWBEMCIMOP);
        int opBlobLength = (int)opBlob.length();
        String CIM_DATA_INSERT = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
        PreparedStatement ps_cim_data_insert = this.con.prepareStatement(CIM_DATA_INSERT);
        ps_cim_data_insert.setInt(1, cimClassCnt);
        ps_cim_data_insert.setBinaryStream(2, opBlob.getBinaryStream(), opBlobLength);
        ps_cim_data_insert.setBinaryStream(3, instanceBlob.getBinaryStream(), instanceBlobLength);
        ps_cim_data_insert.executeUpdate();
        this.con.commit();
        ps_cim_data_insert.close();
    }

    protected synchronized void snapshotClasses(String namespace, int nsInfoCnt) throws Exception {
        this.cimClient = null;
        this.cimNamespace = null;
        this.cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), namespace);
        this.cimClient = new CIMClient(this.cimNamespace, (Principal)new UserPrincipal(this.cimom.getUserID()), (Object)new PasswordCredential(this.cimom.getPassword().toCharArray()));
        org.sblim.wbem.cim.CIMObjectPath path = new org.sblim.wbem.cim.CIMObjectPath();
        Enumeration en = this.cimClient.enumerateClasses(path, true, false, false, true);
        ArrayList<String> classList = new ArrayList<String>();
        while (en.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)en.nextElement();
            classList.add(cimCls.getName());
        }
        en = null;
        for (int idx = 0; idx < classList.size(); ++idx) {
            String classNameToGetData = (String)classList.get(idx);
            ArrayList classNamePrefixes = this.cimom.getLeafClassNamePrefixes();
            boolean classSnapshaotable = false;
            for (int idx2 = 0; idx2 < classNamePrefixes.size(); ++idx2) {
                String leafClasNamePrefix = (String)classNamePrefixes.get(idx2);
                if (!classNameToGetData.startsWith(leafClasNamePrefix)) continue;
                classSnapshaotable = true;
                break;
            }
            if (!classSnapshaotable) continue;
            try {
                this.insert_CIM_CLASS(nsInfoCnt, (String)classList.get(idx));
                int cimClassMaxCnt = this.getMaxID("SIM.CIM_CLASS");
                org.sblim.wbem.cim.CIMObjectPath cimOP = new org.sblim.wbem.cim.CIMObjectPath((String)classList.get(idx));
                Enumeration enumeration = this.cimClient.enumerateInstances(cimOP, true, false, false, true, null);
                while (enumeration.hasMoreElements()) {
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    this.insert_CIM_DATA(cimClassMaxCnt, instance);
                    System.out.println("NS = [" + namespace + "], CLS = [" + (String)classList.get(idx) + "]");
                }
                enumeration = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cimClient.close();
        this.cimClient = null;
    }
}

