/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.eclipse.aperi.simulator.ui.ButtonsPanel;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class CreateSetupScreen
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Container container = this.getContentPane();
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel jpMain = new JPanel(new BorderLayout());
    private JPanel jpBottom = new JPanel(new BorderLayout());
    private JPanel inputPanel;
    private JPanel buttonContainer;
    protected JProgressBar jProgressBar;
    protected JButton jbFinish;
    protected JButton jbCancel;
    protected JCheckBox jchbWbemInstall;
    protected JCheckBox jchbCreateMof;
    protected JCheckBox jchbDBCreated;
    protected JCheckBox jchbMofCompile;
    protected JLabel jlInfo;

    public CreateSetupScreen() {
        super("SAN Simulator Setup Wizard");
        this.showPanel();
    }

    public void showPanel() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        ButtonsPanel b = new ButtonsPanel();
        this.jbCancel = b.getCancelButton();
        this.jbFinish = b.getFinishButton();
        this.buttonContainer = new JPanel(new FlowLayout(2, 10, 5));
        this.buttonContainer.setBorder(BorderFactory.createEtchedBorder());
        this.jbCancel.setVisible(true);
        this.buttonContainer.add(this.jbCancel);
        this.jbFinish.setVisible(false);
        this.buttonContainer.add(this.jbFinish);
        this.inputPanel = ConnectionUtility.isSimConnection ? this.getConnectionSetupScreen() : this.getDeviceScreen();
        this.jpMain.add((Component)this.inputPanel, "Center");
        this.jpBottom.add((Component)this.buttonContainer, "South");
        ButtonHandler handler = new ButtonHandler();
        this.jbFinish.addActionListener(handler);
        this.jbCancel.addActionListener(handler);
        ImageIcon iIcon = new ImageIcon("resources\\logo2_mm.gif");
        JLabel lSanLogo = new JLabel("", iIcon, 2);
        this.addComponent(lSanLogo, 0, 0, 1, 5);
        this.constraints.weightx = 1000.0;
        this.constraints.fill = 2;
        this.jpMain.setBorder(BorderFactory.createEtchedBorder());
        this.addComponent(this.jpMain, 0, 1, 1, 1);
        this.constraints.fill = 1;
        this.addComponent(this.jpBottom, 4, 1, 1, 1);
        this.setSize(600, 450);
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    private JPanel getConnectionSetupScreen() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html>&nbsp <b>SAN Simulator Setup </b><br><br><br><br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jlTitle, "North");
        JPanel jpInstall = new JPanel(new BorderLayout());
        jpInstall.setLayout(new BoxLayout(jpInstall, 1));
        JPanel jpLabel = new JPanel(new FlowLayout(0, 5, 0));
        this.jlInfo = new JLabel("<html><br><b>Please wait..This process may take some time</b><br><br><html>");
        jpLabel.add(this.jlInfo);
        jpInstall.add(jpLabel);
        this.jProgressBar = new JProgressBar(0, 10);
        this.jProgressBar.setSize(100, 10);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(true);
        jpInstall.add((Component)this.jProgressBar, "South");
        JPanel jpWrap = new JPanel();
        jpWrap.setBorder(BorderFactory.createEtchedBorder());
        jpWrap.add(jpInstall);
        jpMain.add((Component)jpWrap, "Center");
        return jpMain;
    }

    private JPanel getDeviceScreen() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html>&nbsp <b>SAN Simulator Setup </b><br><br><br><br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jlTitle, "North");
        JPanel jpInstall = new JPanel(new BorderLayout());
        jpInstall.setLayout(new BoxLayout(jpInstall, 1));
        JPanel jpLabel = new JPanel(new FlowLayout(0, 5, 0));
        this.jlInfo = new JLabel("<html><br><b>Please wait..This process may take some time</b><br><br><html>");
        jpLabel.add(this.jlInfo);
        jpInstall.add(jpLabel);
        this.jProgressBar = new JProgressBar(0, 10);
        this.jProgressBar.setSize(100, 10);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(true);
        jpInstall.add((Component)this.jProgressBar, "South");
        JPanel jpMidLabel1 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbWbemInstall = new JCheckBox();
        this.jchbWbemInstall.setEnabled(false);
        JLabel lWbem = new JLabel("<html>Create new CIMOM instance</html>", 2);
        lWbem.setFont(new Font("Times New RomanSerif", 0, 12));
        jpMidLabel1.add(this.jchbWbemInstall);
        jpMidLabel1.add(lWbem);
        JPanel jpMidLabel5 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbCreateMof = new JCheckBox();
        this.jchbCreateMof.setEnabled(false);
        JLabel lCreateMof = new JLabel("<html>Create new MOF files </html>", 2);
        lCreateMof.setFont(new Font("Times New RomanSerif", 0, 12));
        jpMidLabel5.add(this.jchbCreateMof);
        jpMidLabel5.add(lCreateMof);
        JPanel jpMidLabel2 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbDBCreated = new JCheckBox();
        this.jchbDBCreated.setEnabled(false);
        JLabel ldbcopy = new JLabel("<html>Populate database with simulated data</html>", 2);
        ldbcopy.setFont(new Font("Times New RomanSerif", 0, 12));
        jpMidLabel2.add(this.jchbDBCreated);
        jpMidLabel2.add(ldbcopy);
        JPanel jpMidLabel3 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbMofCompile = new JCheckBox();
        this.jchbMofCompile.setEnabled(false);
        JLabel lmof = new JLabel("<html>Start CIMOM and compile device MOF files</html>", 2);
        lmof.setFont(new Font("Times New RomanSerif", 0, 12));
        jpMidLabel3.add(this.jchbMofCompile);
        jpMidLabel3.add(lmof);
        jpInstall.add(jpMidLabel1);
        jpInstall.add(jpMidLabel5);
        jpInstall.add(jpMidLabel3);
        jpInstall.add(jpMidLabel2);
        JPanel jpWrap = new JPanel();
        jpWrap.setBorder(BorderFactory.createEtchedBorder());
        jpWrap.add(jpInstall);
        jpMain.add((Component)jpWrap, "Center");
        return jpMain;
    }

    private void addComponent(Component component, int row, int column, int width, int height) {
        this.constraints.gridx = column;
        this.constraints.gridy = row;
        this.constraints.gridwidth = width;
        this.constraints.gridheight = height;
        this.layout.setConstraints(component, this.constraints);
        this.container.add(component);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand() == "Cancel") {
                int result = JOptionPane.showConfirmDialog(null, "If you Cancel the setup now, SAN Simulator will not be installed. Are you sure you want to exit?", "Cancel", 1);
                if (result == 0) {
                    JOptionPane.showMessageDialog(null, "Please close all Open Command Window before you exit", "Cancel", 1);
                    CreateSetupScreen.this.dispose();
                    System.exit(0);
                } else if (result == 1 || result == 2) {
                    // empty if block
                }
            }
            if (event.getActionCommand() == "Finish") {
                if (!ConnectionUtility.isSimConnection && SetupWizardUtility.isCompileMof) {
                    JOptionPane.showMessageDialog(null, "Start the CIMOM from " + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\simulator_start_cimom.bat for device discovery.", "Start Cimom", 1);
                }
                System.exit(0);
            }
        }
    }
}

