/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.validators.IValidatorProvider;

public abstract class ActivityRecord
implements IActivityRecord,
IValidatorProvider {
    public static final int INITIAL_STATE = 0;
    public static final int DONE_STATE = 1;
    public static final int UNDONE_STATE = 2;
    public static final int REDONE_STATE = 3;
    public static final int DISCARD_STATE = 4;
    protected int state = 0;
    protected Object sender = null;
    protected String label;
    private int transNo = 0;
    protected boolean isPersistent = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void destroy() {
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String text) {
        this.label = text;
    }

    public abstract void execute();

    public abstract void undo();

    public abstract void redo();

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        if (!($assertionsDisabled || this.state == 0 && newState == 1 || this.state == 1 && newState == 2 || this.state == 2 && newState == 3 || this.state == 3 && newState == 2 || newState == 4)) {
            throw new AssertionError();
        }
        this.state = newState;
    }

    public Object getSender() {
        return this.sender;
    }

    public void setSender(Object obj) {
        this.sender = obj;
    }

    public void setTransNo(int n) {
        this.transNo = n;
    }

    public int getTransNo() {
        return this.transNo;
    }

    public List getValidators() {
        return Collections.EMPTY_LIST;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public abstract void rollback();

    protected List getPostTasks() {
        return Collections.EMPTY_LIST;
    }

    protected void performPostTasks(Stack transStack) {
        List tasks = this.getPostTasks();
        for (int i = 0; i < tasks.size(); ++i) {
            RecordTask subTask = (RecordTask)tasks.get(i);
            subTask.doTask(this, transStack);
        }
    }

    static {
        $assertionsDisabled = !ActivityRecord.class.desiredAssertionStatus();
    }
}

