/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public class ReportDesignHandle
extends ModuleHandle
implements IReportDesignModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportDesignHandle(ReportDesign design) {
        super(design);
    }

    public String getAfterFactory() {
        return this.getStringProperty("afterFactory");
    }

    public String getAfterRender() {
        return this.getStringProperty("afterRender");
    }

    public String getBase() {
        return this.module.getStringProperty(this.module, "base");
    }

    public String getBeforeFactory() {
        return this.getStringProperty("beforeFactory");
    }

    public String getBeforeRender() {
        return this.getStringProperty("beforeRender");
    }

    public SlotHandle getBody() {
        return this.getSlot(6);
    }

    public int getRefreshRate() {
        return this.getIntProperty("refreshRate");
    }

    public SlotHandle getScratchPad() {
        return this.getSlot(7);
    }

    public Iterator includeScriptsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("includeScripts");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public void setAfterFactory(String value) {
        block2: {
            try {
                this.setStringProperty("afterFactory", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setAfterRender(String value) {
        block2: {
            try {
                this.setStringProperty("afterRender", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBase(String base) {
        block2: {
            try {
                this.setProperty("base", base);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeFactory(String value) {
        block2: {
            try {
                this.setStringProperty("beforeFactory", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeRender(String value) {
        block2: {
            try {
                this.setStringProperty("beforeRender", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setRefreshRate(int rate) {
        block2: {
            try {
                this.setIntProperty("refreshRate", rate);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans();
        for (int i = 0; i < selectedStyles.size(); ++i) {
            SharedStyleHandle style = (SharedStyleHandle)selectedStyles.get(i);
            if (stylesheet.findStyle(style.getName()) == null) continue;
            try {
                this.module.makeUniqueName(style.getElement());
                this.addElement(style, 0);
                continue;
            }
            catch (ContentException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            catch (NameException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
        }
        stack.commit();
    }

    public void setDisplayNameKey(String displayNameKey) throws SemanticException {
        this.setStringProperty("displayNameID", displayNameKey);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty("displayNameID");
    }

    public void setDisplayName(String displayName) throws SemanticException {
        this.setStringProperty("displayName", displayName);
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public void setIconFile(String iconFile) throws SemanticException {
        this.setStringProperty("iconFile", iconFile);
    }

    public String getIconFile() {
        return this.getStringProperty("iconFile");
    }

    public void setCheatSheet(String cheatSheet) throws SemanticException {
        this.setStringProperty("cheatSheet", cheatSheet);
    }

    public String getCheatSheet() {
        return this.getStringProperty("cheatSheet");
    }

    public void setThumbnail(byte[] data) throws SemanticException {
        block2: {
            try {
                this.setStringProperty("thumbnail", new String(data, "8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public byte[] getThumbnail() {
        return ((ReportDesign)this.module).getThumbnail();
    }

    public void deleteThumbnail() throws SemanticException {
        this.clearProperty("thumbnail");
    }

    public List getAllBookmarks() {
        return ((ReportDesign)this.module).collectPropValues(6, "bookmark");
    }

    public List getAllTocs() {
        return ((ReportDesign)this.module).collectPropValues(6, "toc");
    }

    public List getReportItemsBasedonTempalates() {
        ArrayList<DesignElementHandle> rtnList = new ArrayList<DesignElementHandle>();
        ArrayList tempList = new ArrayList();
        List contents = this.getElement().getSlot(6).getContents();
        contents.addAll(this.getElement().getSlot(4).getContents());
        this.findTemplateItemIn(contents.iterator(), tempList);
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            rtnList.add(((DesignElement)iter.next()).getHandle(this.module));
        }
        return Collections.unmodifiableList(rtnList);
    }

    private void findTemplateItemIn(Iterator contents, List addTo) {
        while (contents.hasNext()) {
            DesignElement e = (DesignElement)contents.next();
            if (e.isTemplateParameterValue(this.module)) {
                addTo.add(e);
                continue;
            }
            LevelContentIterator children = new LevelContentIterator(e, 1);
            this.findTemplateItemIn(children, addTo);
        }
    }

    static {
        $assertionsDisabled = !ReportDesignHandle.class.desiredAssertionStatus();
    }
}

