/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataHandler;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.xml.sax.helpers.DefaultHandler;

public final class MetaDataReader {
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void read(String fileName) throws MetaDataParserException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage());
            MetaLogManager.log("Metadata definition file not found", e);
            throw new MetaDataParserException(fileName, "FILE_NOT_FOUND");
        }
        try {
            MetaDataReader.read(inputStream);
        }
        catch (MetaDataParserException e) {
            e.setFileName(fileName);
            throw e;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {}
        }
    }

    public static void read(InputStream inputStream) throws MetaDataParserException {
        InputStream internalStream = inputStream;
        if (inputStream != null && !inputStream.markSupported()) {
            internalStream = new BufferedInputStream(inputStream);
            if (!$assertionsDisabled && !internalStream.markSupported()) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && !MetaDataDictionary.getInstance().isEmpty()) {
            throw new AssertionError();
        }
        MetaDataHandler handler = new MetaDataHandler();
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(internalStream, (DefaultHandler)handler);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
            MetaLogManager.log("Metadata parsing error", e);
            throw new MetaDataParserException(e, "PARSER_ERROR");
        }
    }

    static {
        $assertionsDisabled = !MetaDataReader.class.desiredAssertionStatus();
        logger = Logger.getLogger(MetaDataReader.class.getName());
    }
}

