/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;

public class ValidationNode {
    protected DesignElement element;
    protected SemanticTriggerDefn triggerDefn = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    ValidationNode(DesignElement element, SemanticTriggerDefn triggerDefn) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && triggerDefn == null) {
            throw new AssertionError();
        }
        this.element = element;
        this.triggerDefn = triggerDefn;
    }

    DesignElement getElement() {
        return this.element;
    }

    final List perform(Module module, boolean sendEvent) {
        DesignElement toValidate;
        AbstractSemanticValidator validator = this.triggerDefn.getValidator();
        if (module instanceof ReportDesign && !validator.canApplyToDesign() || module instanceof Library && !validator.canApplyToLibrary()) {
            return Collections.EMPTY_LIST;
        }
        String elementName = this.triggerDefn.getTargetElement();
        if (!StringUtil.isBlank(elementName)) {
            ElementDefn elementDefn;
            ElementDefn targetDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementName);
            for (toValidate = this.element; toValidate != null && !(elementDefn = (ElementDefn)toValidate.getDefn()).isKindOf(targetDefn); toValidate = toValidate.getContainer()) {
            }
        }
        if (toValidate == null) {
            return Collections.EMPTY_LIST;
        }
        List errors = null;
        if (validator instanceof AbstractPropertyValidator) {
            errors = ((AbstractPropertyValidator)validator).validate(module, toValidate, this.triggerDefn.getPropertyName());
        } else if (validator instanceof AbstractElementValidator) {
            errors = ((AbstractElementValidator)validator).validate(module, toValidate);
        }
        if (!$assertionsDisabled && errors == null) {
            throw new AssertionError();
        }
        if (!sendEvent) {
            return errors;
        }
        ArrayList<ErrorDetail> errorDetailList = new ArrayList<ErrorDetail>();
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            SemanticException e = (SemanticException)((Object)iter.next());
            ErrorDetail errorDetail = new ErrorDetail((Exception)((Object)e));
            errorDetail.setValidationID(this.triggerDefn.getValidationID());
            errorDetailList.add(errorDetail);
        }
        ValidationEvent event = new ValidationEvent(toValidate, this.triggerDefn.getValidationID(), errorDetailList);
        module.broadcastValidationEvent(toValidate, event);
        return errors;
    }

    SemanticTriggerDefn getTriggerDefn() {
        return this.triggerDefn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("element=");
        sb.append(this.element.getElementName());
        sb.append(", ");
        sb.append("name=");
        if (this.element != null) {
            sb.append(this.element.getName());
        } else {
            sb.append("[null]");
        }
        sb.append(", ");
        sb.append("id=");
        sb.append(this.element.toString());
        sb.append(", ");
        sb.append("validator=");
        sb.append(this.triggerDefn.getValidatorName());
        return sb.toString();
    }

    static {
        $assertionsDisabled = !ValidationNode.class.desiredAssertionStatus();
    }
}

