/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.FileHandler;
import com.ibm.log.Formatter;
import com.ibm.log.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class DailyFileHandler
extends FileHandler {
    static final long serialVersionUID = 8861094114973975832L;
    private transient Formatter dateFormatter = new Formatter();
    private transient boolean daylightTime;
    private transient long today = System.currentTimeMillis() / 86400000L;

    public DailyFileHandler() {
        this.init();
    }

    public DailyFileHandler(String string) {
        super(string);
        this.init();
    }

    public DailyFileHandler(String string, String string2) {
        super(string, string2);
        this.init();
    }

    public DailyFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
        this.init();
    }

    private void init() {
        this.setMaxFiles(1);
        long l = System.currentTimeMillis();
        this.daylightTime = this.dateFormatter.isDaylightTime(l);
        this.today = this.dateFormatter.getToday(l);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("dateFormat", this.getDateFormat().toPattern());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("dateFormat");
        if (string != null) {
            this.setDateFormat(string);
        }
    }

    protected FileHandler.FileNameParts buildWorkingFileParts(String string, String string2) {
        FileHandler.FileNameParts fileNameParts = super.buildWorkingFileParts(string, string2);
        if (this.dateFormatter == null) {
            this.dateFormatter = new Formatter();
        }
        String string3 = String.valueOf(fileNameParts.getBaseName()) + "_" + this.dateFormatter.getDate(System.currentTimeMillis());
        fileNameParts.setBaseName(string3);
        fileNameParts.setWorkingName(String.valueOf(fileNameParts.getDirectory()) + string3 + fileNameParts.getExtension());
        return fileNameParts;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormatter.getDateFormat();
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.dateFormatter.setDateFormat(simpleDateFormat);
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDateFormat(SimpleDateFormat)");
            LogUtil.errorMsg(string);
        }
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormatter.setDateFormat(string);
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDateFormat(String)");
            LogUtil.errorMsg(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            boolean bl = this.getMaxFiles() != 1 && this.fileSize >= this.getMaxFileSize();
            long l = System.currentTimeMillis();
            long l2 = this.dateFormatter.getToday(l);
            if (!this.open || bl || this.today != l2) {
                this.close();
                this.today = l2;
                this.daylightTime = this.dateFormatter.isDaylightTime(l);
                this.setFileName(this.getFileName());
                super.open();
            }
        }
    }
}

