/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogNode;
import com.ibm.log.util.LogConstants;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageCatalog;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Formatter
extends LogNode
implements LogEventFormatter {
    static final long serialVersionUID = 4124205104283541665L;
    protected static final int DEFAULT_MSG_CATS = 10;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_SEPARATOR = " ";
    protected static final String INDENT = "  ";
    private boolean localizedDate = false;
    private boolean localizedTime = false;
    private transient Date date = new Date();
    private transient Date time = new Date();
    private transient FieldPosition dateField = new FieldPosition(0);
    private transient FieldPosition timeField = new FieldPosition(0);
    protected transient Hashtable msgCats = new Hashtable();
    private int maxMessageCatalogs = 10;
    private Locale locale = Locale.getDefault();
    private String localeCodes = this.locale.getDisplayName();
    private transient MessageCatalog textCat = new MessageCatalog(null);
    private final transient Object dateLock = new Object();
    private final transient Object timeLock = new Object();
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private SimpleDateFormat timeFormat = new SimpleDateFormat();
    private String separator = " ";
    protected transient String lineSep = System.getProperty("line.separator");
    private transient StringBuffer dateBuffer = new StringBuffer();
    private transient String formattedDate;
    private transient StringBuffer timeBuffer = new StringBuffer();
    private static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_DAY = 86400000L;
    private transient boolean daylightTime;
    private transient long today = System.currentTimeMillis() / 86400000L;
    private boolean wantIso8601TimeZone = true;
    private transient String iso8601TimeZone = null;

    public Formatter() {
        this.init();
    }

    public Formatter(String string) {
        super(string);
        this.init();
    }

    private void init() {
        TimeZone timeZone = TimeZone.getDefault();
        this.setDateFormat(DEFAULT_DATE_FORMAT);
        this.dateFormat.setTimeZone(timeZone);
        this.setTimeFormat(DEFAULT_TIME_FORMAT);
        this.timeFormat.setTimeZone(timeZone);
        long l = System.currentTimeMillis();
        this.daylightTime = this.isDaylightTime(l);
        this.today = this.getToday(l);
        this.formattedDate = this.formatDate(l);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.localizedDate) {
            properties.put("dateFormat", LogConstants.LOCALIZED_DATE_TIME);
        } else {
            properties.put("dateFormat", this.getDateFormat().toPattern());
        }
        if (this.localizedTime) {
            properties.put("timeFormat", LogConstants.LOCALIZED_DATE_TIME);
        } else {
            properties.put("timeFormat", this.getTimeFormat().toPattern());
        }
        properties.put("separator", this.getSeparator());
        properties.put("maxMsgCats", Integer.toString(this.getMaxMessageCatalogs()));
        properties.put("locale", this.getLocaleCodes());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("dateFormat");
        if (string != null) {
            if (string.equals(LogConstants.LOCALIZED_DATE_TIME)) {
                this.localizedDate = true;
                this.setDateFormat();
            } else {
                this.localizedDate = false;
                this.setDateFormat(string);
            }
        }
        if ((string = properties.getProperty("timeFormat")) != null) {
            if (string.equals(LogConstants.LOCALIZED_DATE_TIME)) {
                this.localizedTime = true;
                this.setTimeFormat();
            } else {
                this.localizedTime = false;
                this.setTimeFormat(string);
            }
        }
        if ((string = properties.getProperty("separator")) != null) {
            this.setSeparator(string);
        }
        if ((string = properties.getProperty("maxMsgCats")) != null) {
            this.setMaxMessageCatalogs(new Integer(string));
        }
        if ((string = properties.getProperty("locale")) != null) {
            this.setLocaleCodes(string);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLocale");
            LogUtil.errorMsg(string);
        }
    }

    public String getLocaleCodes() {
        return this.localeCodes;
    }

    public void setLocaleCodes(String string) {
        if (string != null) {
            this.localeCodes = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            Locale locale = null;
            switch (n) {
                case 1: {
                    locale = new Locale(stringArray[0], "");
                    break;
                }
                case 2: {
                    locale = new Locale(stringArray[0], stringArray[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
            if (locale != null) {
                this.setLocale(locale);
            }
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLocaleCodes");
            LogUtil.errorMsg(string2);
        }
    }

    public int getMaxMessageCatalogs() {
        return this.maxMessageCatalogs;
    }

    public void setMaxMessageCatalogs(int n) {
        if (n > 0) {
            this.maxMessageCatalogs = n;
            this.msgCats = new Hashtable(this.maxMessageCatalogs);
        } else {
            String string = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(n), String.valueOf(this.getClass().getName()) + ".setMaxMessageCatalogs");
            LogUtil.errorMsg(string);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setSeparator");
            LogUtil.errorMsg(string2);
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat() {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(3, this.getLocale());
            this.dateFormat = (SimpleDateFormat)dateFormat;
        }
        catch (Exception exception) {
            this.dateFormat = new SimpleDateFormat();
            this.setDateFormat(DEFAULT_DATE_FORMAT);
        }
        this.dateFormat.setTimeZone(TimeZone.getDefault());
        this.formattedDate = this.formatDate(System.currentTimeMillis());
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.dateFormat = simpleDateFormat;
            this.formattedDate = this.formatDate(System.currentTimeMillis());
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDateFormat(SimpleDateFormat)");
            LogUtil.errorMsg(string);
        }
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormat.applyPattern(string);
            this.formattedDate = this.formatDate(System.currentTimeMillis());
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setDateFormat(String)");
            LogUtil.errorMsg(string2);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat() {
        try {
            DateFormat dateFormat = DateFormat.getTimeInstance(3, this.getLocale());
            this.timeFormat = (SimpleDateFormat)dateFormat;
        }
        catch (Exception exception) {
            this.timeFormat = new SimpleDateFormat();
            this.setTimeFormat(DEFAULT_TIME_FORMAT);
        }
        this.timeFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.timeFormat = simpleDateFormat;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setTimeFormat(SimpleDateFormat)");
            LogUtil.errorMsg(string);
        }
    }

    public void setTimeFormat(String string) {
        if (string != null) {
            this.timeFormat.applyPattern(string);
            string.equals(DEFAULT_TIME_FORMAT);
        } else {
            String string2 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setTimeFormat(String)");
            LogUtil.errorMsg(string2);
        }
    }

    public String getDate(long l) {
        long l2 = this.getToday(l);
        if (this.today != l2) {
            this.today = l2;
            this.daylightTime = this.isDaylightTime(l);
            this.formattedDate = this.formatDate(l);
        }
        return this.formattedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime(long l) {
        Object object = this.timeLock;
        synchronized (object) {
            this.time.setTime(l);
            this.timeBuffer.setLength(0);
            StringBuffer stringBuffer = this.timeFormat.format(this.time, this.timeBuffer, this.timeField);
            if (this.wantIso8601TimeZone) {
                stringBuffer.append(this.getIso8601TimeZone(this.time));
            }
            return stringBuffer.toString();
        }
    }

    public String getIso8601TimeZone() {
        return this.getIso8601TimeZone(new Date(System.currentTimeMillis()));
    }

    public String getIso8601TimeZone(Date date) {
        if (this.iso8601TimeZone == null) {
            TimeZone timeZone = this.timeFormat.getTimeZone();
            int n = timeZone.getRawOffset();
            if (timeZone.inDaylightTime(date)) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
                gregorianCalendar.setTime(date);
                n += gregorianCalendar.get(16);
            }
            int n2 = n / 1000;
            int n3 = n2 / 3600;
            int n4 = n2 / 60 % 60;
            if (n4 < 0) {
                n4 = -n4;
            }
            this.iso8601TimeZone = new DecimalFormat("+00;-00").format(n3);
            this.iso8601TimeZone = String.valueOf(this.iso8601TimeZone) + ":";
            this.iso8601TimeZone = String.valueOf(this.iso8601TimeZone) + new DecimalFormat("00;00").format(n4);
        }
        return this.iso8601TimeZone;
    }

    public String format(LogEvent logEvent) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        long l = logEvent.getTimeStamp();
        stringBuffer.append(this.getDate(l));
        stringBuffer.append(string);
        stringBuffer.append(this.getTime(l));
        stringBuffer.append(string);
        String string2 = logEvent.getLoggingClass();
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getLoggingMethod()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getOrganization()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getProduct()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getProductInstance()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getComponent()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getClient()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getServer()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getServerFormat()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        if ((string2 = logEvent.getCorrelationId()) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        stringBuffer.append(this.getText(logEvent));
        return stringBuffer.toString();
    }

    public String getHeader() {
        return null;
    }

    public String getTrailer() {
        return null;
    }

    protected String getText(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.getMessage(logEvent));
        String string = logEvent.getStackTrace();
        if (string != null) {
            String string2 = logEvent.getText();
            if (string2 != null) {
                stringBuffer.append(this.lineSep);
                stringBuffer.append(INDENT);
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }

    public String getMessage(LogEvent logEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = logEvent.getText();
        Object[] objectArray = logEvent.getInserts();
        if (string != null) {
            stringBuffer.append(this.textCat.formatMessage(string, objectArray));
        } else {
            string = logEvent.getMessageKey();
            if (string != null) {
                String string2 = logEvent.getMessageFile();
                MessageCatalog messageCatalog = this.getMessageCatalog(string2);
                stringBuffer.append(messageCatalog.getMessage(string, objectArray));
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MessageCatalog getMessageCatalog(String string) {
        Locale locale = this.getLocale();
        MessageCatalog messageCatalog = (MessageCatalog)this.msgCats.get(string);
        if (messageCatalog != null) {
            if (locale.equals(messageCatalog.getLocale())) return messageCatalog;
            messageCatalog.setLocale(locale);
            return messageCatalog;
        }
        messageCatalog = new MessageCatalog(string, locale);
        Class<Formatter> clazz = Formatter.class;
        synchronized (Formatter.class) {
            if (this.msgCats.size() >= this.getMaxMessageCatalogs()) {
                Enumeration enumeration = this.msgCats.keys();
                String string2 = (String)enumeration.nextElement();
                int n = ((MessageCatalog)this.msgCats.get(string2)).getHitCount();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    int n2 = ((MessageCatalog)this.msgCats.get(string3)).getHitCount();
                    if (n2 >= n) continue;
                    string2 = string3;
                    n = n2;
                }
                this.msgCats.remove(string2);
            }
            this.msgCats.put(string, messageCatalog);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return messageCatalog;
        }
    }

    public long getToday(long l) {
        int n = TimeZone.getDefault().getRawOffset();
        if (this.daylightTime) {
            n = (int)((long)n + 3600000L);
        }
        return (l + (long)n) / 86400000L;
    }

    public boolean isDaylightTime(long l) {
        boolean bl = false;
        if (TimeZone.getDefault().inDaylightTime(new Date(l))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(long l) {
        Object object = this.dateLock;
        synchronized (object) {
            this.date.setTime(l);
            this.dateBuffer.setLength(0);
            StringBuffer stringBuffer = this.dateFormat.format(this.date, this.dateBuffer, this.dateField);
            return stringBuffer.toString();
        }
    }
}

