/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Formatter;
import com.ibm.log.LogEvent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducerImpl;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.util.Properties;

public abstract class Handler
extends LogEventProducerImpl
implements LogEventListener {
    protected boolean open = false;
    private ErrorProtocol errorProtocol = new MessageErrorProtocol();
    private LogEventFormatter formatter = new Formatter();
    protected transient Object deviceLock = new Object();
    private String formatterName = null;
    private String errorProtocolName = null;

    public Handler() {
    }

    public Handler(String string) {
        super(string);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.errorProtocolName != null) {
            properties.put("errorProtocolName", this.errorProtocolName);
        }
        if (this.formatterName != null) {
            properties.put("formatterName", this.formatterName);
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("errorProtocolName");
        if (string != null) {
            this.errorProtocolName = string;
        }
        if ((string = properties.getProperty("formatterName")) != null) {
            this.formatterName = string;
        }
    }

    public ErrorProtocol getErrorProtocol() {
        return this.errorProtocol;
    }

    public void setErrorProtocol(ErrorProtocol errorProtocol) {
        if (errorProtocol != null) {
            this.errorProtocol = errorProtocol;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setErrorProtocol");
            LogUtil.errorMsg(string);
        }
    }

    public LogEventFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(LogEventFormatter logEventFormatter) {
        if (logEventFormatter != null) {
            this.formatter = logEventFormatter;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setFormatter");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.open = false;
        }
    }

    public synchronized void process(LogEvent logEvent) {
        if (this.errorProtocol.isCleanupRequired()) {
            this.errorProtocol.cleanup(this);
        }
        try {
            this.write(logEvent);
        }
        catch (Exception exception) {
            this.errorProtocol.error(this, logEvent, exception);
        }
        this.log(logEvent);
    }

    public abstract void write(LogEvent var1) throws Exception;
}

