/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Filter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class LevelFilter
extends Filter {
    static final long serialVersionUID = 7693778762172659639L;
    private Level level = Level.ALL;

    public LevelFilter() {
    }

    public LevelFilter(String string) {
        super(string);
    }

    public LevelFilter(String string, Level level) {
        super(string);
        this.setLevel(level);
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("level", this.getLevel().getName());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("level");
        if (string != null) {
            this.setLevel(Level.getLevel(string));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".setLevel");
            LogUtil.errorMsg(string);
        }
    }

    public boolean isLoggable(LogEvent logEvent) {
        boolean bl = false;
        if (logEvent != null) {
            Level level = logEvent.getLevel();
            bl = level == null ? true : this.isLoggable(level);
        }
        return bl;
    }

    public boolean isLoggable(Level level) {
        return this.isLogging() && level != null && level.getValue() >= this.getLevel().getValue();
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + this.getLevel().toString();
    }
}

