/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.Channel;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.DataStoreSupport;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.util.LogException;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LogCmdProcessor
implements Runnable {
    private Channel channel = null;
    private LogManager mgr = LogManager.getManager();
    private String lineSep = System.getProperty("line.separator");

    public LogCmdProcessor(Socket socket) {
        this.channel = new Channel(socket);
    }

    public void run() {
        int n = 1;
        try {
            try {
                this.channel.open();
                String string = this.getCommand();
                n = this.processCommand(string.trim());
            }
            catch (Exception exception) {
                this.reportException(exception);
                this.write("RC:");
                this.write(new Integer(n).toString());
            }
        }
        finally {
            this.write("RC:");
            this.write(new Integer(n).toString());
        }
    }

    protected String getCommand() throws IOException, LogException {
        String string = this.channel.read();
        if (!string.equals("Cmd:")) {
            String string2 = LogUtil.getLogMsg("ERR_LOG_CMD_PROTOCOL", "Cmd:", string);
            throw new LogException(string2);
        }
        return this.channel.read();
    }

    protected int processCommand(String string) {
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("config")) {
            n = this.cmdConfig(string, stringTokenizer);
        } else if (string2.equals("help")) {
            n = this.cmdHelp(string, stringTokenizer);
        } else if (string2.equals("list")) {
            n = this.cmdList(string, stringTokenizer);
        } else if (string2.equals("remove")) {
            n = this.cmdRemove(string, stringTokenizer);
        } else if (string2.equals("save")) {
            n = this.cmdSave(string, stringTokenizer);
        } else if (string2.equals("set")) {
            n = this.cmdSet(string, stringTokenizer);
        } else if (string2.equals("dump")) {
            n = this.cmdDump(string, stringTokenizer);
        } else {
            String string3 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string3);
        }
        return n;
    }

    private int cmdConfig(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        try {
            String string2 = stringTokenizer.nextToken();
            DataStore dataStore = this.mgr.getDataStore();
            if (dataStore.containsConfig(string2)) {
                DataStoreConfig dataStoreConfig = dataStore.getConfig(string2);
                Enumeration<?> enumeration = dataStoreConfig.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = dataStoreConfig.getProperty(string3);
                    this.writeStdout(String.valueOf(string3) + "=" + string4 + this.lineSep);
                }
            } else {
                String string5 = LogUtil.getLogMsg("LOG_CMD_EMPTY", string2);
                this.writeStdout(string5);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 1;
            String string6 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string6);
        }
        catch (NullPointerException nullPointerException) {
            n = 1;
            String string7 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string7);
        }
        return n;
    }

    private int cmdHelp(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = LogUtil.getLogMsg("LOG_CMD_HELP");
        this.writeStdout(string2);
        return n;
    }

    private int cmdList(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {}
        DataStore dataStore = this.mgr.getDataStore();
        if (string2 == null) {
            if (dataStore instanceof DataStoreSupport) {
                DataStoreSupport dataStoreSupport = (DataStoreSupport)dataStore;
                DataStoreConfig dataStoreConfig = dataStoreSupport.getRoot();
                this.listChildren(dataStoreConfig);
            } else {
                Enumeration enumeration = dataStore.getConfig();
                while (enumeration.hasMoreElements()) {
                    DataStoreConfig dataStoreConfig = (DataStoreConfig)enumeration.nextElement();
                    string2 = dataStoreConfig.getProperty("name");
                    this.writeStdout(String.valueOf(string2) + this.lineSep);
                }
            }
        } else {
            DataStoreConfig dataStoreConfig = dataStore.getConfig(string2);
            Iterator iterator = dataStoreConfig.getChildren();
            if (iterator.hasNext()) {
                this.listChildren(dataStoreConfig);
            } else {
                String string3 = LogUtil.getLogMsg("LOG_CMD_NO_KIDS", string2);
                this.writeStdout(string3);
            }
        }
        return n;
    }

    private void listChildren(DataStoreConfig dataStoreConfig) {
        Iterator iterator = dataStoreConfig.getChildren();
        while (iterator.hasNext()) {
            DataStoreConfig dataStoreConfig2 = (DataStoreConfig)iterator.next();
            String string = dataStoreConfig2.getProperty("name");
            this.writeStdout(String.valueOf(string) + this.lineSep);
            this.listChildren(dataStoreConfig2);
        }
    }

    private int cmdRemove(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = null;
        String string3 = null;
        try {
            string2 = stringTokenizer.nextToken();
            try {
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {}
            DataStore dataStore = this.mgr.getDataStore();
            if (dataStore.containsConfig(string2)) {
                DataStoreConfig dataStoreConfig = dataStore.getConfig(string2);
                if (string3 == null) {
                    dataStore.removeConfig(dataStoreConfig);
                } else if (dataStoreConfig.containsKey(string3)) {
                    dataStoreConfig.remove(string3);
                } else {
                    n = 1;
                    String string4 = LogUtil.getLogMsg("LOG_CMD_NO_KEY", string2, string3);
                    this.writeStderr(string4);
                }
            } else {
                n = 1;
                String string5 = LogUtil.getLogMsg("LOG_CMD_NO_CFG", string2);
                this.writeStderr(string5);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 1;
            String string6 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string6);
        }
        return n;
    }

    private int cmdSave(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = null;
        DataStore dataStore = this.mgr.getDataStore();
        if (!dataStore.isWriteable()) {
            String string3 = LogUtil.getLogMsg("WARN_CANNOT_SAVE_CFG");
            this.writeStderr(string3);
            return 1;
        }
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (string2 == null) {
            try {
                dataStore.saveConfig(false);
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
        } else if (string2.equals("all")) {
            try {
                dataStore.saveConfig(true);
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
        } else {
            n = 1;
            String string4 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string4);
        }
        return n;
    }

    private int cmdSet(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken(" =");
            string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string4 = String.valueOf(string4) + " " + stringTokenizer.nextToken();
            }
            DataStore dataStore = this.mgr.getDataStore();
            if (dataStore.containsConfig(string2)) {
                DataStoreConfig dataStoreConfig = dataStore.getConfig(string2);
                dataStoreConfig.setProperty(string3, string4);
                dataStore.updateConfig(dataStoreConfig);
            } else {
                DataStoreConfig dataStoreConfig = new DataStoreConfig();
                dataStoreConfig.setProperty("name", string2);
                dataStoreConfig.setProperty(string3, string4);
                dataStore.addConfig(dataStoreConfig);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 1;
            String string5 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string5);
        }
        catch (AccessControlException accessControlException) {
            n = 1;
            String string6 = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", string2, accessControlException.getMessage());
            this.writeStderr(string6);
        }
        return n;
    }

    private int cmdDump(String string, StringTokenizer stringTokenizer) {
        int n = 0;
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            DataStore dataStore = this.mgr.getDataStore();
            if (dataStore.containsConfig(string2)) {
                DataStoreConfig dataStoreConfig = dataStore.getConfig(string2);
                dataStoreConfig.setProperty("dumpEvents", "true");
                dataStore.updateConfig(dataStoreConfig);
                dataStoreConfig.remove("dumpEvents");
            } else {
                n = 1;
                String string3 = LogUtil.getLogMsg("ERR_HANDLER_NOT_FOUND", string2);
                this.writeStderr(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            n = 1;
            String string4 = LogUtil.getLogMsg("LOG_CMD_INVALID", string);
            this.writeStderr(string4);
        }
        return n;
    }

    protected void reportException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        this.write("Stderr:");
        this.write(stringWriter.toString());
    }

    protected void write(String string) {
        try {
            this.channel.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void writeStdout(String string) {
        this.write("Stdout:");
        this.write(string);
    }

    protected void writeStderr(String string) {
        this.write("Stderr:");
        this.write(string);
    }
}

