/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.util.LogUtil;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class DataStoreConfig
extends Properties {
    static final long serialVersionUID = 5459450638190200411L;
    private boolean loadedFromDataStore = false;
    private DataStoreConfig parent = null;
    private Vector children = null;

    public DataStoreConfig() {
    }

    public DataStoreConfig(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    public DataStoreConfig getParent() {
        return this.parent;
    }

    public void setParent(DataStoreConfig dataStoreConfig) {
        this.parent = dataStoreConfig;
        this.defaults = dataStoreConfig;
    }

    public void addChild(DataStoreConfig dataStoreConfig) {
        if (dataStoreConfig != null) {
            if (this.children == null) {
                this.children = new Vector();
            }
            if (!this.children.contains(dataStoreConfig)) {
                this.children.add(dataStoreConfig);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addChild");
            LogUtil.errorMsg(string);
        }
    }

    public void removeChild(DataStoreConfig dataStoreConfig) {
        if (dataStoreConfig != null) {
            if (this.children != null && this.children.contains(dataStoreConfig)) {
                this.children.remove(dataStoreConfig);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".removeChild");
            LogUtil.errorMsg(string);
        }
    }

    public Iterator getChildren() {
        Iterator iterator = this.children == null ? new Vector().iterator() : this.children.iterator();
        return iterator;
    }

    public boolean isLoadedFromDataStore() {
        return this.loadedFromDataStore;
    }

    public void setLoadedFromDataStore(boolean bl) {
        this.loadedFromDataStore = bl;
    }

    public String toString() {
        Object object;
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Configuration:\r\n");
        stringBuffer.append(string);
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            stringBuffer.append("      " + (String)object + ":  " + this.getProperty((String)object));
            stringBuffer.append(string);
        }
        object = this.getParent();
        if (object != null) {
            stringBuffer.append("      Parent:  " + ((Properties)object).getProperty("name"));
            stringBuffer.append(string);
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            DataStoreConfig dataStoreConfig = (DataStoreConfig)iterator.next();
            stringBuffer.append("      Child:  " + dataStoreConfig.getProperty("name"));
            stringBuffer.append(string);
        }
        stringBuffer.append("      Loaded from DataStore::  " + this.isLoadedFromDataStore());
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

