/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.birt.report.data.oda.xml.i18n.Messages;
import org.eclipse.birt.report.data.oda.xml.util.date.DateFormatFactory;
import org.eclipse.birt.report.data.oda.xml.util.date.PatternKey;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class DateFormatISO8601 {
    public static Date parse(String source) throws OdaException {
        if (source == null) {
            return null;
        }
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            try {
                resultDate = simpleDateFormatter.parse(source);
                return resultDate;
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
        }
        if (resultDate == null) {
            throw new OdaException(Messages.getString("DateUtil.ConvertFails") + source);
        }
        return resultDate;
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim().replaceFirst("\\Q+\\E", " GMT+")).indexOf(84) < 12) {
            s = s.replaceFirst("T", " ");
        }
        if ((zoneIndex = s.indexOf(90)) == s.length() - 1) {
            return s.substring(0, zoneIndex);
        }
        return s.trim();
    }
}

