/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.xml.util.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.birt.report.data.oda.xml.util.ui.ATreeNode;
import org.eclipse.birt.report.data.oda.xml.util.ui.VisitingRecorder;
import org.eclipse.datatools.connectivity.oda.OdaException;

final class XSDFileSchemaTreePopulator {
    private static boolean includeAttribute = true;

    XSDFileSchemaTreePopulator() {
    }

    private static void populateRoot(ATreeNode root) {
        Object[] toBeIterated = root.getChildren();
        for (int i = 0; i < toBeIterated.length; ++i) {
            String value = ((ATreeNode)toBeIterated[i]).getDataType();
            ArrayList container = new ArrayList();
            XSDFileSchemaTreePopulator.findNodeWithValue(root, value.toString(), container, new VisitingRecorder());
            for (int j = 0; j < container.size(); ++j) {
                if (((ATreeNode)container.get(j)).getChildren().length != 0) continue;
                Object[] os = ((ATreeNode)toBeIterated[i]).getChildren();
                for (int k = 0; k < os.length; ++k) {
                    if (((ATreeNode)os[k]).getDataType() != null && ((ATreeNode)os[k]).getDataType().equals(((ATreeNode)container.get(j)).getDataType())) continue;
                    ((ATreeNode)container.get(j)).addChild(os[k]);
                }
            }
        }
    }

    private static void findNodeWithValue(ATreeNode root, String value, List container, VisitingRecorder vr) {
        if (root.getType() == 1 && !vr.visit(root.getValue().toString())) {
            return;
        }
        if (root.getDataType() != null && root.getDataType().equals(value)) {
            container.add(root);
        }
        Object[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            XSDFileSchemaTreePopulator.findNodeWithValue((ATreeNode)children[i], value, container, vr);
        }
    }

    public static ATreeNode getSchemaTree(String fileName, boolean incAttr) throws OdaException, MalformedURLException, URISyntaxException {
        includeAttribute = incAttr;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        URI uri = null;
        File f = new File(fileName);
        if (f.exists()) {
            uri = f.toURI();
        } else {
            URL url = new URL(fileName);
            uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
        if (uri == null) {
            uri = new URI(fileName);
        }
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        XSModel xsModel = xsLoader.loadURI(uri.toString());
        ATreeNode complexTypesRoot = XSDFileSchemaTreePopulator.populateComplexTypeTree(xsModel);
        XSNamedMap map = xsModel.getComponents((short)2);
        ATreeNode root = new ATreeNode();
        root.setValue("ROOT");
        for (int i = 0; i < map.getLength(); ++i) {
            ATreeNode node = new ATreeNode();
            XSElementDecl element = (XSElementDecl)map.item(i);
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getName());
            if (element.getTypeDefinition() instanceof XSComplexTypeDecl) {
                XSComplexTypeDecl complexType = (XSComplexTypeDecl)element.getTypeDefinition();
                if (complexType.getName() != null) {
                    node.setDataType(complexType.getName());
                    ATreeNode n = XSDFileSchemaTreePopulator.findComplexElement(complexTypesRoot, complexType.getName());
                    if (n != null) {
                        node.addChild(n.getChildren());
                    }
                } else {
                    XSDFileSchemaTreePopulator.addParticleAndAttributeInfo(node, complexType, complexTypesRoot, new VisitingRecorder());
                }
            }
            root.addChild(node);
        }
        XSDFileSchemaTreePopulator.populateRoot(root);
        return root;
    }

    private static void addParticleAndAttributeInfo(ATreeNode node, XSComplexTypeDecl complexType, ATreeNode complexTypesRoot, VisitingRecorder vr) throws OdaException {
        if (!vr.visit(node.getValue().toString())) {
            return;
        }
        XSParticle particle = complexType.getParticle();
        if (particle != null) {
            XSDFileSchemaTreePopulator.addElementToNode(node, complexTypesRoot, (XSModelGroupImpl)particle.getTerm(), vr);
        }
        if (!includeAttribute) {
            return;
        }
        XSAttributeGroupDecl group = complexType.getAttrGrp();
        if (group != null) {
            XSObjectList list = group.getAttributeUses();
            for (int j = 0; j < list.getLength(); ++j) {
                ATreeNode childNode = new ATreeNode();
                childNode.setValue(((XSAttributeUseImpl)list.item(j)).getAttrDeclaration().getName());
                childNode.setType(2);
                node.addChild(childNode);
            }
        }
    }

    private static void addElementToNode(ATreeNode node, ATreeNode complexTypesRoot, XSModelGroupImpl group, VisitingRecorder vr) throws OdaException {
        if (!vr.visit(node.getValue().toString())) {
            return;
        }
        XSObjectList list = group.getParticles();
        for (int j = 0; j < list.getLength(); ++j) {
            if (((XSParticleDecl)list.item(j)).getTerm() instanceof XSModelGroupImpl) {
                XSDFileSchemaTreePopulator.addElementToNode(node, complexTypesRoot, (XSModelGroupImpl)((XSParticleDecl)list.item(j)).getTerm(), vr);
                continue;
            }
            ATreeNode childNode = new ATreeNode();
            childNode.setValue(((XSParticleDecl)list.item(j)).getTerm().getName());
            String dataType = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition().getName();
            if (dataType == null || dataType.length() == 0) {
                dataType = childNode.getValue().toString();
            }
            childNode.setDataType(dataType);
            childNode.setType(1);
            XSTypeDefinition xstype = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition();
            if (!dataType.equals("anyType") && xstype instanceof XSComplexTypeDecl) {
                ATreeNode n;
                if (xstype.getName() == null) {
                    XSDFileSchemaTreePopulator.addParticleAndAttributeInfo(childNode, (XSComplexTypeDecl)xstype, complexTypesRoot, vr);
                }
                if ((n = XSDFileSchemaTreePopulator.findComplexElement(complexTypesRoot, dataType)) != null) {
                    childNode.addChild(n.getChildren());
                }
            }
            node.addChild(childNode);
        }
    }

    private static ATreeNode findComplexElement(ATreeNode root, String value) {
        Object[] os = root.getChildren();
        for (int i = 0; i < os.length; ++i) {
            if (!((ATreeNode)os[i]).getValue().equals(value)) continue;
            return (ATreeNode)os[i];
        }
        return null;
    }

    private static ATreeNode populateComplexTypeTree(XSModel xsModel) throws OdaException {
        XSNamedMap map = xsModel.getComponents((short)15);
        ATreeNode root = new ATreeNode();
        root.setValue("ROOT");
        root.setDataType("");
        for (int i = 0; i < map.getLength(); ++i) {
            XSAttributeGroupDecl group;
            ATreeNode node = new ATreeNode();
            XSComplexTypeDecl element = (XSComplexTypeDecl)map.item(i);
            if (element.getName().equals("anyType")) continue;
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getTypeName());
            root.addChild(node);
            XSParticle particle = element.getParticle();
            if (particle != null) {
                XSObjectList list = ((XSModelGroupImpl)particle.getTerm()).getParticles();
                XSDFileSchemaTreePopulator.populateTreeNodeWithParticles(node, list);
            }
            if (!includeAttribute || (group = element.getAttrGrp()) == null) continue;
            XSObjectList list = group.getAttributeUses();
            for (int j = 0; j < list.getLength(); ++j) {
                ATreeNode childNode = new ATreeNode();
                childNode.setValue(((XSAttributeUseImpl)list.item(j)).getAttrDeclaration().getName());
                childNode.setType(2);
                node.addChild(childNode);
            }
        }
        XSDFileSchemaTreePopulator.populateRoot(root);
        return root;
    }

    private static void populateTreeNodeWithParticles(ATreeNode node, XSObjectList list) throws OdaException {
        for (int j = 0; j < list.getLength(); ++j) {
            ATreeNode childNode = new ATreeNode();
            childNode.setValue(((XSParticleDecl)list.item(j)).getTerm().getName());
            if (((XSParticleDecl)list.item(j)).getTerm() instanceof XSElementDecl) {
                String dataType = ((XSElementDecl)((XSParticleDecl)list.item(j)).getTerm()).getTypeDefinition().getName();
                if (dataType == null || dataType.length() == 0) {
                    dataType = childNode.getValue().toString();
                }
                childNode.setDataType(dataType);
                childNode.setType(1);
                node.addChild(childNode);
                continue;
            }
            if (!(((XSParticleDecl)list.item(j)).getTerm() instanceof XSModelGroupImpl)) continue;
            XSModelGroupImpl mGroup = (XSModelGroupImpl)((XSParticleDecl)list.item(j)).getTerm();
            XSObjectList obs = mGroup.getParticles();
            XSDFileSchemaTreePopulator.populateTreeNodeWithParticles(node, obs);
        }
    }
}

