/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.CandidateQuery;
import org.eclipse.birt.data.engine.executor.DataSourceQuery;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;

class DataSource
implements IDataSource {
    private String driverName;
    private Map appContext;
    private Properties connectionProps = new Properties();
    private HashSet odaConnections = new HashSet();
    private HashMap statementMap = new HashMap();
    private static String className;
    private static Logger logger;
    private DataEngineSession session;
    static final /* synthetic */ boolean $assertionsDisabled;

    DataSource(String driverName, Map connProperties, DataEngineSession session) {
        this.driverName = driverName;
        if (connProperties != null) {
            this.connectionProps.putAll((Map<?, ?>)connProperties);
        }
        this.session = session;
    }

    String getDriverName() {
        return this.driverName;
    }

    public void addProperty(String name, String value) throws DataException {
        if (this.isOpen()) {
            throw new DataException("data.engine.DataSourceIsOpen");
        }
        this.connectionProps.put(name, value);
    }

    public void setAppContext(Map context) throws DataException {
        this.appContext = context;
    }

    public boolean isOpen() {
        return this.odaConnections.size() > 0;
    }

    public void open() throws DataException {
        if (this.isOpen()) {
            return;
        }
        if (this.driverName == null || this.driverName.length() == 0) {
            return;
        }
        this.newConnection();
    }

    private CacheConnection newConnection() throws DataException {
        CacheConnection conn = new CacheConnection();
        conn.odaConn = ConnectionManager.getInstance().openConnection(this.driverName, this.connectionProps, this.appContext);
        int max = conn.odaConn.getMaxQueries();
        if (max != 0) {
            conn.maxStatements = max;
        }
        this.odaConnections.add(conn);
        return conn;
    }

    private CacheConnection getAvailableConnection() throws DataException {
        Iterator it = this.odaConnections.iterator();
        while (it.hasNext()) {
            CacheConnection c = (CacheConnection)it.next();
            if (c.currentStatements >= c.maxStatements) continue;
            return c;
        }
        return this.newConnection();
    }

    public IDataSourceQuery newQuery(String queryType, String queryText) throws DataException {
        return new DataSourceQuery(this, queryType, queryText, this.session);
    }

    public ICandidateQuery newCandidateQuery() {
        return new CandidateQuery(this.session);
    }

    synchronized PreparedStatement prepareStatement(String queryText, String dataSetType) throws DataException {
        if (!$assertionsDisabled && !this.isOpen()) {
            throw new AssertionError();
        }
        CacheConnection conn = this.getAvailableConnection();
        if (!$assertionsDisabled && conn.currentStatements >= conn.maxStatements) {
            throw new AssertionError();
        }
        ++conn.currentStatements;
        PreparedStatement stmt = conn.odaConn.prepareStatement(queryText, dataSetType);
        this.statementMap.put(stmt, conn);
        return stmt;
    }

    synchronized void closeStatement(PreparedStatement stmt) {
        if (!$assertionsDisabled && stmt == null) {
            throw new AssertionError();
        }
        CacheConnection conn = (CacheConnection)this.statementMap.remove(stmt);
        if (conn == null) {
            System.out.println("d");
            logger.logp(Level.WARNING, className, "closeStatement", "statement not found");
        } else {
            --conn.currentStatements;
            if (conn.currentStatements < 0) {
                logger.warning(DataSource.class.getName() + ".closeStatement: negative statement count for connection.");
            }
        }
        try {
            stmt.close();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, className, "closeStatement", "Exception at PreparedStatement.close()", (Throwable)((Object)e));
        }
    }

    public boolean canClose() {
        return this.statementMap.size() == 0;
    }

    public void close() {
        if (this.statementMap.size() > 0) {
            Iterator keySet = this.statementMap.keySet().iterator();
            while (keySet.hasNext()) {
                PreparedStatement stmt = (PreparedStatement)keySet.next();
                try {
                    stmt.close();
                }
                catch (DataException e) {
                    logger.logp(Level.FINE, className, "close", "Exception at PreparedStatement.close()", (Throwable)((Object)e));
                }
            }
            this.statementMap.clear();
        }
        Iterator it = this.odaConnections.iterator();
        while (it.hasNext()) {
            CacheConnection c = (CacheConnection)it.next();
            try {
                c.odaConn.close();
            }
            catch (DataException e) {
                logger.logp(Level.FINE, className, "close", "Exception at Connection.close()", (Throwable)((Object)e));
            }
        }
        this.odaConnections.clear();
    }

    public void finalize() {
        if (this.isOpen()) {
            this.close();
        }
    }

    static {
        $assertionsDisabled = !DataSource.class.desiredAssertionStatus();
        className = DataSource.class.getName();
        logger = Logger.getLogger(className);
    }

    private static final class CacheConnection {
        Connection odaConn;
        int maxStatements = Integer.MAX_VALUE;
        int currentStatements = 0;

        private CacheConnection() {
        }
    }
}

