/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;

class ComputedColumnsState
implements IComputedColumnsState {
    private ComputedColumnsStateSwitch ccsSwitch;

    ComputedColumnsState(ComputedColumnHelper helper) {
        this.ccsSwitch = new ComputedColumnsStateSwitch(helper);
    }

    public boolean isValueAvailable(int index) {
        return this.ccsSwitch.getCurrentInstance().isValueAvailable(index);
    }

    public String getName(int index) {
        return this.ccsSwitch.getCurrentInstance().getName(index);
    }

    public IBaseExpression getExpression(int index) {
        return this.ccsSwitch.getCurrentInstance().getExpression(index);
    }

    public void setValueAvailable(int index) {
        this.ccsSwitch.getCurrentInstance().setValueAvailable(index);
    }

    public int getCount() {
        return this.ccsSwitch.getCurrentInstance().getCount();
    }

    public IComputedColumn getComputedColumn(int index) {
        return this.ccsSwitch.getCurrentInstance().getComputedColumn(index);
    }

    public void setModel(int model) {
        this.ccsSwitch.setScopeState(model);
    }

    public int getLastAccessedComputedColumnIndex() {
        return this.ccsSwitch.getCurrentInstance().getLastAccessedComputedColumnIndex();
    }

    public void setLastAccessedComputedColumnId(int index) {
        this.ccsSwitch.getCurrentInstance().setLastAccessedComputedColumnId(index);
    }

    private class ComputedColumnsStateInstance {
        private List computedColumnsList = new ArrayList();
        private boolean[] isValueAvailable;
        private int lastAccessedCCIndex = -1;

        public ComputedColumnsStateInstance(List computedColumnList) {
            this.computedColumnsList.addAll(computedColumnList);
            this.isValueAvailable = new boolean[computedColumnList.size()];
            for (int i = 0; i < this.isValueAvailable.length; ++i) {
                this.isValueAvailable[i] = false;
            }
        }

        public boolean isValueAvailable(int index) {
            return this.isValueAvailable[index];
        }

        public String getName(int index) {
            return ((IComputedColumn)this.computedColumnsList.get(index)).getName();
        }

        public ScriptExpression getExpression(int index) {
            return (ScriptExpression)((IComputedColumn)this.computedColumnsList.get(index)).getExpression();
        }

        public void setValueAvailable(int index) {
            this.isValueAvailable[index] = true;
        }

        public int getCount() {
            return this.computedColumnsList.size();
        }

        public IComputedColumn getComputedColumn(int index) {
            return (IComputedColumn)this.computedColumnsList.get(index);
        }

        public int getLastAccessedComputedColumnIndex() {
            return this.lastAccessedCCIndex;
        }

        public void setLastAccessedComputedColumnId(int index) {
            this.lastAccessedCCIndex = index;
        }
    }

    private class ComputedColumnsStateSwitch {
        private ComputedColumnsStateInstance dataSetCC;
        private ComputedColumnsStateInstance resultSetCC;
        private ComputedColumnsStateInstance allCC;
        private int scopeState;

        ComputedColumnsStateSwitch(ComputedColumnHelper helper) {
            helper.setModel(0);
            this.dataSetCC = new ComputedColumnsStateInstance(helper.getComputedColumnList());
            helper.setModel(1);
            this.resultSetCC = new ComputedColumnsStateInstance(helper.getComputedColumnList());
            helper.setModel(2);
            this.allCC = new ComputedColumnsStateInstance(helper.getComputedColumnList());
        }

        void setScopeState(int state) {
            this.scopeState = state;
        }

        ComputedColumnsStateInstance getCurrentInstance() {
            if (this.scopeState == 0) {
                return this.dataSetCC;
            }
            if (this.scopeState == 1) {
                return this.resultSetCC;
            }
            if (this.scopeState == 2) {
                return this.allCC;
            }
            return null;
        }
    }
}

