/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.MetaDataPopulator;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.data.adapter.impl.ResultMetaData;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.CompaibilityUtil;
import org.eclipse.birt.report.model.core.Module;

public class DataSetMetaDataHelper {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;

    DataSetMetaDataHelper(DataEngine dataEngine, IModelAdapter modelAdaptor, DataSessionContext sessionContext) {
        this.dataEngine = dataEngine;
        this.modelAdaptor = modelAdaptor;
        this.sessionContext = sessionContext;
    }

    IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        if (dataSetHandle == null) {
            throw new AdapterException("datasethandle.null.error");
        }
        if (useCache) {
            return this.getCachedMetaData(dataSetHandle.getCachedMetaDataHandle());
        }
        return this.getRealMetaData(dataSetHandle);
    }

    private IResultMetaData getCachedMetaData(CachedMetaDataHandle cmdHandle) throws BirtException {
        if (cmdHandle == null) {
            return null;
        }
        Iterator it = cmdHandle.getResultSet().iterator();
        ArrayList<ColumnDefinition> columnMeta = new ArrayList<ColumnDefinition>();
        while (it.hasNext()) {
            ResultSetColumnHandle rsColumn = (ResultSetColumnHandle)it.next();
            ColumnDefinition cd = this.modelAdaptor.ColumnAdaptor(rsColumn);
            columnMeta.add(cd);
        }
        return new ResultMetaData(columnMeta);
    }

    private IResultMetaData getRealMetaData(DataSetHandle dataSetHandle) throws BirtException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSetHandle.getQualifiedName());
        query.setMaxRows(1);
        IResultMetaData metaData = MetaDataPopulator.retrieveResultMetaData(dataSetHandle);
        if (metaData == null) {
            metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext, false).executeQuery(query).getResultMetaData();
            if (dataSetHandle.canEdit()) {
                this.addResultSetColumn(dataSetHandle, metaData);
            }
            if (MetaDataPopulator.needsUseResultHint(dataSetHandle, metaData)) {
                metaData = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext, true).executeQuery(query).getResultMetaData();
            }
        }
        if (!(dataSetHandle instanceof ScriptDataSetHandle)) {
            this.clearUnusedData(dataSetHandle, metaData);
        }
        return metaData;
    }

    private void addResultSetColumn(DataSetHandle dataSetHandle, IResultMetaData meta) throws BirtException {
        if (meta == null || !(dataSetHandle instanceof OdaDataSetHandle)) {
            return;
        }
        PropertyHandle resultSetColumnHandle = dataSetHandle.getPropertyHandle("resultSet");
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            OdaResultSetColumn rsColumn = new OdaResultSetColumn();
            if (meta.isComputedColumn(i)) continue;
            try {
                rsColumn.setColumnName(meta.getColumnName(i));
                rsColumn.setDataType(DataSetMetaDataHelper.toModelDataType(meta.getColumnType(i)));
                rsColumn.setNativeName(meta.getColumnName(i));
                rsColumn.setPosition(new Integer(i));
                resultSetColumnHandle.addItem((IStructure)rsColumn);
                continue;
            }
            catch (BirtException e) {
                e.printStackTrace();
            }
        }
    }

    private final void clearUnusedData(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        this.clearUnusedColumnHints(dataSetHandle, metaData);
        this.clearUnusedResultSetColumns(dataSetHandle, metaData);
    }

    private final void clearUnusedColumnHints(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("columnHints");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            for (int n = count - 1; n >= 0; --n) {
                ColumnHint hint = (ColumnHint)list.get(n);
                String columnName = (String)hint.getProperty((Module)handle.getDesign(), "columnName");
                boolean found = false;
                if (!this.isEmpty(hint, handle.getModule().getModuleHandle())) {
                    for (int m = 0; m < metaData.getColumnCount() && !found; ++m) {
                        found = columnName.equals(metaData.getColumnName(m + 1));
                    }
                }
                if (found) continue;
                try {
                    handle.removeItem((IStructure)hint);
                    continue;
                }
                catch (PropertyValueException e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isEmpty(ColumnHint hint, ModuleHandle designHandle) {
        String alias = (String)hint.getProperty(designHandle.getModule(), "alias");
        String displayName = (String)hint.getProperty(designHandle.getModule(), "displayName");
        String helpText = (String)hint.getProperty(designHandle.getModule(), "helpText");
        return !(alias != null && alias.trim().length() != 0 || displayName != null && displayName.trim().length() != 0 || helpText != null && helpText.trim().length() != 0);
    }

    private final void clearUnusedResultSetColumns(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        PropertyHandle resultSetHintsPropertyHandle = dataSetHandle.getPropertyHandle("resultSetHints");
        ArrayList list = null;
        if (resultSetHintsPropertyHandle != null) {
            list = resultSetHintsPropertyHandle.getListValue();
        }
        if (list != null) {
            int count = list.size();
            for (int n = count - 1; n >= 0; --n) {
                ResultSetColumn column = (ResultSetColumn)list.get(n);
                boolean found = false;
                for (int m = 0; m < metaData.getColumnCount() && !found; ++m) {
                    found = m + 1 == column.getPosition() && (column.getColumnName() == null || column.getColumnName().equals(metaData.getColumnName(m + 1)));
                }
                if (found) continue;
                try {
                    if (resultSetHintsPropertyHandle == null) continue;
                    resultSetHintsPropertyHandle.removeItem((IStructure)column);
                    continue;
                }
                catch (PropertyValueException e) {
                    // empty catch block
                }
            }
        }
    }

    IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return this.refreshMetaData(dataSetHandle, false);
    }

    IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        IResultMetaData rsMeta = null;
        BirtException e = null;
        try {
            rsMeta = this.getDataSetMetaData(dataSetHandle, false);
        }
        catch (BirtException e1) {
            e = e1;
        }
        if (this.needsSetCachedMetaData(dataSetHandle, rsMeta)) {
            int i;
            ArrayList<ResultSetColumn> columnList = new ArrayList<ResultSetColumn>();
            if (rsMeta != null && rsMeta.getColumnCount() != 0) {
                for (i = 1; i <= rsMeta.getColumnCount(); ++i) {
                    ResultSetColumn rsc = StructureFactory.createResultSetColumn();
                    rsc.setColumnName(this.getColumnName(rsMeta, i));
                    rsc.setDataType(DataSetMetaDataHelper.toModelDataType(rsMeta.getColumnType(i)));
                    rsc.setPosition(new Integer(i));
                    columnList.add(rsc);
                }
            }
            if (holdEvent) {
                CompaibilityUtil.updateResultSetinCachedMetaData((DataSetHandle)dataSetHandle, columnList);
            } else {
                dataSetHandle.setCachedMetaData(StructureFactory.createCachedMetaData());
                for (i = 0; i < columnList.size(); ++i) {
                    dataSetHandle.getCachedMetaDataHandle().getResultSet().addItem((IStructure)((ResultSetColumn)columnList.get(i)));
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return rsMeta;
    }

    private boolean needsSetCachedMetaData(DataSetHandle dataSetHandle, IResultMetaData rsMeta) throws BirtException {
        if (dataSetHandle.getCachedMetaDataHandle() == null || rsMeta == null || rsMeta.getColumnCount() == 0) {
            return true;
        }
        ArrayList list = new ArrayList();
        Iterator iter = dataSetHandle.getCachedMetaDataHandle().getResultSet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (list.size() != rsMeta.getColumnCount()) {
            return true;
        }
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            ResultSetColumnHandle handle = (ResultSetColumnHandle)list.get(i - 1);
            if (handle.getColumnName() != null && handle.getColumnName().equals(this.getColumnName(rsMeta, i)) && handle.getDataType().equals(DataSetMetaDataHelper.toModelDataType(rsMeta.getColumnType(i)))) continue;
            return true;
        }
        return false;
    }

    private String getColumnName(IResultMetaData rsMeta, int index) throws BirtException {
        return rsMeta.getColumnAlias(index) == null || rsMeta.getColumnAlias(index).trim().length() == 0 ? rsMeta.getColumnName(index) : rsMeta.getColumnAlias(index);
    }

    private static String toModelDataType(int modelDataType) {
        if (modelDataType == 2) {
            return "integer";
        }
        if (modelDataType == 5) {
            return "string";
        }
        if (modelDataType == 6) {
            return "date-time";
        }
        if (modelDataType == 4) {
            return "decimal";
        }
        if (modelDataType == 3) {
            return "float";
        }
        return "any";
    }
}

