/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal;

import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.eclipse.aperi.connector.internal.CustomSerializerMgr;
import org.eclipse.aperi.connector.internal.JavaObjectSerializer;
import org.eclipse.aperi.connector.log.LogHelper;
import org.eclipse.aperi.util.extensions.ExtensionException;

public class MappingRegistry
extends SOAPMappingRegistry {
    private static final String soapEncURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private final JavaObjectSerializer jos = new JavaObjectSerializer();
    private static MappingRegistry instance = new MappingRegistry();

    public MappingRegistry() {
    }

    public MappingRegistry(SOAPMappingRegistry sOAPMappingRegistry, String string) {
        super(sOAPMappingRegistry, string);
    }

    public static MappingRegistry getInstance() {
        return instance;
    }

    private void mapJavaObject(Class clazz) {
        this.mapTypes(soapEncURI, new QName(clazz.getName(), "JavaObject"), clazz, this.jos, this.jos);
    }

    public QName queryElementType(Class clazz, String string) throws IllegalArgumentException {
        try {
            return super.queryElementType(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (clazz != null && string != null && string.equals(soapEncURI)) {
                this.mapJavaObject(clazz);
                return new QName(clazz.getName(), "JavaObject");
            }
            throw illegalArgumentException;
        }
    }

    public Serializer querySerializer(Class clazz, String string) throws IllegalArgumentException {
        Serializer serializer = null;
        try {
            serializer = super.querySerializer(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogHelper.trace("Did not find serializer for '" + clazz.getName() + "' in standard mapping registry, search extensions registry.", ((Object)((Object)this)).getClass(), "querySerializer");
            try {
                CustomSerializerMgr customSerializerMgr = CustomSerializerMgr.getInstance();
                serializer = customSerializerMgr.getSerializer(clazz.getName());
            }
            catch (ExtensionException extensionException) {
                LogHelper.trace("Did not find serializer for '" + clazz.getName() + "' in the extensions registry, use the Java Bean Serializer.", ((Object)((Object)this)).getClass(), "querySerializer");
                if (clazz != null && string != null && string.equals(soapEncURI)) {
                    this.mapJavaObject(clazz);
                    return this.jos;
                }
                LogHelper.trace("javaType is null and encodingStyleURI is null", ((Object)((Object)this)).getClass(), "querySerializer");
                Exception exception = new Exception(extensionException);
                LogHelper.traceException(exception, ((Object)((Object)this)).getClass(), "querySerializer");
                throw illegalArgumentException;
            }
        }
        return serializer;
    }

    public Deserializer queryDeserializer(QName qName, String string) throws IllegalArgumentException {
        Deserializer deserializer = null;
        try {
            deserializer = super.queryDeserializer(qName, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogHelper.trace("Did not find deserializer for '" + qName.getClass().getName() + "' in standard mapping registry, search extensions registry.", ((Object)((Object)this)).getClass(), "queryDeserializer");
            try {
                CustomSerializerMgr customSerializerMgr = CustomSerializerMgr.getInstance();
                deserializer = customSerializerMgr.getDeserializer(qName.getNamespaceURI());
            }
            catch (ExtensionException extensionException) {
                LogHelper.trace("Did not find serializer for '" + qName.getClass().getName() + "' in the extensions registry, use the Java Bean Serializer.", ((Object)((Object)this)).getClass(), "queryDeserializer");
                if (qName != null && string != null && string.equals(soapEncURI)) {
                    String string2 = qName.getNamespaceURI();
                    Class clazz = Object.class;
                    try {
                        clazz = Class.forName(string2);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException(exception.toString());
                    }
                    this.mapJavaObject(clazz);
                    return this.jos;
                }
                LogHelper.trace("elementType is null and encodingStyleURI is null", ((Object)((Object)this)).getClass(), "queryDeserializer");
                Exception exception = new Exception(extensionException);
                LogHelper.traceException(exception, ((Object)((Object)this)).getClass(), "queryDeserializer");
                throw illegalArgumentException;
            }
        }
        return deserializer;
    }

    public Class queryJavaType(QName qName, String string) throws IllegalArgumentException {
        try {
            return super.queryJavaType(qName, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (qName != null && string != null && string.equals(soapEncURI)) {
                String string2 = qName.getNamespaceURI();
                Class clazz = Object.class;
                try {
                    clazz = Class.forName(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(illegalArgumentException.toString());
                }
                this.mapJavaObject(clazz);
                return clazz;
            }
            throw illegalArgumentException;
        }
    }
}

