/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.core.archive.compound.AllocationTable;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveHeader;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.BlockManager;
import org.eclipse.birt.core.archive.compound.BlockManagerEventAdapter;
import org.eclipse.birt.core.archive.compound.EntryTable;

public class ArchiveFile {
    protected RandomAccessFile rf;
    protected boolean isWritable;
    protected boolean isTransient;
    protected boolean isAppend;
    protected String archiveName;
    protected ArchiveHeader head;
    protected AllocationTable allocTbl;
    protected EntryTable entryTbl;
    protected HashMap entries;
    protected BlockManager caches;
    protected int totalBlocks;
    private boolean enableCache = true;
    private boolean useNativeLock = false;

    private void setupArchiveMode(String mode) throws IOException {
        if ("r".equals(mode)) {
            this.isWritable = false;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw+".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = true;
        } else if ("rwt".equals(mode)) {
            this.isWritable = true;
            this.isTransient = true;
            this.isAppend = true;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public ArchiveFile(String fileName, String mode) throws IOException {
        this.archiveName = fileName;
        this.setupArchiveMode(mode);
        this.caches = new BlockManager(new CacheEventAdapter());
        if (this.isWritable && !this.isAppend) {
            this.createDocument();
        } else {
            this.openDocument();
        }
    }

    public void setCacheSize(int cacheSize) {
        int blockCount = (cacheSize + 4096 - 1) / 4096;
        this.caches.setCacheSize(blockCount);
    }

    private void openDocument() throws IOException {
        try {
            this.rf = !this.isWritable && !this.useNativeLock ? new RandomAccessFile(this.archiveName, "r") : new RandomAccessFile(this.archiveName, "rw");
            this.totalBlocks = (int)((this.rf.length() + 4096L - 1L) / 4096L);
            this.head = ArchiveHeader.loadHeader(this);
            this.allocTbl = AllocationTable.loadTable(this);
            this.entryTbl = EntryTable.loadTable(this);
            this.entries = new HashMap();
            Iterator iter = this.entryTbl.listEntries().iterator();
            while (iter.hasNext()) {
                EntryTable.Entry nameEnt = (EntryTable.Entry)iter.next();
                this.entries.put(nameEnt.getName(), new ArchiveEntry(this, nameEnt));
            }
        }
        catch (IOException ex) {
            this.rf.close();
            throw ex;
        }
    }

    private void createDocument() throws IOException {
        if (!this.isTransient) {
            this.rf = new RandomAccessFile(this.archiveName, "rw");
            this.rf.setLength(12288L);
        }
        this.totalBlocks = 3;
        this.head = ArchiveHeader.createHeader(this);
        this.allocTbl = AllocationTable.createTable(this);
        this.entryTbl = EntryTable.createTable(this);
        this.entries = new HashMap();
    }

    public String getName() {
        return this.archiveName;
    }

    public void close() throws IOException {
        if (this.isWritable && !this.isTransient) {
            this.flush();
        }
        if (this.rf != null) {
            this.rf.close();
        }
        if (this.isTransient) {
            new File(this.archiveName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String fileName) throws IOException {
        ArchiveFile file = new ArchiveFile(fileName, "rw");
        try {
            List entries = this.listEntries("/");
            ListIterator iter = entries.listIterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                ArchiveEntry tgt = file.createEntry(name);
                ArchiveEntry src = this.getEntry(name);
                this.copyEntry(src, tgt);
            }
        }
        finally {
            file.close();
        }
    }

    private void copyEntry(ArchiveEntry src, ArchiveEntry tgt) throws IOException {
        int size;
        byte[] b = new byte[4096];
        long length = src.getLength();
        for (long pos = 0L; pos < length; pos += (long)size) {
            size = src.read(pos, b, 0, 4096);
            tgt.write(pos, b, 0, size);
        }
    }

    public synchronized void flush() throws IOException {
        this.checkWritable();
        if (!this.isTransient) {
            this.caches.flush();
        }
    }

    public synchronized void refresh() throws IOException {
    }

    public synchronized boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    public synchronized ArchiveEntry getEntry(String name) throws IOException {
        return (ArchiveEntry)this.entries.get(name);
    }

    public synchronized List listEntries(String namePattern) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = this.entries.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        this.checkWritable();
        ArchiveEntry entry = (ArchiveEntry)this.entries.get(name);
        if (entry != null) {
            entry.setLength(0L);
            return entry;
        }
        EntryTable.Entry nameEnt = this.entryTbl.createEntry(name);
        entry = new ArchiveEntry(this, nameEnt);
        this.entries.put(name, entry);
        return entry;
    }

    public synchronized boolean removeEntry(String name) throws IOException {
        this.checkWritable();
        ArchiveEntry entry = (ArchiveEntry)this.entries.get(name);
        if (entry != null) {
            this.entries.remove(name);
            EntryTable.Entry nameEnt = this.entryTbl.findEntry(name);
            this.entryTbl.removeEntry(nameEnt);
            int blockId = nameEnt.getBlock();
            if (blockId != -1) {
                AllocationTable.Entry allEnt = this.allocTbl.loadEntry(blockId);
                this.allocTbl.removeEntry(allEnt);
            }
            return true;
        }
        return false;
    }

    Object lockEntry(ArchiveEntry entry) throws IOException {
        if (this.useNativeLock && !this.isTransient) {
            entry.ensureSize(1L);
            int blockId = entry.index.getBlock(0);
            return this.rf.getChannel().lock(blockId * 4096, 1L, false);
        }
        return entry;
    }

    void unlockEntry(Object locker) throws IOException {
        if (locker instanceof FileLock) {
            FileLock flck = (FileLock)locker;
            flck.release();
        }
        if (!(locker instanceof ArchiveEntry)) {
            throw new IOException("Invalide lock type:" + locker);
        }
    }

    int getTotalBlocks() throws IOException {
        return this.totalBlocks;
    }

    int allocateBlock() throws IOException {
        this.checkWritable();
        int blockId = this.totalBlocks++;
        if (!this.isTransient) {
            this.rf.setLength(this.totalBlocks * 4096);
        }
        return blockId;
    }

    private void checkWritable() throws IOException {
        if (!this.isWritable) {
            throw new IOException("Archive must be opend for write");
        }
    }

    synchronized void read(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        if (this.enableCache) {
            Block block = this.caches.getBlock(blockId);
            block.read(blockOff, b, off, len);
        } else {
            long pos = blockId * 4096 + blockOff;
            this.rf.seek(pos);
            this.rf.readFully(b, off, len);
        }
    }

    synchronized void write(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        this.checkWritable();
        if (this.enableCache) {
            Block block = this.caches.getBlock(blockId);
            block.write(blockOff, b, off, len);
        } else {
            long pos = blockId * 4096 + blockOff;
            this.rf.seek(pos);
            this.rf.write(b, off, len);
        }
    }

    class CacheEventAdapter
    extends BlockManagerEventAdapter {
        CacheEventAdapter() {
        }

        public void flush(Block block) throws IOException {
            if (ArchiveFile.this.isWritable) {
                if (ArchiveFile.this.rf == null) {
                    ArchiveFile.this.rf = new RandomAccessFile(ArchiveFile.this.archiveName, "rw");
                    ArchiveFile.this.rf.setLength(0L);
                }
                block.flush(ArchiveFile.this.rf);
            }
        }

        public void refresh(Block block) throws IOException {
            if (block.id < ArchiveFile.this.totalBlocks) {
                block.refresh(ArchiveFile.this.rf);
            }
        }
    }
}

