/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.interfaces.EnumeratedResponse;
import org.eclipse.aperi.interfaces.IDiscover;

public class JobMonitor
implements Runnable {
    private static IDiscover discoverProxy = null;
    private static JobMonitor jobMonitor;
    private static Thread runner;
    private static ArrayList<String> jobsToMonitor;
    private boolean shutdown = false;
    private static final int SCAN_PERIOD = 60000;

    static {
        runner = null;
        jobsToMonitor = new ArrayList();
    }

    private JobMonitor() {
        if (discoverProxy == null) {
            discoverProxy = (IDiscover)DiscoveryActivator._serviceHelper.bindLocal("DiscoverService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobMonitor getJobMonitor() {
        Class<?> clazz;
        if (jobMonitor != null) return jobMonitor;
        try {
            clazz = Class.forName("org.eclipse.aperi.JobMonitor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (jobMonitor != null) return jobMonitor;
            jobMonitor = new JobMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jobMonitor;
        }
    }

    public synchronized void monitor(String string) {
        if (this.shutdown) {
            return;
        }
        jobsToMonitor.add(string);
        if (runner == null) {
            runner = new Thread(this);
            runner.setName("JobMonitor");
            runner.start();
        }
    }

    public synchronized boolean isMonitored(String string) {
        return jobsToMonitor.contains(string);
    }

    public synchronized void run() {
        int n = 0;
        while (!jobsToMonitor.isEmpty() && !this.shutdown) {
            ++n;
            Iterator<String> iterator = jobsToMonitor.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (DiscoverUtils.isJobComplete(string)) {
                    ServiceUtils.getJobStatus((String)string);
                    iterator.remove();
                    System.out.println("JobMonitor released ID=" + string);
                    continue;
                }
                if (n % 10 != 0) continue;
                this.clearEnumeratedResponse(string);
            }
            try {
                if (jobsToMonitor.isEmpty() || this.shutdown) continue;
                this.wait(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        runner = null;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    private void clearEnumeratedResponse(String string) {
        AsyncResult asyncResult;
        Object v = ServiceUtils.activeJobs.get(string);
        if (v != null && v instanceof AsyncResult && (asyncResult = (AsyncResult)v).getResults() != null && asyncResult.getResults().length > 0 && asyncResult.getResults()[0] instanceof EnumeratedResponse) {
            ((EnumeratedResponse)asyncResult.getResults()[0]).close();
            System.out.println("JobMonitor closed EnumeratedResponse for ID=" + string);
        }
    }
}

