/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.DiscoverRequest;

public class DiscoverUtils {
    public static Hashtable parseParameters(String[] stringArray, DiscoverRequest discoverRequest) throws Exception {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        int n = 1;
        while (n < stringArray.length) {
            Object object;
            Object[] objectArray;
            Class[] classArray;
            System.out.println(stringArray[n]);
            int n2 = stringArray[n].indexOf(61);
            if (n2 == -1) {
                throw new Exception("Invalid parameter format");
            }
            String string = stringArray[n].substring(0, n2).trim();
            String string2 = stringArray[n].substring(n2 + 1).trim();
            String string3 = discoverRequest.getParameterType(string);
            if (string3 == null) {
                throw new Exception("Parameter " + string + " is not a parameter for this request.");
            }
            Class<?> clazz = Class.forName(string3);
            if (string3.equals("[Ljava.lang.String;")) {
                classArray = new StringTokenizer(string2, ",");
                objectArray = new ArrayList();
                while (classArray.hasMoreTokens()) {
                    object = (String[])classArray.nextElement();
                    objectArray.add(object);
                }
                object = objectArray.toArray(new String[0]);
                hashtable.put(string, (String[])object);
            } else {
                Class<?> clazz2;
                Class[] classArray2 = new Class[1];
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray2[0] = clazz2;
                classArray = classArray2;
                objectArray = new Object[]{string2};
                object = clazz.getConstructor(classArray).newInstance(objectArray);
                hashtable.put(string, (String[])object);
            }
            ++n;
        }
        return hashtable;
    }

    public static final Map setProbeTimeout(Map map, long l, LogTraceHelper logTraceHelper) {
        try {
            String[] stringArray = (String[])map.get("CIMOM");
            if (stringArray == null) {
                logTraceHelper.traceWarning("Error setting probe timeout to " + l + ". No target.");
                return map;
            }
            if (stringArray.length < 5) {
                String[] stringArray2 = new String[5];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray = stringArray2;
            }
            if (l > 0L) {
                stringArray[4] = "" + l;
                logTraceHelper.traceHigh("Set probe timeout to " + l);
            } else {
                stringArray[4] = null;
                logTraceHelper.traceHigh("Set probe timeout to default");
            }
            map.put("CIMOM", stringArray);
            return map;
        }
        catch (Exception exception) {
            logTraceHelper.traceError("Error setting probe timeout to " + l, (Throwable)exception);
            return map;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AsyncResult waitForJobToComplete(String string) {
        AsyncResult asyncResult = null;
        Object v = ServiceUtils.activeJobs.get(string);
        if (v != null) {
            if (v instanceof JobInfo) {
                ControlEngine controlEngine = ControlEngine.getInstance();
                asyncResult = controlEngine.waitForJobToComplete(string);
                ServiceUtils.completedJobResults.remove(string);
                return asyncResult;
            }
            System.err.println("Waiting for job completion of " + string + " because it is active but not control job");
            Router.getRouter().waitForJobToComplete(string);
            System.err.println("Job " + string + " completed");
            return ServiceUtils.getJobStatus((String)string);
        }
        asyncResult = (AsyncResult)ServiceUtils.completedJobResults.get(string);
        if (asyncResult != null) {
            ServiceUtils.completedJobResults.remove(string);
            JobEngine.getInstance().cleanupRequestInformation(string);
            return asyncResult;
        }
        Router.getRouter().waitForJobToComplete(string);
        return ServiceUtils.getJobStatus((String)string);
    }

    public static AsyncResult cancelJob(String string) {
        Object v = ServiceUtils.activeJobs.get(string);
        if (v != null) {
            if (v instanceof JobInfo) {
                ControlEngine controlEngine = ControlEngine.getInstance();
                controlEngine.cancelJob(string);
            } else if (v instanceof AsyncResult) {
                Router.getRouter().cancel(string);
            }
        } else {
            Router.getRouter().cancel(string);
        }
        return ServiceUtils.getJobStatus((String)string);
    }

    public static boolean isJobCanceled(String string) {
        return Router.getRouter().isJobCanceled(string);
    }

    public static boolean isJobComplete(String string) {
        return Router.getRouter().isJobComplete(string);
    }
}

