/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Map;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class ProcessProcessor
extends Thread {
    public static String queueName = "Processes";
    private boolean shutdown = false;
    Thread thread = null;

    public ProcessProcessor() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    public void run() {
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            try {
                if (Configuration.debug) {
                    System.out.println(String.valueOf(queueName) + ": waiting for a job");
                }
                JobInfo jobInfo = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (jobInfo == null) {
                    System.out.println(String.valueOf(queueName) + ":Error - got a NULL job from the queue");
                    continue;
                }
                try {
                    Object[] objectArray = (Object[])jobInfo.getRequest().getData();
                    if (Configuration.debug) {
                        System.out.println(String.valueOf(queueName) + ": invoking " + objectArray);
                    }
                    String[] stringArray = Router.getRouter().perform((String)objectArray[0], (Map)objectArray[1], jobInfo.getDiscoverRequest());
                    jobInfo.setResponse((Response)new ObjectResponse(stringArray, jobInfo));
                    jobInfo.setReturnCode(0);
                    jobInfo.complete(true);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    jobInfo.setReturnCode(103);
                    jobInfo.complete(false);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

