/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.Constants;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DESaxParser
extends DefaultHandler
implements ErrorHandler {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private String charDataBuffer;
    private short currentLevel = 0;
    private String sectionUniqueID;
    private String currentSection = null;
    private Processor processor = null;
    private Hashtable entityTable = new Hashtable();
    private String paramName = null;
    private boolean isConnectivityXml = false;
    private JobInfo job = null;
    private ILogger jobLogger = null;
    private Request request = null;

    static {
        Class<?> clazz;
        msgLogger = TSANMLegacyParser.msgLogger;
        traceLogger = TSANMLegacyParser.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.DESaxParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public DESaxParser(Processor processor, JobInfo jobInfo) {
        this.processor = processor;
        this.job = jobInfo;
        this.request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
        if (this.request != null) {
            this.jobLogger = this.request.getJobLogger();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = "startElement()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        if (this.currentLevel == 0 || this.currentLevel == 1) {
            this.currentLevel = (short)(this.currentLevel + 1);
            this.currentSection = string3;
        } else if (this.currentLevel == 2 || this.currentLevel == 3) {
            if (string3.equalsIgnoreCase("ConnectivityGroupXml")) {
                this.isConnectivityXml = true;
            }
            this.currentLevel = (short)(this.currentLevel + 1);
        }
        if (traceLogger.isLogging()) {
            String string5 = "qualifiedName = " + string3 + "\tcurrentLevel = " + this.currentLevel;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, string5);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = "characters()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.charDataBuffer = this.charDataBuffer == null ? new String(cArray, n, n2) : new String(String.valueOf(this.charDataBuffer) + new String(cArray, n, n2));
        if (traceLogger.isLogging()) {
            String string2 = "charDataBuffer = " + (this.charDataBuffer == null ? null : this.charDataBuffer);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, string2);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = "endElement()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string5);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXException("Discover Engine shutdown detected.");
        }
        if (this.currentSection.equalsIgnoreCase("SolarisStorageAutomationHost")) {
            this.currentLevel = (short)(this.currentLevel - 1);
            if (traceLogger.isLogging()) {
                String string6 = "Skipping tag, SolarisStorageAutomationHost";
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string6);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
            }
            return;
        }
        if (this.currentLevel == 4) {
            if (string3.equalsIgnoreCase("NameXml")) {
                this.paramName = this.charDataBuffer;
                this.charDataBuffer = null;
                if (traceLogger.isLogging()) {
                    string4 = "currentLevel = " + this.currentLevel + "\t" + string3 + " = " + this.paramName;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                }
            } else if (string3.equalsIgnoreCase("ValueXml")) {
                if (traceLogger.isLogging()) {
                    string4 = "currentLevel = " + this.currentLevel + "\t" + string3 + " = " + this.charDataBuffer;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                }
                if (this.charDataBuffer != null) {
                    this.entityTable.put(this.paramName, this.charDataBuffer);
                }
                this.charDataBuffer = null;
                this.paramName = null;
            } else if (this.isConnectivityXml && !string3.equalsIgnoreCase("ParameterXml")) {
                if (traceLogger.isLogging()) {
                    string4 = "currentLevel = " + this.currentLevel + "\t Processing ConnectivityGroupXml";
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                    string4 = "sectionUniqueID = " + this.sectionUniqueID + "\t" + "ConnectivityGroupXml" + string3 + "\tvalue = " + this.charDataBuffer;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                }
                if (!this.entityTable.isEmpty()) {
                    this.processEntityData();
                }
                this.processRelationshipData(this.sectionUniqueID, "ConnectivityGroupXml" + string3, this.charDataBuffer);
                this.charDataBuffer = null;
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 3) {
            if (!string3.equalsIgnoreCase("ParameterXml")) {
                if (string3.equalsIgnoreCase("UniqueIdXml") || string3.equalsIgnoreCase("DeltaXml")) {
                    if (traceLogger.isLogging()) {
                        string4 = "currentLevel = " + this.currentLevel + "\t" + string3 + " = " + (this.charDataBuffer == null ? null : this.charDataBuffer);
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                    }
                    if (this.charDataBuffer == null) {
                        string4 = "null uniqueID in section " + this.currentSection;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string5, string4);
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
                        }
                        throw new SAXException(string4);
                    }
                    this.sectionUniqueID = this.charDataBuffer;
                    this.entityTable.put(string3, new String(this.charDataBuffer));
                    this.charDataBuffer = null;
                } else if (string3.equalsIgnoreCase("ConnectivityGroupXml")) {
                    if (traceLogger.isLogging()) {
                        string4 = "Processing " + string3;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
                    }
                    if (!this.entityTable.isEmpty()) {
                        this.processEntityData();
                    }
                    this.isConnectivityXml = false;
                } else {
                    if (!this.entityTable.isEmpty()) {
                        this.processEntityData();
                    }
                    if (this.charDataBuffer == null) {
                        String string7 = "null uniqueID for tag " + string3 + " in section " + this.currentSection;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string5, string7);
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
                        }
                        throw new SAXException(string7);
                    }
                    this.processRelationshipData(this.sectionUniqueID, string3, this.charDataBuffer);
                    this.charDataBuffer = null;
                }
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 2) {
            if (traceLogger.isLogging()) {
                string4 = "currentLevel = " + this.currentLevel + "\t qName = " + string3;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string5, string4);
            }
            if (this.currentSection.equalsIgnoreCase("DeltaXml")) {
                if (this.charDataBuffer != null) {
                    this.entityTable.put(string3, this.charDataBuffer);
                }
                this.charDataBuffer = null;
            } else if (!this.entityTable.isEmpty()) {
                this.processEntityData();
            }
            this.currentLevel = (short)(this.currentLevel - 1);
        } else if (this.currentLevel == 1) {
            // empty if block
        }
        if (traceLogger.isLogging()) {
            string4 = "currentLevel = " + this.currentLevel;
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string5, string4);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string5);
        }
    }

    private void processEntityData() {
        String string = "processEntityData()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.entityTable.isEmpty()) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "entityTable is empty");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return;
        }
        if (!this.currentSection.equalsIgnoreCase("HeaderXml")) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Content of entityTable:");
                Enumeration enumeration = this.entityTable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)this.entityTable.get(string2);
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, String.valueOf(string2) + " = " + string3);
                }
            }
            try {
                this.processor.handleEntity(this.job, this.currentSection, this.entityTable);
            }
            catch (Exception exception) {
                if (this.jobLogger != null) {
                    this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, string, "DESaxParserParserJob_PersistError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), exception.getMessage()});
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                this.job.setSuccessful(false);
            }
            this.entityTable.clear();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void processRelationshipData(String string, String string2, String string3) {
        String string4 = "processRelationshipData()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        if (this.entityTable != null) {
            this.entityTable.clear();
        }
        this.entityTable.put("FromUniqueIdXml", string);
        this.entityTable.put("ToUniqueIdXml", string3);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "Content of the entityTable:");
            Enumeration enumeration = this.entityTable.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                String string6 = (String)this.entityTable.get(string5);
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, String.valueOf(string5) + " = " + string6);
            }
        }
        try {
            this.processor.handleEntity(this.job, String.valueOf(this.currentSection) + "2" + string2, this.entityTable);
        }
        catch (Exception exception) {
            if (this.jobLogger != null) {
                this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, string4, "DESaxParserParserJob_PersistError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), exception.getMessage()});
            }
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)exception);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)exception);
        }
        this.entityTable.clear();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    private String getScannerId(String string) {
        int n = string.indexOf(58);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Constants.SCANNERS.get(string2) + string3;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = "warning";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_WARNING, (Object)className, string, "DESaxParserParserJob_Warning", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(sAXParseException)});
        }
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = "error";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_ERROR, (Object)className, string, "DESaxParserParserJob_Error", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(sAXParseException)});
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        }
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = "fatalError";
        if (this.jobLogger != null) {
            this.jobLogger.message(IRecordType.TYPE_FATAL, (Object)className, string, "DESaxParserParserJob_FatalError", (Object[])new String[]{this.request.getDeviceServerRunNumber(), String.valueOf(this.request.getId()), this.GetErrorString(sAXParseException)});
        }
        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        if (traceLogger.isLogging()) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sAXParseException);
        }
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    private String GetErrorString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer("Line: ");
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append("\nMessage: ");
        stringBuffer.append(sAXParseException.getMessage());
        return stringBuffer.toString();
    }
}

