/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.EntityPersistWrapper;
import org.eclipse.aperi.discovery.parser.PersistWrapper;
import org.eclipse.aperi.discovery.parser.RelationshipPersistWrapper;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityResult;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public abstract class GenericProcessor {
    private String scannerId = null;
    protected DBConnection connection = null;
    protected MapperRouter mapperRouter = MapperRouter.getMapperRouter();
    protected ChangeDetection changeDetection = null;
    protected String sourceType = null;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    protected static String className;
    protected static int numOperationsPerTransaction;
    private static final int DEFAULT_NUM_OPERATIONS_PER_TRANSACTION = 1;
    private static final String PROPERTY_NUM_OPS_PER_TRANSACTION = "NumOperationsPerTransaction";
    private static final String PROPERTY_GROUP = "DiscoverService";
    private static final int MaxNumRetries = 20;
    private static IEventMonitorService eventMonitor;
    private static IConfigService configServiceProxy;
    protected static String discoverEventPrefix;
    protected Hashtable newEntities = new Hashtable();
    protected Hashtable modifiedEntities = new Hashtable();
    protected List history = new ArrayList();

    static {
        Class<?> clazz;
        msgLogger = TSANMLegacyParser.msgLogger;
        traceLogger = TSANMLegacyParser.traceLogger;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.parser.Processor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        numOperationsPerTransaction = 0;
        eventMonitor = null;
        configServiceProxy = null;
        discoverEventPrefix = "D";
    }

    public GenericProcessor(String string) {
        this.sourceType = string;
        try {
            DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
            this.connection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
            this.changeDetection = new ChangeDetection(this.connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)DiscoveryActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    public static int getNumberOfOperationsPerTransaction() {
        String string = "getNumberOfOperationsPerTransaction";
        if (numOperationsPerTransaction <= 0) {
            try {
                numOperationsPerTransaction = Integer.parseInt(GenericProcessor.getConfigServiceProxy().getProperty(PROPERTY_NUM_OPS_PER_TRANSACTION, PROPERTY_GROUP));
            }
            catch (Exception exception) {}
            if (numOperationsPerTransaction <= 0) {
                numOperationsPerTransaction = 1;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Number of Operations per Transaction is " + numOperationsPerTransaction);
            }
        }
        return numOperationsPerTransaction;
    }

    public static MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, IDBAttributeMapper iDBAttributeMapper2, Hashtable hashtable2, IDBAttributeMapper iDBAttributeMapper3, Hashtable hashtable3, String string, List list, String string2, Hashtable hashtable4, Hashtable hashtable5) throws SQLException {
        MapperResult mapperResult = null;
        try {
            list.add(new RelationshipPersistWrapper(iDBAttributeMapper, (Hashtable)hashtable.clone(), iDBAttributeMapper2, (Hashtable)hashtable2.clone(), iDBAttributeMapper3, (Hashtable)hashtable3.clone(), string));
            mapperResult = iDBAttributeMapper.persist(dBConnection, iDBAttributeMapper2, (Hashtable)hashtable2.clone(), iDBAttributeMapper3, (Hashtable)hashtable3.clone(), string);
            AlertProcessor.processAlerts(string2, mapperResult, hashtable4, hashtable5);
            if (list.size() > GenericProcessor.getNumberOfOperationsPerTransaction()) {
                dBConnection.commit();
                list.clear();
            }
        }
        catch (SQLException sQLException) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                mapperResult = GenericProcessor.retryPersist(dBConnection, list);
                AlertProcessor.processAlerts(string2, mapperResult, hashtable4, hashtable5);
                dBConnection.commit();
                list.clear();
            }
            throw sQLException;
        }
        return mapperResult;
    }

    public static MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, String string, List list, String string2, Hashtable hashtable2, Hashtable hashtable3) throws SQLException {
        MapperResult mapperResult = null;
        try {
            list.add(new EntityPersistWrapper(iDBAttributeMapper, (Hashtable)hashtable.clone(), string));
            mapperResult = iDBAttributeMapper.persist(dBConnection, (Hashtable)hashtable.clone(), string);
            AlertProcessor.processAlerts(string2, mapperResult, hashtable2, hashtable3);
            if (list.size() > GenericProcessor.getNumberOfOperationsPerTransaction()) {
                dBConnection.commit();
                list.clear();
            }
        }
        catch (SQLException sQLException) {
            if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                mapperResult = GenericProcessor.retryPersist(dBConnection, list);
                AlertProcessor.processAlerts(string2, mapperResult, hashtable2, hashtable3);
                dBConnection.commit();
                list.clear();
            }
            throw sQLException;
        }
        return mapperResult;
    }

    protected static MapperResult retryPersist(DBConnection dBConnection, List list) throws SQLException {
        String string = "persist";
        boolean bl = false;
        int n = 0;
        Random random = new Random();
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Deadlock encountered - retrying " + list.size() + " operations.");
        }
        while (true) {
            try {
                MapperResult mapperResult = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PersistWrapper persistWrapper;
                    Object e = iterator.next();
                    if (e instanceof RelationshipPersistWrapper) {
                        persistWrapper = (RelationshipPersistWrapper)e;
                        mapperResult = ((RelationshipPersistWrapper)persistWrapper).getInvoker().persist(dBConnection, ((RelationshipPersistWrapper)persistWrapper).getEntity1(), (Hashtable)((RelationshipPersistWrapper)persistWrapper).getEntity1_htValues().clone(), ((RelationshipPersistWrapper)persistWrapper).getEntity2(), (Hashtable)((RelationshipPersistWrapper)persistWrapper).getEntity2_htValues().clone(), ((RelationshipPersistWrapper)persistWrapper).getScanID());
                        continue;
                    }
                    if (e instanceof EntityPersistWrapper) {
                        persistWrapper = (EntityPersistWrapper)e;
                        mapperResult = ((EntityPersistWrapper)persistWrapper).getEntity().persist(dBConnection, (Hashtable)((EntityPersistWrapper)persistWrapper).getEntity_htValues().clone(), ((EntityPersistWrapper)persistWrapper).getScanID());
                        continue;
                    }
                    System.out.println("Unrecognized PersistWrapper type");
                }
                bl = false;
                return mapperResult;
            }
            catch (SQLException sQLException) {
                if (SQLExceptionHelper.isDeadlock((DBConnection)dBConnection, (SQLException)sQLException)) {
                    dBConnection.rollback();
                    if (++n <= 20) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Deadlock within Retry of Operations - Retry " + n + " after deadlock");
                        } else {
                            System.out.println(String.valueOf(className) + " " + string + " Retry " + n + "after deadlock");
                        }
                        bl = true;
                        long l = (long)(15000.0 * random.nextDouble() * (double)n);
                        if (l < 100L) {
                            l = 100L;
                        }
                        try {
                            Thread.sleep(l);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        continue;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Number of Retries exceeded; aborting with SQLException");
                    }
                    throw sQLException;
                }
                throw sQLException;
                if (bl) continue;
                return null;
            }
            break;
        }
    }

    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.connection = null;
        }
    }

    public boolean start(int n) {
        block4: {
            String string = "start";
            Request request = Router.getRouter().getRequest(new Integer(n).toString());
            if (request != null) {
                Request request2 = request.getParentRequest();
                if (!(request.getScannerId() == null || request2 != null && request2.getScannerId() != null && request2.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityService.startDiscovery((String)request.getScannerId(), (int)request.getAuthoritativeReferenceType(), (int)request.getAuthoritativeReferenceId(), (String)(String.valueOf(discoverEventPrefix) + request.getId()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block4;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
        }
        return true;
    }

    public void finish() {
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void end(int n) {
        String string = "end";
        try {
            this.connection.commit();
            this.history.clear();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        Request request = Router.getRouter().getRequest(new Integer(n).toString());
        if (request != null) {
            block16: {
                Request request2 = request.getParentRequest();
                if (!(request.getScannerId() == null || request2 != null && request2.getScannerId() != null && request2.getScannerId().equals(request.getScannerId()))) {
                    try {
                        DetectabilityResult detectabilityResult = DetectabilityService.stopDiscovery((String)request.getScannerId());
                        if (detectabilityResult.modifiedEntities != null) {
                            Iterator iterator = detectabilityResult.modifiedEntities.keySet().iterator();
                            while (iterator.hasNext()) {
                                String string2 = (String)iterator.next();
                                List list = (List)detectabilityResult.modifiedEntities.get(string2);
                                if (list == null) continue;
                                List list2 = (List)this.modifiedEntities.get(string2);
                                if (list2 == null) {
                                    this.modifiedEntities.put(string2, list);
                                    continue;
                                }
                                list2.addAll(list);
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block16;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.changeDetection.startNew(this.connection, (Map)this.newEntities);
            this.newEntities.clear();
            try {
                this.changeDetection.complete(this.connection, (Map)this.modifiedEntities, String.valueOf(discoverEventPrefix) + new Integer(n).toString());
                this.modifiedEntities.clear();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            GenericProcessor.getEventMonitorProxy().handleModelUpdate(String.valueOf(discoverEventPrefix) + new Integer(n).toString());
        } else {
            System.out.println("Process.end - unable to find request for " + n);
        }
    }

    protected String getScanID(JobInfo jobInfo) {
        Request request = Router.getRouter().getRequest(jobInfo.getDiscoverRequest());
        if (request != null) {
            return request.getScannerId();
        }
        return null;
    }
}

