/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.service.http.HttpContext;

public class ResourceRegistration
extends Registration {
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String internalName;
    HttpContext httpContext;
    ServletContext servletContext;
    private AccessControlContext acc;

    public ResourceRegistration(String string, HttpContext httpContext, ServletContext servletContext, AccessControlContext accessControlContext) {
        this.internalName = string;
        if (string.equals("/")) {
            this.internalName = "";
        }
        this.httpContext = httpContext;
        this.servletContext = servletContext;
        this.acc = accessControlContext;
    }

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        if (this.httpContext.handleSecurity(httpServletRequest, httpServletResponse)) {
            String string2 = httpServletRequest.getMethod();
            if (string2.equals("GET") || string2.equals("POST") || string2.equals("HEAD")) {
                String string3 = HttpServletRequestAdaptor.getDispatchPathInfo(httpServletRequest);
                int n = string.equals("/") ? 0 : string.length();
                String string4 = String.valueOf(this.internalName) + string3.substring(n);
                URL uRL = this.httpContext.getResource(string4);
                if (uRL == null || string4.endsWith("/")) {
                    return false;
                }
                return this.writeResource(httpServletRequest, httpServletResponse, string4);
            }
            httpServletResponse.setStatus(405);
        }
        return true;
    }

    private boolean writeResource(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse, final String string) throws IOException {
        Boolean bl = Boolean.TRUE;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string4;
                    String string2;
                    URL uRL = ResourceRegistration.this.httpContext.getResource(string);
                    if (uRL == null) {
                        return Boolean.FALSE;
                    }
                    URLConnection uRLConnection = uRL.openConnection();
                    long l = uRLConnection.getLastModified();
                    int n = uRLConnection.getContentLength();
                    if (n <= 0) {
                        return Boolean.FALSE;
                    }
                    String string3 = null;
                    if (l != -1L && n != -1) {
                        string3 = "W/\"" + n + "-" + l + "\"";
                    }
                    if ((string2 = httpServletRequest.getHeader(ResourceRegistration.IF_NONE_MATCH)) != null && string3 != null && string2.indexOf(string3) != -1) {
                        httpServletResponse.setStatus(304);
                        return Boolean.TRUE;
                    }
                    long l2 = httpServletRequest.getDateHeader(ResourceRegistration.IF_MODIFIED_SINCE);
                    if (l2 > -1L && l > 0L && l <= l2 + 999L) {
                        httpServletResponse.setStatus(304);
                        return Boolean.TRUE;
                    }
                    if (n != -1) {
                        httpServletResponse.setContentLength(n);
                    }
                    if ((string4 = ResourceRegistration.this.httpContext.getMimeType(string)) == null) {
                        string4 = ResourceRegistration.this.servletContext.getMimeType(string);
                    }
                    if (string4 != null) {
                        httpServletResponse.setContentType(string4);
                    }
                    if (l > 0L) {
                        httpServletResponse.setDateHeader(ResourceRegistration.LAST_MODIFIED, l);
                    }
                    if (string3 != null) {
                        httpServletResponse.setHeader(ResourceRegistration.ETAG, string3);
                    }
                    try {
                        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                        int n2 = ResourceRegistration.this.writeResourceToOutputStream(uRLConnection, (OutputStream)servletOutputStream);
                        if (n == -1 || n != n2) {
                            httpServletResponse.setContentLength(n2);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        PrintWriter printWriter = httpServletResponse.getWriter();
                        ResourceRegistration.this.writeResourceToWriter(uRLConnection, printWriter);
                    }
                    return Boolean.TRUE;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return bl;
    }

    int writeResourceToOutputStream(URLConnection uRLConnection, OutputStream outputStream) throws IOException {
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n2 += n;
                n = inputStream.read(byArray);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    void writeResourceToWriter(URLConnection uRLConnection, Writer writer) throws IOException {
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            try {
                char[] cArray = new char[8192];
                int n = inputStreamReader.read(cArray);
                while (n != -1) {
                    writer.write(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            finally {
                if (inputStreamReader != null) {
                    ((Reader)inputStreamReader).close();
                    inputStream = null;
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

