/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpMetaPDU;

public class SnmpPDU
extends SnmpMetaPDU {
    public static final int NOERROR = 0;
    public static final int TOOBIG = 1;
    public static final int NOSUCHNAME = 2;
    public static final int BADVALUE = 3;
    public static final int READONLY = 4;
    public static final int GENERR = 5;
    public static final int NO_ACCESS = 6;
    public static final int WRONG_TYPE = 7;
    public static final int WRONG_LENGTH = 8;
    public static final int WRONG_ENCODING = 9;
    public static final int WRONG_VALUE = 10;
    public static final int NO_CREATION = 11;
    public static final int INCONSIST_VAL = 12;
    public static final int RESOURCE_UNAVAIL = 13;
    public static final int COMMIT_FAIL = 14;
    public static final int UNDO_FAIL = 15;
    public static final int AUTH_ERR = 16;
    public static final int NOT_WRITEABLE = 17;
    public static final int INCONSIS_NAME = 18;
    public static final int TIMEOUT = 100;
    public static final int SENDERROR = 101;
    public static final int SESSIONWHACKED = 102;
    public static final int DECODEERROR = 103;
    public static final String[] errorStatusString = new String[]{"Success", "Response PDU too big", "Variable does not exist", "Cannot modify variable, bad value", "Cannot modify object, read only", "Cannot perform operation, general error", "Cannot access variable, no access", "Cannot create/set variable, wrong type", "Cannot create/set variable, wrong length", "Cannot create/set variable, wrong encoding", "Cannot create/set variable, wrong value", "Cannot create variable, creation not allowed", "Cannot create/set variable, inconsistent value", "Cannot create/set variable, resource unavailable", "Cannot create/set variable, commit failed", "Cannot create/set variable, undo failed", "Cannot perform operation, authentication error", "Cannot create/set variable, not writeable", "Cannot create variable, inconsistent name"};
    public static final int GET = 0;
    public static final int GETNEXT = 1;
    public static final int GETRESPONSE = 2;
    public static final int RESPONSE = 2;
    public static final int SET = 3;
    public static final int GETBULK = 4;
    public static final int INFORM = 5;
    public static final int V2_TRAP = 6;
    public static final int REPORT = 7;
    public static final String[] operationString = new String[]{"GET", "GETNEXT", "RESPONSE", "SET", "GETBULK", "INFORM", "V2 TRAP", "REPORT"};
    public int requestId;
    public int errorStatus;
    public int errorIndex;
    public int operation;
    public int correlator;
    public int requestIdPos;

    public int getCorrelatorValue() {
        return this.requestId;
    }

    public SnmpPDU() {
        this.requestId = 0;
        this.errorStatus = 0;
        this.errorIndex = 0;
        this.operation = 0;
    }

    public Object clone() {
        return new SnmpPDU(this);
    }

    public SnmpPDU(SnmpPDU snmpPDU) {
        super(snmpPDU);
        this.requestId = snmpPDU.requestId;
        this.errorStatus = snmpPDU.errorStatus;
        this.errorIndex = snmpPDU.errorIndex;
        this.operation = snmpPDU.operation;
    }

    public SnmpPDU(int n, int n2, String string, int n3, Vector vector) {
        super(n2, string, vector);
        this.requestId = n;
        this.errorStatus = 0;
        this.errorIndex = 0;
        this.operation = n3;
    }

    public int get_error_status() {
        return this.errorStatus;
    }

    public void set_error_status(int n) {
        this.errorStatus = n;
    }

    public int get_error_index() {
        return this.errorIndex;
    }

    public void set_error_index(int n) {
        this.errorIndex = n;
    }

    public void clear_error_status() {
        this.errorStatus = 0;
    }

    public void clear_error_index() {
        this.errorIndex = 0;
    }

    public int get_request_id() {
        return this.requestId;
    }

    public void set_request_id(int n) {
        this.requestId = n;
    }

    public int get_type() {
        return this.operation;
    }

    public void set_type(int n) {
        this.operation = n;
    }

    public boolean valid() {
        if (this.operation < 0) {
            return false;
        }
        if (this.operation > 7) {
            return false;
        }
        if (this.errorStatus < 0) {
            return false;
        }
        return this.errorStatus <= 18 || this.errorStatus >= 100 && this.errorStatus <= 103;
    }

    public void fix() {
        if (this.errorStatus == 0) {
            return;
        }
        if (this.errorIndex == 0) {
            this.errorStatus = 0;
            return;
        }
        if (this.errorIndex - 1 <= this.varBindList.size()) {
            this.varBindList.removeElementAt(this.errorIndex - 1);
        }
        this.errorStatus = 0;
        this.errorIndex = 0;
    }

    public boolean equals(SnmpPDU snmpPDU) {
        if (!super.equals(snmpPDU)) {
            return false;
        }
        if (this.errorIndex != snmpPDU.errorIndex) {
            return false;
        }
        if (this.operation != snmpPDU.operation) {
            return false;
        }
        return this.requestId == snmpPDU.requestId;
    }

    public static String getErrorStatusString(int n) {
        switch (n) {
            case 100: {
                return "Timeout";
            }
            case 101: {
                return "Send Error";
            }
            case 102: {
                return "Session Terminated";
            }
            case 103: {
                return "Decode Error";
            }
        }
        return errorStatusString[n];
    }

    public String getErrorStatusString() {
        return SnmpPDU.getErrorStatusString(this.errorStatus);
    }

    public String getOperationString() {
        return operationString[this.operation];
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer("Message :");
            stringBuffer.append(" version=" + this.version);
            if (this.communityString != null) {
                stringBuffer.append(" communityString=" + this.communityString.toDisplayString());
            } else {
                stringBuffer.append(" communityString=<value for session>");
            }
            if (this.errorStatus >= 0 && this.errorStatus < errorStatusString.length) {
                stringBuffer.append("\n          errorStatus=" + errorStatusString[this.errorStatus]);
            } else if (this.errorStatus == 100) {
                stringBuffer.append("\n          errorStatus=Timeout");
            } else if (this.errorStatus == 101) {
                stringBuffer.append("\n          errorStatus=SendError");
            } else if (this.errorStatus == 102) {
                stringBuffer.append("\n          errorStatus=Session Terminated");
            } else if (this.errorStatus == 103) {
                stringBuffer.append("\n          errorStatus=Decode Error");
            } else {
                stringBuffer.append("\n          errorStatus=" + this.errorStatus);
            }
            stringBuffer.append(" errorIndex=" + this.errorIndex);
            if (this.operation >= 0 && this.operation <= 7) {
                stringBuffer.append(" operation=" + operationString[this.operation]);
            } else {
                stringBuffer.append(" operation=" + this.operation);
            }
            stringBuffer.append(" requestId=" + this.requestId + " correlator=" + this.correlator + "\n          ");
            stringBuffer.append(this.varBindListToString());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Message cannot be formatted";
        }
    }
}

