/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.PrintStream;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.snmp.BasicConfig;
import org.eclipse.aperi.snmp.Ebcdic;
import org.eclipse.aperi.snmp.IConfig;
import org.eclipse.aperi.snmp.ITracer;
import org.eclipse.aperi.snmp.SessionSweeper;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpStatistics;
import org.eclipse.aperi.snmp.SnmpTracer;
import org.eclipse.aperi.snmp.StreamTracer;
import org.eclipse.aperi.snmp.utils.TimerService;

public class SnmpV1API {
    private static String DEFAULT_TRACER = "org.eclipse.aperi.snmp.BaseTracer";
    private static String DEFAULT_CONFIG = "org.eclipse.aperi.snmp.BasicConfig";
    static final int default_trace_port = 7777;
    public static boolean exposeSecurityInfo = true;
    static final String apiVersion = "7.2.2";
    static ITracer tracer = null;
    static SessionSweeper sweeper = null;
    static IConfig config = null;
    public static String localHost = null;
    public static int localPort = 9876;
    protected static boolean initialized = false;
    protected static boolean returnBigInteger = false;
    private static SnmpStatistics stats = null;
    protected static DatagramSocket trapSocket = null;
    private static int trapSessions = 0;

    protected SnmpV1API() {
    }

    public static synchronized void initialize(String string) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(string, 7777, true);
    }

    public static synchronized void initialize() throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", 7777, true);
    }

    public static synchronized void initialize(int n) throws SnmpSocketException, Exception {
        SnmpV1API.initialize("", n, true);
    }

    public static synchronized void initialize(String string, int n) throws SnmpSocketException, Exception {
        SnmpV1API.initialize(string, n, true);
    }

    public static synchronized void initialize(String string, int n, boolean bl) throws SnmpSocketException, Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.snmp.SnmpV1API");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        SnmpV1API.initialize(string, n, bl, DEFAULT_TRACER, DEFAULT_CONFIG, clazz.getClassLoader());
    }

    public static synchronized void initialize(String string, int n, boolean bl, String string2, String string3, ClassLoader classLoader) throws SnmpSocketException, Exception {
        Class<?> clazz;
        block21: {
            if (initialized) {
                return;
            }
            if ("OS/390".equals(System.getProperty("os.name"))) {
                Ebcdic.useEBCDIC = true;
            }
            try {
                stats = new SnmpStatistics();
                TimerService.initialize();
                if (n > 0) {
                    SnmpTracer.initialize(n);
                }
                if (bl) {
                    initialized = true;
                }
            }
            catch (SocketException socketException) {
                if (TimerService.isReady()) {
                    TimerService.terminate();
                    Thread.yield();
                }
                if (SnmpTracer.isReady()) {
                    SnmpTracer.terminate();
                    Thread.yield();
                }
                throw new SnmpSocketException(socketException.getMessage());
            }
            if (string2 == null) {
                string2 = DEFAULT_TRACER;
            }
            clazz = null;
            clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            tracer = (ITracer)clazz.newInstance();
            try {
                sweeper = new SessionSweeper();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Class<?> clazz2;
                if (noClassDefFoundError.getMessage().equals("com/tivoli/util/Wakeable")) break block21;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.snmp.SnmpV1API");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                tracer.trace(clazz2, "NoClassDefFoundError starting SessionSweeper:" + noClassDefFoundError.toString());
            }
            catch (Throwable throwable) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.snmp.SnmpV1API");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                tracer.trace(clazz3, "Error starting SessionSweeper:" + throwable.toString());
            }
        }
        if (string3 == null) {
            string3 = DEFAULT_CONFIG;
        }
        try {
            clazz = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            config = (IConfig)clazz.newInstance();
        }
        catch (Throwable throwable) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.snmp.SnmpV1API");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            tracer.trace(clazz4, "Using default configuration due to an error initializing config interface:" + throwable.toString());
            config = new BasicConfig();
        }
    }

    public static IConfig getConfig() {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminate() {
        Vector vector = SnmpSession.sessions;
        synchronized (vector) {
            initialized = false;
            while (SnmpSession.sessions.size() > 0) {
                Enumeration enumeration = SnmpSession.sessions.elements();
                SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
                snmpSession.close();
            }
        }
        tracer = null;
        if (sweeper != null) {
            sweeper.stop();
            sweeper = null;
        }
        TimerService.terminate();
        Thread.yield();
        SnmpTracer.terminate();
        Thread.yield();
    }

    protected static void initializeTraps() throws SocketException {
        if (trapSocket == null) {
            try {
                trapSocket = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new DatagramSocket();
                    }
                });
            }
            catch (Exception exception) {
                throw new SnmpSocketException(exception.getMessage());
            }
        }
        ++trapSessions;
    }

    public static void terminateTraps() {
        if (--trapSessions <= 0 && trapSocket != null) {
            trapSocket.close();
            trapSocket = null;
        }
    }

    public static boolean isTracing() {
        if (tracer != null) {
            return tracer.isTracing();
        }
        return false;
    }

    public static void trace(Object object, String string) {
        try {
            tracer.trace(object, string);
        }
        catch (Throwable throwable) {}
    }

    public static void trace(String string) {
        try {
            tracer.trace(tracer, string);
        }
        catch (Throwable throwable) {}
    }

    public static SnmpStatistics getSnmpStats() {
        return stats;
    }

    public static synchronized void startTrace(PrintStream printStream) {
        if (tracer instanceof StreamTracer) {
            ((StreamTracer)((Object)tracer)).setOutputStream(printStream);
        }
        tracer.startTracing();
    }

    public static synchronized void stopTrace() {
        if (tracer.isTracing()) {
            tracer.stopTracing();
        }
    }

    public static void setSecurityInfoPolicy(boolean bl) {
        exposeSecurityInfo = bl;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public static void useBigInteger() {
        returnBigInteger = true;
    }

    public static void useBigInteger(boolean bl) {
        returnBigInteger = bl;
    }

    public static void useLong() {
        returnBigInteger = false;
    }

    public static boolean isCounter64Full() {
        return returnBigInteger;
    }

    public static void main(String[] stringArray) {
        System.out.println("This is the Java SNMP protocol stack version 7.2.2");
    }
}

