/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.snmp.PollingDriver;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.TablePoller;
import org.eclipse.aperi.snmp.TablePollingInfo;
import org.eclipse.aperi.snmp.WalkThread;
import org.eclipse.aperi.snmp.data.OID;

class TableWalker {
    protected Vector pollers;
    protected Vector rows;
    protected OID tableoid;
    protected OID trustedColumn;
    protected SnmpSession session;
    protected int[] index;
    protected int interval;
    protected boolean polling;
    protected boolean removed;
    protected boolean rescan;
    protected PollingDriver driver;

    public TableWalker(OID oID, OID oID2, int[] nArray, int n, PollingDriver pollingDriver, SnmpSession snmpSession) {
        this.tableoid = oID;
        this.trustedColumn = oID2;
        this.session = snmpSession;
        this.pollers = new Vector();
        this.rows = new Vector();
        this.interval = n;
        this.index = nArray;
        this.driver = pollingDriver;
        this.polling = false;
        this.removed = false;
        this.rescan = false;
    }

    public void addPoller(TablePollingInfo tablePollingInfo) {
        if (this.pollers.size() == 0) {
            WalkThread walkThread = new WalkThread(this);
            walkThread.start();
        } else {
            int n = ((TablePoller)tablePollingInfo.poller).oids.length;
            int n2 = 0;
            while (n2 < this.rows.size()) {
                OID oID = (OID)this.rows.elementAt(n2);
                tablePollingInfo.newValues.addElement(new Serializable[n]);
                tablePollingInfo.oldValues.addElement(new Serializable[n]);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("SnmpSession called rowAdded (" + tablePollingInfo.cookie + "," + oID + ")");
                }
                Object object = ((TablePoller)tablePollingInfo.poller).tableRef.rowAdded(tablePollingInfo.cookie, oID);
                tablePollingInfo.rowCookie.addElement(object);
                ++n2;
            }
        }
        this.pollers.addElement(tablePollingInfo);
        this.removed = false;
    }

    public void removePoller(TablePollingInfo tablePollingInfo) {
        this.pollers.removeElement(tablePollingInfo);
        if (this.pollers.size() == 0) {
            this.removed = true;
            this.driver.tables.removeElement(this);
        }
    }

    public void walkTheTable() {
        if (!this.removed) {
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("SnmpSession walkTheTable() called for table " + this.tableoid + " trustedColumn " + this.trustedColumn);
            }
            WalkThread walkThread = new WalkThread(this);
            walkThread.start();
        }
    }
}

