/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.Serializable;
import org.eclipse.aperi.snmp.Ebcdic;
import org.eclipse.aperi.snmp.Translate;
import org.eclipse.aperi.snmp.data.Hex;

public class OctetString
implements Serializable {
    private static byte[] convert;
    public byte[] value;

    static {
        byte[] byArray = new byte[256];
        byArray[49] = 1;
        byArray[50] = 2;
        byArray[51] = 3;
        byArray[52] = 4;
        byArray[53] = 5;
        byArray[54] = 6;
        byArray[55] = 7;
        byArray[56] = 8;
        byArray[57] = 9;
        byArray[65] = 10;
        byArray[66] = 11;
        byArray[67] = 12;
        byArray[68] = 13;
        byArray[69] = 14;
        byArray[70] = 15;
        byArray[97] = 10;
        byArray[98] = 11;
        byArray[99] = 12;
        byArray[100] = 13;
        byArray[101] = 14;
        byArray[102] = 15;
        convert = byArray;
    }

    public OctetString(String string) {
        this(string, false);
    }

    public OctetString(String string, boolean bl) {
        if (bl) {
            this.value = string.getBytes();
            if (Ebcdic.useEBCDIC) {
                int n = 0;
                while (n < this.value.length) {
                    this.value[n] = Translate.toAscii(this.value[n]);
                    ++n;
                }
            }
        } else {
            int n = 0;
            if (string != null) {
                int n2;
                byte[] byArray;
                String string2 = string;
                if (string.length() % 2 != 0) {
                    string2 = String.valueOf(string) + "0";
                }
                if (Ebcdic.useEBCDIC) {
                    byArray = string2.getBytes();
                    n2 = 0;
                    while (n2 < byArray.length) {
                        byArray[n2] = Translate.toAscii(byArray[n2]);
                        ++n2;
                    }
                } else {
                    byArray = string2.getBytes();
                }
                this.value = new byte[string2.length() / 2];
                n2 = 0;
                while (n2 < string2.length()) {
                    this.value[n++] = (byte)(convert[byArray[n2]] << 4 | convert[byArray[n2 + 1]]);
                    n2 += 2;
                }
            } else {
                this.value = new byte[0];
            }
        }
    }

    public OctetString(byte[] byArray) {
        this.value = byArray;
    }

    public OctetString(OctetString octetString) {
        if (octetString.value == null) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[octetString.value.length];
        int n = 0;
        while (n < this.value.length) {
            this.value[n] = octetString.value[n];
            ++n;
        }
    }

    public OctetString(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.value[n3] = byArray[n++];
            ++n3;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OctetString) {
            OctetString octetString = (OctetString)object;
            boolean bl = true;
            if (this.value == null && octetString.value == null) {
                return true;
            }
            if (this.value == null || octetString.value == null) {
                return false;
            }
            if (this.value.length == octetString.value.length) {
                int n = 0;
                while (bl && n < this.value.length) {
                    bl = this.value[n] == octetString.value[n];
                    ++n;
                }
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public String toString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        return Hex.toString(this.value);
    }

    public String toDisplayString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        if (Ebcdic.useEBCDIC) {
            byte[] byArray = new byte[this.value.length];
            int n = 0;
            while (n < this.value.length) {
                byArray[n] = Translate.toEbcdic(this.value[n]);
                ++n;
            }
            return new String(byArray, 0, byArray.length);
        }
        return new String(this.value, 0, this.value.length);
    }

    public boolean isDisplayString() {
        if (this.value == null || this.value.length == 0) {
            return true;
        }
        int n = 0;
        while (n < this.value.length) {
            if (this.value[n] < 32 || this.value[n] > 126) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

