/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.api.IDiskCollectionService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.collection.DiskProbeDispatcher;
import org.eclipse.aperi.disk.collection.ProbeCompleteSubsystem;
import org.eclipse.aperi.disk.collection.ProbeESS11SubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericArraySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericMaskingMappingProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericSubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeGenericVolumeProcess;
import org.eclipse.aperi.disk.collection.ProbeHDS11SubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCLegacySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCMaskingMappingProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCNonLegacySubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSVCSubsystemProcess;
import org.eclipse.aperi.disk.collection.ProbeSunArraySubsystemProcess;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.discovery.TopLevelDiscoveryProcess;
import org.eclipse.aperi.disk.discovery.TopLevelProcess;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.util.osgi.ServiceHelper;

public class DiskCollectionOperations
extends DiskOperations
implements IDiskCollectionService,
DiscoveryConstants {
    public DiskCollectionOperations(DiskManager diskManager) {
        super(diskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
        this.registerDiskManagerProcesses();
    }

    private IDiscover getDiscoverProxy() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.interfaces.IDiscover");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IDiscover)this.cDM.getServiceHelper().bindLocal(clazz);
    }

    private void registerDiskManagerProcesses() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        Class<?> clazz14;
        Class<?> clazz15;
        ServiceHelper serviceHelper = this.cDM.getServiceHelper();
        try {
            clazz15 = Class.forName("org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IDiscoverRouterService iDiscoverRouterService = (IDiscoverRouterService)serviceHelper.bindLocal(clazz15);
        iDiscoverRouterService.addProcess("collectStorageSubsystemsFromCIMOM", (IDiscoverProcess)new TopLevelDiscoveryProcess("collectStorageSubsystemsFromCIMOM", true));
        iDiscoverRouterService.addProcess("dispatchDiscoveryProcess", (IDiscoverProcess)new TopLevelProcess("dispatchDiscoveryProcess", false));
        ProbeGenericSubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeGenericArraySubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeGenericMaskingMappingProcess.registerSteps(iDiscoverRouterService);
        ProbeSVCMaskingMappingProcess.registerSteps(iDiscoverRouterService);
        ProbeSVCSubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeSVCLegacySubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeSVCNonLegacySubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeHDS11SubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeSunArraySubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeESS11SubsystemProcess.registerSteps(iDiscoverRouterService);
        ProbeGenericVolumeProcess.registerSteps(iDiscoverRouterService);
        iDiscoverRouterService.addProcess("probeDiskDispatcher", (IDiscoverProcess)new DiskProbeDispatcher("probeDiskDispatcher", false));
        iDiscoverRouterService.addProcess("collectCompleteStorageSubsystem", (IDiscoverProcess)new ProbeCompleteSubsystem("collectCompleteStorageSubsystem", true));
        iDiscoverRouterService.addProcess("RegisteredProfile", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover All CIM_RegisteredProfile ", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_RegisteredProfile")}, false));
        iDiscoverRouterService.addProcess("ENUM_COMPUTERSYSTEM", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover All CIM_COMPUTERSYSTEMS ", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_ComputerSystem")}, false));
        try {
            clazz14 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("OBJECTMANAGER", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM ObjectManager", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_ElementConformsToProfile", (String)"CIM_ObjectManager", null, null), "IN_SYSTEM_OBJECTMANAGER", clazz14.getName(), false));
        try {
            clazz13 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("SUBPROFILE", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM SubProfile ", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_SubProfileRequiresProfile", (String)"CIM_RegisteredSubProfile", null, null), "IN_SYSTEM_SUBPROFILE", clazz13.getName(), false));
        try {
            clazz12 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("COMPUTERSYSTEM", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Computersystem ", Query.associators((String)"CIM_RegisteredProfile", (String)"CIM_ElementConformsToProfile", (String)"CIM_ComputerSystem", null, null), "IN_SYSTEM_COMPUTERSYSTEM", clazz12.getName(), false));
        try {
            clazz11 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("product", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Product ", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_ProductPhysicalComponent", (String)"CIM_Product", null, null), "IN_SYSTEM_product", clazz11.getName(), false));
        try {
            clazz10 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("PHYSICALPACKAGING", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM PhysicalPackaging ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemPackaging", (String)"CIM_PhysicalPackage", null, null), "IN_SYSTEM_PHYSICALPACKAGING", clazz10.getName(), false));
        try {
            clazz9 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("REMOTESERVICE", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM RemoteServiceAccessPoint ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SAPAvailableForElement", (String)"CIM_RemoteServiceAccessPoint", null, null), "IN_SYSTEM_REMOTESERVICE", clazz9.getName(), false));
        try {
            clazz8 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("REMOTESERVICE2", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM RemoteServiceAccessPoint SMIS 1.1 ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedAccessPoint", (String)"CIM_RemoteServiceAccessPoint", null, null), "IN_SYSTEM_REMOTESERVICE2", clazz8.getName(), false));
        try {
            clazz7 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("NOTESOFCLUSTER", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM Notes ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"CIM_ComputerSystem", null, null), "IN_SYSTEM_NOTESOFCLUSTER", clazz7.getName(), false));
        try {
            clazz6 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("SOFTWAREIDENTITY", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM SoftwareIdentiy ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_InstalledSoftwareIdentity", (String)"CIM_SoftwareIdentity", null, null), "IN_SYSTEM_SOFTWAREIDENTITY", clazz6.getName(), false));
        try {
            clazz5 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("remoteCluster", (IDiscoverProcess)new AssociatorCIMQuery("Discover CIM RemoteCluster ", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSSVC_RemotePartnership", (String)"IBMTSSVC_RemoteCluster", null, null), "IN_SYSTEM_remoteCluster", clazz5.getName(), false));
        try {
            clazz4 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("ESSCLUSTER", (IDiscoverProcess)new AssociatorCIMQuery("Discover ESS Cluster ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"IBMTSESS_Cluster", null, null), "IN_SYSTEM_ESSCLUSTER", clazz4.getName(), false));
        try {
            clazz3 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("CAPABILITIES", (IDiscoverProcess)new AssociatorCIMQuery("Discover MaskingCapabilities ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ElementCapabilities", (String)"CIM_ProtocolControllerMaskingCapabilities", null, null), "IN_SYSTEM_CAPABILITIES", clazz3.getName(), false));
        try {
            clazz2 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("CONFIGURATIONSERVICE", (IDiscoverProcess)new AssociatorCIMQuery("Discover StorageConfigurationService ", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedService", (String)"CIM_StorageConfigurationService", null, null), "IN_SYSTEM_CONFIGURATIONSERVICE", clazz2.getName(), false));
        try {
            clazz = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess("CONFIGURATIONCAPABILITIES", (IDiscoverProcess)new AssociatorCIMQuery("Discover CONFIGURATIONCAPABILITIES ", Query.associators((String)"CIM_StorageConfigurationService", (String)"CIM_ElementCapabilities", (String)"CIM_StorageConfigurationCapabilities", null, null), "IN_SYSTEM_CONFIGURATIONCAPABILITIES", clazz.getName(), false));
        iDiscoverRouterService.addProcess("CIMOMVersion", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover the CIMOMVersion ", false, new Query[]{Query.enumerateInstancesQuery((String)"LSISSI_Provider")}, false));
    }

    public AsyncResult discoverStorageSubsystems(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"discoverStorageSubsystems", (Object[])new Object[]{stringArray});
        Object var3_3 = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"CimomIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            AsyncResult asyncResult2 = new AsyncResult(0, -1);
            hashtable.put("CIMOMID_PARAM", stringArray);
            hashtable.put("Type", "ToplevelStorageSubsystem");
            String string = this.getDiscoverProxy().discover("dispatchDiscoveryProcess", hashtable);
            asyncResult = asyncResult2 = this.getDiscoverProxy().getJobStatus(string);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit(var3_3);
            throw throwable;
        }
        logTraceHelper.exit(var3_3);
        return asyncResult;
    }

    private Object getCimomParams(CIMOM cIMOM) {
        String[] stringArray = new String[]{cIMOM.getServiceUrl(), cIMOM.getInteropSchemaNamespace(), cIMOM.getUserId(), cIMOM.getPassword(), cIMOM.getSoftwareLevel()};
        return stringArray;
    }

    public AsyncResult probeStorageSubsystems(String[] stringArray, Integer n) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.probeStorageSubsystems(stringArray, (int)n);
    }

    public AsyncResult probeStorageSubsystems(String[] stringArray, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"probeStorageSubsystems", (Object[])new Object[]{stringArray, new Integer(n)});
        AsyncResult asyncResult2 = null;
        try {
            String string;
            ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
            ParameterChecker.assertValidPrimitiveParameterInt_BitMask((int)2, (String)"CollectionType", (int)n, (int)6, (LogTraceHelper)logTraceHelper);
            String[] stringArray2 = new String[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = stringArray[n2];
                DBConnection dBConnection = null;
                StorageSubsystem storageSubsystem = null;
                try {
                    dBConnection = ServiceUtils.getConnection();
                    storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)dBConnection);
                    dBConnection.commit();
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException, (LogTraceHelper)logTraceHelper);
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
                }
                catch (IDParseException iDParseException) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID [" + n2 + "] : " + string), (LogTraceHelper)logTraceHelper);
                }
                if (storageSubsystem == null) {
                    throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID [" + n2 + "] : " + string), (LogTraceHelper)logTraceHelper);
                }
                stringArray2[n2] = String.valueOf(storageSubsystem.getSubsystemId());
                ++n2;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("SUBSYSTEMIDS_PARAM", stringArray);
            hashtable.put("DEVICEIDS_PARAM", stringArray2);
            hashtable.put("COLLECTIONTYPE_PARAM", new Integer(n));
            string = this.getDiscoverProxy().discover("probeDiskDispatcher", hashtable);
            asyncResult = asyncResult2 = this.getDiscoverProxy().getJobStatus(string);
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            logTraceHelper.exit(asyncResult2);
            throw throwable;
        }
        logTraceHelper.exit((Object)asyncResult2);
        return asyncResult;
    }

    public AsyncResult probeStorageVolume(String string, String string2, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"probeStorageVolumes", (Object[])new Object[]{string2, string, new Integer(n)});
        AsyncResult asyncResult2 = null;
        DBConnection dBConnection = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemID", (Object)string, (LogTraceHelper)logTraceHelper);
            ParameterChecker.assertMandatoryParameter((int)2, (String)"VolumeID", (Object)string2, (LogTraceHelper)logTraceHelper);
            ParameterChecker.assertValidPrimitiveParameterInt_BitMask((int)3, (String)"CollectionType", (int)n, (int)6, (LogTraceHelper)logTraceHelper);
            String string3 = null;
            String string4 = string;
            StorageSubsystem storageSubsystem = null;
            try {
                dBConnection = ServiceUtils.getConnection();
                storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string4, (DBConnection)dBConnection);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021657E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID: " + string4), (LogTraceHelper)logTraceHelper);
            }
            if (storageSubsystem == null) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("SubsystemID : " + string4), (LogTraceHelper)logTraceHelper);
            }
            string3 = String.valueOf(storageSubsystem.getSubsystemId());
            StorageVolume storageVolume = null;
            String string5 = null;
            try {
                storageVolume = ExternalKeyManager.getStorageVolume((String)string2, (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
                string5 = String.valueOf(storageVolume.getSvid());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021504E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)("VolumeID : " + string2), (LogTraceHelper)logTraceHelper);
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("SUBSYSTEMID", string);
            hashtable.put("DEVICEID", string3);
            hashtable.put("VOLUMEID_PARAM", string5);
            hashtable.put("COLLECTIONTYPE_PARAM", new Integer(n));
            String string6 = this.getDiscoverProxy().discover("probeVolumeProcessName", hashtable);
            asyncResult = asyncResult2 = this.getDiscoverProxy().getJobStatus(string6);
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {
                dBConnection.close();
            }
            catch (Throwable throwable2) {}
            logTraceHelper.exit(asyncResult2);
            throw throwable;
        }
        try {
            dBConnection.close();
        }
        catch (Throwable throwable) {}
        logTraceHelper.exit((Object)asyncResult2);
        return asyncResult;
    }
}

