/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.DiskManagerFilterKeys;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.api.impl.DiskReportingOperationsBase;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.IStorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.StorageConfigurationPluginFactory;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Model;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskReportingOperations
extends DiskOperations
implements IDiskReportingService,
DiskManagerFilterKeys {
    protected static final long VOL_SIZE_RANGE_OPERN_TIMEOUT = 300000L;

    public DiskReportingOperations(DiskManager diskManager) {
        super(diskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageSubsystems(HashMap hashMap) throws ServerException, InvalidParameterException {
        String[] stringArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystems", (Object[])new Object[]{hashMap});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                stringArray = DiskReportingOperationsBase.getStorageSubsystems(hashMap, logTraceHelper, dBConnection);
                Object var6_6 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageSubsystemAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageSubsystemAttributes", (Object[])new Object[]{stringArray, stringArray2});
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hashMapArray2 = DiskReportingOperationsBase.getStorageSubsystemAttributes(stringArray, stringArray2, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)hashMapArray);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit((Object)hashMapArray);
        return hashMapArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getPortsForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getPortsForSubsystem", (Object[])new Object[]{string, hashMap});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                stringArray = DiskReportingOperationsBase.getPortsForSubsystem(string, hashMap, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getPortAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getPortAttributes", (Object[])new Object[]{stringArray, stringArray2});
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hashMapArray2 = DiskReportingOperationsBase.getPortAttributes(stringArray, stringArray2, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)hashMapArray);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit((Object)hashMapArray);
        return hashMapArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStoragePoolsForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStoragePoolsForSubsystem", (Object[])new Object[]{string, hashMap});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                stringArray = DiskReportingOperationsBase.getStoragePoolsForSubsystem(string, hashMap, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStoragePoolAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStoragePoolAttributes", (Object[])new Object[]{stringArray, stringArray2});
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hashMapArray2 = DiskReportingOperationsBase.getStoragePoolAttributes(stringArray, stringArray2, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)hashMapArray);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit((Object)hashMapArray);
        return hashMapArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageVolumesForPool(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForPool", (Object[])new Object[]{string, hashMap});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                stringArray = DiskReportingOperationsBase.getStorageVolumesForPool(string, hashMap, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getStorageVolumesForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        String[] stringArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageVolumesForSubsystem", (Object[])new Object[]{string, hashMap});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                stringArray = DiskReportingOperationsBase.getStorageVolumesForSubsystem(string, hashMap, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageVolumeAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAttributes", (Object[])new Object[]{stringArray, stringArray2});
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hashMapArray2 = DiskReportingOperationsBase.getStorageVolumeAttributes(stringArray, stringArray2, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)hashMapArray);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit((Object)hashMapArray);
        return hashMapArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getStorageVolumeAssignments(String[] stringArray, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap[] hashMapArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getStorageVolumeAssignments", (Object[])new Object[]{stringArray, hashMap});
        HashMap[] hashMapArray = new HashMap[stringArray.length];
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hashMapArray2 = DiskReportingOperationsBase.getStorageVolumeAssignments(stringArray, hashMap, logTraceHelper, dBConnection);
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)hashMapArray);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit((Object)hashMapArray);
        return hashMapArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getHostInfo(String string, HashMap hashMap, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        HashMap hashMap3;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getHostInfo", (Object[])new Object[]{string, hashMap});
        DBConnection dBConnection = ServiceUtils.getConnection();
        HashMap hashMap2 = new HashMap();
        try {
            try {
                hashMap3 = DiskReportingOperationsBase.getHostInfo(string, hashMap, bl, logTraceHelper, dBConnection);
                Object var8_8 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(hashMap2);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(hashMap2);
        return hashMap3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HostType[] getHostTypes(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        HostType[] hostTypeArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getHostTypes", (Object[])new Object[]{string});
        LinkedList linkedList = new LinkedList();
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                hostTypeArray = DiskReportingOperationsBase.getHostTypes(string, logTraceHelper, dBConnection);
                Object var6_6 = null;
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                dBConnection.close();
            }
            catch (SQLException sQLException2) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(linkedList);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        dBConnection.close();
        logTraceHelper.exit(linkedList);
        return hostTypeArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long[] getSupportedVolumeSizeRange(String string, int n, int n2, int n3) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        long[] lArray2;
        LogTraceHelper logTraceHelper;
        block9: {
            logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getSupportedVolumeSizeRange", (Object[])new Object[]{string});
            lArray2 = null;
            DBConnection dBConnection = ServiceUtils.getConnection();
            try {
                try {
                    lArray = lArray2 = DiskReportingOperationsBase.getSupportedVolumeSizeRange(string, n, n2, n, logTraceHelper, dBConnection);
                    Object var9_9 = null;
                    if (dBConnection == null) break block9;
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (SQLException sQLException2) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException2.getMessage(), (LogTraceHelper)logTraceHelper);
                    }
                }
                logTraceHelper.exit((Object)lArray2);
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            dBConnection.close();
        }
        logTraceHelper.exit((Object)lArray2);
        return lArray;
    }

    public long[] getDefaultSupportedVolumeSizeRange(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        long[] lArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getDefaultSupportedVolumeSizeRange", (Object[])new Object[]{string});
        long[] lArray2 = null;
        DBConnection dBConnection = null;
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"StoragePoolID", (Object)string, (LogTraceHelper)logTraceHelper);
            StorageSubsystem storageSubsystem = null;
            StoragePool storagePool = null;
            CIMObjectPath cIMObjectPath = null;
            CIMObjectPath cIMObjectPath2 = null;
            String string2 = null;
            try {
                string2 = ExternalKeyConverter.frameKeyStorageSubsystemFromPool((String)string, (LogTraceHelper)logTraceHelper);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN020003E", (Object)string, (LogTraceHelper)logTraceHelper);
            }
            dBConnection = ServiceUtils.getConnection();
            try {
                storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
                storagePool = ExternalKeyManager.getStoragePool((String)string, (int)storageSubsystem.getSubsystemId(), (DBConnection)dBConnection);
            }
            catch (IDParseException iDParseException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)iDParseException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getInvalidParameterException((int)1, (String)"HWN021654E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
            CIMOMSelector cIMOMSelector = CIMOMSelector.getSelector();
            CIMOMSelector.SubsystemConnectionData subsystemConnectionData = cIMOMSelector.getCimomForSubsystem(storageSubsystem.getSubsystemId());
            cIMObjectPath = subsystemConnectionData.getSubsystemCop();
            cIMObjectPath2 = ExternalKeyManager.getCIMObjectPath((StoragePool)storagePool, (String)subsystemConnectionData.getCimNamespace());
            ConfigurationParameter configurationParameter = new ConfigurationParameter(storageSubsystem, cIMObjectPath);
            configurationParameter.setCapability(subsystemConnectionData.getCapability());
            configurationParameter.setCimom(subsystemConnectionData.getCimom());
            CIMClientWrapper cIMClientWrapper = CIMClientPool.getClient((String)subsystemConnectionData.getCimom().getUserId(), (String)subsystemConnectionData.getCimom().getPassword(), (String)subsystemConnectionData.getCimom().getServiceUrl(), (String)subsystemConnectionData.getCimom().getInteropSchemaNamespace());
            cIMClientWrapper.setTimeout(300000L);
            configurationParameter.setCIMClientWrapper(cIMClientWrapper);
            IStorageConfigurationPlugin iStorageConfigurationPlugin = StorageConfigurationPluginFactory.getPlugin(configurationParameter);
            lArray = lArray2 = iStorageConfigurationPlugin.getDefaultSupportedVolumeSizeRange(storagePool, cIMObjectPath2);
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)lArray2);
            throw throwable;
        }
        try {
            if (dBConnection != null) {
                dBConnection.close();
            }
        }
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        logTraceHelper.exit((Object)lArray2);
        return lArray;
    }

    public String getOSNameFromOSType(int n) throws RemoteException, ServerException {
        String string;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getOSNameFromOSType", (Object[])new Object[]{new Integer(n)});
        String string2 = null;
        try {
            String string3 = DBConstants.getKeyFromValue((String)"OS_Type", (String)String.valueOf(n));
            string = string2 = DBConstants.getValueFromKey((String)"OS_Name_Type", (String)string3);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            logTraceHelper.exit(string2);
            throw throwable;
        }
        logTraceHelper.exit((Object)string2);
        return string;
    }

    public String getPortNameFromPortType(int n) throws RemoteException, ServerException {
        String string;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getPortNameFromPortType", (Object[])new Object[]{new Integer(n)});
        String string2 = null;
        try {
            string = string2 = DBConstants.getKeyFromValue((String)"Port_Types", (String)String.valueOf(n));
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            logTraceHelper.exit((Object)string2);
            throw throwable;
        }
        logTraceHelper.exit((Object)string2);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVendorNameFromID(int n) throws RemoteException, ServerException {
        String string2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getVendorNameFromID", (Object[])new Object[]{new Integer(n)});
        String string = null;
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                }
                Vendor vendor = ExternalKeyManager.getVendor((String)String.valueOf(n), (DBConnection)dBConnection);
                string2 = string = vendor.getVendorName();
                Object var6_8 = null;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getServerException((String)"HWN021504E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)string);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)string);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getModelNameFromID(int n) throws RemoteException, ServerException {
        String string2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getModelNameFromID", (Object[])new Object[]{new Integer(n)});
        String string = null;
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                }
                Model model = ExternalKeyManager.getModel((String)String.valueOf(n), (DBConnection)dBConnection);
                string2 = string = model.getModelName();
                Object var6_8 = null;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getServerException((String)"HWN021504E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit((Object)string);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)string);
        return string2;
    }
}

